/*
 * Decompiled with CFR 0.152.
 */
package obupdate;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;
import obupdate.jar.JarReader;
import obupdate.ui.UI;
import obupdate.update.UpdateParser;
import obupdate.update.UpdateProcessor;

public class Main
extends Application {
    private static final UI ui = new UI();
    private static JarReader jarReader;
    private static UpdateParser updateParser;
    private static String currentVersion;
    private static String gameDirectory;
    private static boolean isAutoUpdate;
    private static boolean isRunningWindows;

    public void start(Stage primaryStage) {
        gameDirectory = Paths.get("", new String[0]).toAbsolutePath().toString().replace("downloads", "") + File.separatorChar;
        Scene scene = new Scene((Parent)ui.getRoot(), 700.0, 300.0);
        primaryStage.setTitle("Open!batoru Update Service");
        primaryStage.setScene(scene);
        primaryStage.setResizable(false);
        primaryStage.show();
        try {
            jarReader = new JarReader(Paths.get(gameDirectory + "OpenBatoru.jar", new String[0]));
        }
        catch (IOException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR, "File not found!\n" + ex.getMessage(), new ButtonType[0]);
            alert.showAndWait();
            Platform.exit();
            return;
        }
        updateParser = new UpdateParser();
        try {
            System.out.println("Gathering update information...");
            updateParser.gatherUpdateInformation(currentVersion);
        }
        catch (IOException | InterruptedException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR, ex.getMessage(), new ButtonType[0]);
            alert.showAndWait();
            Platform.exit();
            return;
        }
        ui.getProgressPanel().updateOverallProgress(0, updateParser.getDownloadOperations().size());
        ui.getProgressPanel().getUpdateButton().setOnAction(e -> {
            ui.getProgressPanel().getUpdateButton().setDisable(true);
            ui.getProgressPanel().prepareProgressBars();
            UpdateProcessor processor = new UpdateProcessor(updateParser);
            processor.start();
        });
        if (isAutoUpdate) {
            if (!ui.getProgressPanel().getUpdateButton().isDisabled()) {
                ui.getProgressPanel().getUpdateButton().fire();
            } else {
                UpdateProcessor processor = new UpdateProcessor(updateParser);
                processor.runClient();
            }
        }
    }

    public static boolean isAutoUpdate() {
        return isAutoUpdate;
    }

    public static boolean isRunningWindows() {
        return isRunningWindows;
    }

    public static void setCurrentVersion(String version) {
        currentVersion = version;
        ui.updateVersionText(version);
    }

    public static String getCurrentVersion() {
        return currentVersion;
    }

    public static UI getUI() {
        return ui;
    }

    public static JarReader getJarReader() {
        return jarReader;
    }

    public static UpdateParser getUpdateParser() {
        return updateParser;
    }

    public static String getGameDirectory() {
        return gameDirectory;
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-auto")) {
            isAutoUpdate = true;
        }
        isRunningWindows = System.getProperty("os.name").startsWith("Win");
        Main.launch((String[])args);
    }
}

