/*
 * Decompiled with CFR 0.152.
 */
package obupdate.jar;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.stream.Stream;
import obupdate.Main;

public class JarReader {
    private final Path jarPath;
    private final FileSystem jarFileSystem;
    private List<String> contentsManifest;

    public JarReader(Path jarPath) throws IOException {
        this.jarPath = jarPath;
        this.jarFileSystem = FileSystems.newFileSystem(jarPath);
        this.readVersion();
    }

    private void readVersion() throws IOException {
        this.contentsManifest = this.read("META-INF/MANIFEST.MF");
        for (String line : this.contentsManifest) {
            if (!line.startsWith("Client-Version:")) continue;
            Main.setCurrentVersion(line.substring("Client-Version: ".length()));
            return;
        }
        throw new IOException("OpenBatoru.jar: Unknown client version in MANIFEST.MF");
    }

    public List<String> read(String path) throws IOException {
        Path filePath = this.jarFileSystem.getPath(path, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            return Files.readAllLines(filePath);
        }
        throw new IOException("OpenBatoru.jar: " + path);
    }

    public void updateJar(String latestVersion) throws IOException {
        if (latestVersion != null) {
            Path filePath = this.jarFileSystem.getPath("META-INF/MANIFEST.MF", new String[0]);
            List<String> updatedContentsManifest = this.contentsManifest.stream().map(line -> line.replace(Main.getCurrentVersion(), latestVersion)).toList();
            Files.write(filePath, updatedContentsManifest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        this.jarFileSystem.close();
        Path tempFile = Files.createTempFile("updated", ".jar", new FileAttribute[0]);
        try (JarOutputStream jos = new JarOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));
             JarFile jarFile = new JarFile(this.jarPath.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                InputStream is = jarFile.getInputStream(entry);
                jos.putNextEntry(new JarEntry(entry.getName()));
                byte[] buffer = new byte[4096];
                while ((bytesRead = is.read(buffer)) != -1) {
                    jos.write(buffer, 0, bytesRead);
                }
                is.close();
                jos.closeEntry();
            }
        }
        Files.move(tempFile, this.jarPath, StandardCopyOption.REPLACE_EXISTING);
    }

    public void add(Path source, Path destinationInsideJar) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(source, new FileVisitOption[0]);){
                stream.forEach(sourcePath -> {
                    Path relative = source.relativize((Path)sourcePath);
                    Path targetPath = this.jarFileSystem.getPath(destinationInsideJar.toString(), relative.toString());
                    try {
                        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        } else if (Files.isRegularFile(source, new LinkOption[0])) {
            Path targetPath = this.jarFileSystem.getPath(destinationInsideJar.toString(), new String[0]);
            if (targetPath.getParent() != null) {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            }
            Files.copy(source, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void delete(String path) throws IOException {
        Files.deleteIfExists(this.jarFileSystem.getPath(path, new String[0]));
    }
}

