/*
 * Decompiled with CFR 0.152.
 */
package obupdate.ui;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import obupdate.animations.AnimationUITextThinking;
import obupdate.ui.ProgressPanel;
import obupdate.ui.operations.OperationList;

public class UI {
    private final BorderPane root = new BorderPane();
    private final Text textHeader = new Text();
    private final Text textVersion = new Text();
    private AnimationUITextThinking aniThink;
    private final OperationList opList = new OperationList();
    private final ProgressPanel progressPanel = new ProgressPanel();

    public UI() {
        this.root.setPadding(new Insets(10.0));
        StackPane header = new StackPane();
        this.updateHeaderText("Gathering update information...");
        this.textHeader.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)16.0));
        this.updateVersionText("?");
        this.textVersion.setFont(this.textHeader.getFont());
        this.textVersion.setFill((Paint)Color.GREY);
        header.getChildren().addAll((Object[])new Node[]{this.textHeader, this.textVersion});
        StackPane.setAlignment((Node)this.textHeader, (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)this.textVersion, (Pos)Pos.CENTER_RIGHT);
        this.root.setTop((Node)header);
        this.root.setLeft((Node)this.opList);
        this.root.setCenter((Node)this.progressPanel);
        this.opList.setPrefWidth(420.0);
        this.progressPanel.setPrefWidth(260.0);
        BorderPane.setMargin((Node)this.opList, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        BorderPane.setMargin((Node)this.progressPanel, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
    }

    public void updateHeaderText(String text) {
        this.textHeader.setText(text);
    }

    public void updateVersionText(String version) {
        this.textVersion.setText("[" + version + "]");
    }

    public OperationList getOperationList() {
        return this.opList;
    }

    public ProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    public BorderPane getRoot() {
        return this.root;
    }
}

