/*
 * Decompiled with CFR 0.152.
 */
package obupdate.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import obupdate.Main;
import obupdate.ui.operations.VersionEntry;
import obupdate.update.operations.CardDownloadOperation;
import obupdate.update.operations.DownloadUpdateOperation;
import obupdate.update.operations.FileDeleteOperation;
import obupdate.update.operations.FileDownloadOperation;
import obupdate.update.operations.SpecialForceRecompileOperation;
import obupdate.update.operations.SpecialUpdateOperation;
import obupdate.update.operations.UpdateOperation;
import obupdate.web.HTTPReader;

public class UpdateParser {
    private final List<DownloadUpdateOperation> downloadOperations = new ArrayList<DownloadUpdateOperation>();
    private final List<UpdateOperation> miscOperations = new ArrayList<UpdateOperation>();
    private String latestVersion;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gatherUpdateInformation(String version) throws IOException, InterruptedException {
        List<String> content = HTTPReader.readURL("https://open.batoru.moe/game/downloads/updates/" + version + "/index.html");
        if (content.isEmpty() || content.get(0).startsWith("<")) {
            throw new IOException("Failed to gather update data for: " + version + "\nPlease, try again later.");
        }
        int start = 0;
        String nextUpdateVersion = null;
        if (content.get(0).startsWith("U ")) {
            nextUpdateVersion = content.get(0).substring("U ".length());
            if (version.equals(Main.getCurrentVersion())) {
                this.gatherUpdateInformation(nextUpdateVersion);
                return;
            }
            start = 1;
        } else if (version.equals(Main.getCurrentVersion())) {
            if (!Main.isAutoUpdate()) {
                Main.getUI().getProgressPanel().getUpdateButton().setText("Repair");
            }
            Main.getUI().getProgressPanel().getUpdateButton().setDisable(Main.isAutoUpdate());
            Main.getUI().updateHeaderText("Client is up to date!");
        } else {
            Main.getUI().getProgressPanel().getUpdateButton().setDisable(false);
            Main.getUI().updateHeaderText("New updates available:");
        }
        Main.getUI().getOperationList().addOperation(new VersionEntry(version));
        this.latestVersion = version;
        System.out.println("Found: " + this.latestVersion);
        block24: for (int i = start; i < content.size(); ++i) {
            String line = content.get(i);
            if (line.isEmpty()) continue;
            String[] data = line.split(" ", -1);
            String specialFlag = data[data.length - 1];
            boolean isJarOperation = false;
            switch (specialFlag) {
                case "j": {
                    isJarOperation = true;
                    break;
                }
                case "w": {
                    if (Main.isRunningWindows()) break;
                    continue block24;
                }
                case "x": {
                    if (Main.isRunningWindows()) continue block24;
                }
            }
            try {
                switch (data[0]) {
                    case "+": {
                        this.addOperation(line, new FileDownloadOperation(version, data[1], isJarOperation));
                        break;
                    }
                    case "C": {
                        this.addOperation(line, new CardDownloadOperation(version, data[1]));
                        break;
                    }
                    case "-": {
                        this.addOperation(line, new FileDeleteOperation(data[1], isJarOperation));
                        break;
                    }
                    case "!": {
                        if (data[1].equals("FORCE_RECOMPILE")) {
                            this.addOperation(line, new SpecialForceRecompileOperation());
                            break;
                        }
                        System.err.println("Warning: Unknown special command \"" + data[1] + "\"");
                        break;
                    }
                    default: {
                        System.err.println("Warning: Unknown token \"" + data[0] + "\"");
                        break;
                    }
                }
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IOException("Malformed update data for: " + version + "\nToken: " + data[0] + "\nPlease, try again later.");
            }
        }
        if (nextUpdateVersion != null) {
            this.gatherUpdateInformation(nextUpdateVersion);
        }
    }

    private void addOperation(String data, UpdateOperation operation) {
        operation.addUIOperation(data);
        if (operation instanceof DownloadUpdateOperation) {
            DownloadUpdateOperation downloadOperation = (DownloadUpdateOperation)operation;
            this.downloadOperations.removeIf(oldOperation -> {
                boolean shouldRemove = downloadOperation.getPath().equals(oldOperation.getPath());
                if (shouldRemove) {
                    oldOperation.removeUIOperation();
                }
                return shouldRemove;
            });
            this.miscOperations.removeIf(oldOperation -> {
                if (!(oldOperation instanceof FileDeleteOperation)) return false;
                FileDeleteOperation deleteOperation = (FileDeleteOperation)oldOperation;
                if (!downloadOperation.getPath().equals(deleteOperation.getPath())) return false;
                boolean bl = true;
                boolean shouldRemove = bl;
                if (!shouldRemove) return shouldRemove;
                oldOperation.removeUIOperation();
                return shouldRemove;
            });
            this.downloadOperations.add(downloadOperation);
        } else {
            if (operation instanceof SpecialUpdateOperation) {
                this.miscOperations.removeIf(oldOperation -> oldOperation.getClass().equals(operation.getClass()));
            }
            this.miscOperations.add(operation);
        }
    }

    public List<DownloadUpdateOperation> getDownloadOperations() {
        return this.downloadOperations;
    }

    public List<UpdateOperation> getMiscOperations() {
        return this.miscOperations;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

