/*
 * Decompiled with CFR 0.152.
 */
package obupdate.update.operations;

import java.io.IOException;
import java.nio.file.Path;
import javafx.application.Platform;
import obupdate.Main;
import obupdate.ui.ProgressPanel;
import obupdate.update.operations.UpdateOperation;
import obupdate.web.HTTPFileDownloader;

public abstract class DownloadUpdateOperation
extends UpdateOperation {
    private final String version;
    private final String path;
    private ProgressPanel.LockableProgressBar progressBar;
    private static final Object lock = new Object();

    public DownloadUpdateOperation(String version, String path) {
        this.version = version;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec() {
        this.progressBar = Main.getUI().getProgressPanel().getNextFreeProgressBar();
        if (this.progressBar == null) {
            Object object = lock;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    System.err.println(ex.getMessage());
                }
            }
            this.exec();
            return;
        }
        this.progressBar.setLocked(true);
        Platform.runLater(() -> this.progressBar.setProgress(-1.0));
        HTTPFileDownloader downloader = new HTTPFileDownloader((existingFileSize, fileSize) -> Platform.runLater(() -> {
            double percent = 100.0 * (double)existingFileSize / (double)fileSize;
            this.progressBar.setProgress(percent / 100.0);
            this.updateEntryProgress(percent, existingFileSize, fileSize);
        }));
        downloader.setOnDownloadCompleted(this.getOnDownloadCompletedHandler());
        try {
            downloader.download("https://open.batoru.moe/game/downloads/updates/" + this.version + "/files/" + this.getPath(), this.getTemporaryPath());
        }
        catch (IOException | InterruptedException ex) {
            System.err.println("Failed to download file: " + ex.getMessage());
            this.setAsCompleted(UpdateOperation.OperationStatus.FAIL);
        }
    }

    @Override
    public void setAsCompleted(UpdateOperation.OperationStatus status) {
        super.setAsCompleted(status);
        Platform.runLater(() -> Main.getUI().getProgressPanel().incrementOverallProgress());
        if (this.progressBar != null) {
            this.progressBar.setLocked(false);
            lock.notify();
        }
    }

    protected abstract HTTPFileDownloader.OnDownloadCompletedHandler getOnDownloadCompletedHandler();

    protected abstract Path getTemporaryPath();

    public String getPath() {
        return this.path;
    }
}

