/*
 * Decompiled with CFR 0.152.
 */
package obupdate.update.operations;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import obupdate.Main;
import obupdate.update.operations.UpdateOperation;

public class FileDeleteOperation
extends UpdateOperation {
    private final String path;
    private final boolean isJarOperation;

    public FileDeleteOperation(String path, boolean isJarOperation) {
        this.path = path;
        this.isJarOperation = isJarOperation;
    }

    @Override
    public void exec() {
        try {
            if (this.isJarOperation) {
                Main.getJarReader().delete(this.path);
            } else {
                Path targetPath = Path.of(Main.getGameDirectory(), new String[0]).resolve(this.path).normalize();
                if (!targetPath.startsWith(Main.getGameDirectory())) {
                    System.err.println("Failed to delete file: " + String.valueOf(targetPath));
                    this.setAsCompleted(UpdateOperation.OperationStatus.FAIL);
                    return;
                }
                Files.deleteIfExists(targetPath);
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to delete file: " + ex.getMessage());
            this.setAsCompleted(UpdateOperation.OperationStatus.FAIL);
            return;
        }
        this.setAsCompleted(UpdateOperation.OperationStatus.SUCCESS);
    }

    public String getPath() {
        return this.path;
    }
}

