/*
 * Decompiled with CFR 0.152.
 */
package obupdate.update.operations;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import obupdate.Main;
import obupdate.update.operations.DownloadUpdateOperation;
import obupdate.update.operations.UpdateOperation;
import obupdate.web.HTTPFileDownloader;

public class FileDownloadOperation
extends DownloadUpdateOperation {
    private final boolean isJarOperation;

    public FileDownloadOperation(String version, String path, boolean isJarOperation) {
        super(version, path);
        this.isJarOperation = isJarOperation;
    }

    @Override
    public HTTPFileDownloader.OnDownloadCompletedHandler getOnDownloadCompletedHandler() {
        return isSuccessful -> {
            try {
                if (this.isJarOperation) {
                    Main.getJarReader().add(this.getTemporaryPath(), Path.of(this.getPath(), new String[0]));
                    Files.deleteIfExists(this.getTemporaryPath());
                } else {
                    Path targetPath = Path.of(this.getTemporaryPath().toString().replace("downloads" + File.separatorChar + "temp" + File.separatorChar, ""), new String[0]);
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.move(this.getTemporaryPath(), targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                this.setAsCompleted(UpdateOperation.OperationStatus.FAIL);
                return;
            }
            this.setAsCompleted(isSuccessful ? UpdateOperation.OperationStatus.SUCCESS : UpdateOperation.OperationStatus.FAIL);
        };
    }

    @Override
    public Path getTemporaryPath() {
        return Paths.get(Main.getGameDirectory() + "downloads/temp/" + this.getPath(), new String[0]);
    }
}

