/*
 * Decompiled with CFR 0.152.
 */
package obupdate.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class HTTPFileDownloader {
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    private static final int MAX_CHUNK_SIZE = 8192;
    private DownloadProgressHandler handlerProgress;
    private OnDownloadCompletedHandler handlerCompleted;
    private volatile boolean isCanceled;

    public HTTPFileDownloader() {
    }

    public HTTPFileDownloader(DownloadProgressHandler handlerProgress) {
        this.handlerProgress = handlerProgress;
    }

    public void setOnDownloadCompleted(OnDownloadCompletedHandler handlerCompleted) {
        this.handlerCompleted = handlerCompleted;
    }

    public void download(String url, Path destination) throws IOException, InterruptedException {
        HttpRequest headRequest = HttpRequest.newBuilder().uri(URI.create(url)).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<Void> headResponse = HTTP_CLIENT.send(headRequest, HttpResponse.BodyHandlers.discarding());
        HttpHeaders headers = headResponse.headers();
        if ("bytes".equalsIgnoreCase(headers.firstValue("Accept-Ranges").orElse(""))) {
            long existingFileSize;
            long fileSize = Long.parseLong(headers.firstValue("Content-Length").orElseThrow(() -> new RuntimeException("The server didn't provide the Content-Length header")));
            long l = existingFileSize = Files.exists(destination, new LinkOption[0]) ? Files.size(destination) : 0L;
            if (existingFileSize >= fileSize) {
                existingFileSize = 0L;
            }
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            try (RandomAccessFile output = new RandomAccessFile(destination.toFile(), "rw");){
                HttpRequest getRequest = HttpRequest.newBuilder().uri(URI.create(url)).header("Range", "bytes=" + existingFileSize + "-").build();
                HttpResponse<InputStream> getResponse = HTTP_CLIENT.send(getRequest, HttpResponse.BodyHandlers.ofInputStream());
                try (InputStream is = getResponse.body();){
                    int bytesRead;
                    this.isCanceled = false;
                    output.seek(existingFileSize);
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        if (this.isCanceled) {
                            return;
                        }
                        output.write(buffer, 0, bytesRead);
                        existingFileSize += (long)bytesRead;
                        if (this.handlerProgress == null) continue;
                        this.handlerProgress.handle(existingFileSize, fileSize);
                    }
                }
            }
            if (this.handlerCompleted != null) {
                this.handlerCompleted.handle(true);
            }
        } else if (this.handlerCompleted != null) {
            this.handlerCompleted.handle(false);
        }
    }

    public void cancel() {
        this.isCanceled = true;
    }

    @FunctionalInterface
    public static interface DownloadProgressHandler {
        public void handle(long var1, long var3);
    }

    @FunctionalInterface
    public static interface OnDownloadCompletedHandler {
        public void handle(boolean var1);
    }
}

