/*
 * Decompiled with CFR 0.152.
 */
package open.batoru;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import open.batoru.core.Deck;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneNumbers;
import open.batoru.parsers.RestrictedCardsParser;

public class ImageCache {
    public static final ImageCache INSTANCE = new ImageCache();
    public static final Image TEXTURE_ERROR = new Image(ImageCache.class.getResource("/images/_error.png").toExternalForm());
    public static final Image THROBBER = new Image(ImageCache.class.getResource("/images/throbber.png").toExternalForm());
    private final Map<String, Image> cache = new WeakHashMap<String, Image>();
    private final String pathImages;

    private ImageCache() {
        String cachePath = "";
        try {
            cachePath = new File(ImageCache.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getPath();
        }
        catch (URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        this.pathImages = cachePath + "/images";
    }

    public Image getImage(String path) {
        return this.cache.computeIfAbsent(path, k -> new Image("file:images/" + path));
    }

    public Image getImageIcon(String iconName) {
        return this.getImage("icons/" + iconName + ".png");
    }

    public String getHTMLIconPath(String iconName) {
        return "file:" + this.pathImages + "/icons/" + iconName + ".png";
    }

    public static String getColorTexturePath(CardConst.CardColor color) {
        return "textures/colors/" + color.name().toLowerCase() + ".png";
    }

    public static String getZoneTexturePath(FieldZone.ZoneType zoneType) {
        return "textures/zones/zone_" + zoneType.name().toLowerCase() + ".png";
    }

    public static String getBorderIconTexturePath(TargetFilter.TargetHint targetHint) {
        return "textures/border/" + targetHint.getBorderIcon() + ".png";
    }

    public static String getDigitsTexturePath(int digit) {
        return ImageCache.getDigitsTexturePath(digit, FieldZoneNumbers.NumberTexture.GRADIENT);
    }

    public static String getDigitsTexturePath(int digit, FieldZoneNumbers.NumberTexture numberTexture) {
        return "textures/digits/" + numberTexture.name().toLowerCase() + "/" + String.valueOf(digit != Integer.MAX_VALUE ? Integer.valueOf(digit) : "infinity") + ".png";
    }

    public static String getGFXTexturePath(String texture) {
        return "textures/gfx/" + texture + ".png";
    }

    public static String getColorIconPath(CardConst.CardColor color) {
        return "colors/" + color.name().toLowerCase();
    }

    public static String getPlayFormatIconPath(CardConst.PlayFormat playFormat) {
        return ImageCache.getPlayFormatIconPath(playFormat, true);
    }

    public static String getPlayFormatIconPath(CardConst.PlayFormat playFormat, boolean isSmall) {
        return "formats/" + playFormat.getShortLabel() + (isSmall ? "_small" : "");
    }

    public static String getRestrictIconPath(RestrictedCardsParser.RestrictType restrictType) {
        return "restrict/" + restrictType.name().toLowerCase();
    }

    public Image getMainCardBackImage() {
        return this.getImage("BACK_MAIN.jpg");
    }

    public Image getLRIGCardBackImage() {
        return this.getImage("BACK_LRIG.jpg");
    }

    public Image getKeyCardBackImage() {
        return this.getImage("BACK_KEY.jpg");
    }

    public Image getCardImage(String imageSet) {
        if (imageSet == null || imageSet.isEmpty()) {
            return this.getMainCardBackImage();
        }
        if (CardLoader.getImageSetMaskType(imageSet) == CardDataImageSet.MaskType.DOUBLE_FACED_UR) {
            imageSet = imageSet.substring(1);
        }
        if (!this.cache.containsKey(imageSet)) {
            CardDataImageSet.MaskType maskType;
            Card cardObject;
            Image cardImage = new Image("file:images/cards/" + imageSet + ".jpg");
            Image cachedCardImage = cardImage.isError() ? ((cardObject = CardLoader.getCardByImageSet(imageSet)) != null && Deck.isMainDeckCard(cardObject) ? this.getMainCardBackImage() : this.getLRIGCardBackImage()) : ((maskType = CardLoader.getImageSetMaskType(imageSet)) != CardDataImageSet.MaskType.IGNORE ? this.getSuppressedWatermarkCardImage(imageSet, cardImage, maskType) : cardImage);
            this.cache.put(imageSet, cachedCardImage);
            return cachedCardImage;
        }
        return this.cache.get(imageSet);
    }

    private Image getSuppressedWatermarkCardImage(String imageSet, Image cardImage, CardDataImageSet.MaskType maskType) {
        int endY;
        int endX;
        PixelReader readerMask;
        if (cardImage.getWidth() != 250.0 || cardImage.getHeight() != 349.0) {
            System.err.println("Warning: Wrong dimensions for card image " + imageSet + "! Watermark suppression skipped.");
            return cardImage;
        }
        Card cardObject = CardLoader.getCardByImageSet(imageSet);
        WritableImage imageNew = new WritableImage(cardImage.getPixelReader(), 250, 349);
        if (!CardConst.CardType.isCardInHorizontalOrientation(cardObject.getType()) && maskType != CardDataImageSet.MaskType.VERTICAL) {
            readerMask = this.getImage("masks/SAMPLE.png").getPixelReader();
            startX = 19;
            endX = 230;
            startY = 147;
            endY = 201;
        } else {
            readerMask = this.getImage("masks/SAMPLE_ROTATED.png").getPixelReader();
            startX = 97;
            endX = 151;
            startY = 69;
            endY = 280;
        }
        PixelReader reader = imageNew.getPixelReader();
        PixelWriter writer = imageNew.getPixelWriter();
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                Color colMask = readerMask.getColor(x, y);
                if (!(colMask.getOpacity() > 0.0)) continue;
                Color col = reader.getColor(x, y);
                double r = Math.min(1.0, col.getRed() / colMask.getRed());
                double g = Math.min(1.0, col.getGreen() / colMask.getGreen());
                double b = Math.min(1.0, col.getBlue() / colMask.getBlue());
                writer.setColor(x, y, Color.color((double)r, (double)g, (double)b));
            }
        }
        return imageNew;
    }
}

