/*
 * Decompiled with CFR 0.152.
 */
package open.batoru;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import open.batoru.Main;

public final class Log {
    private static final Path FILE_PATH = Path.of("lastgame.log", new String[0]);

    public static void prepare() {
        if (Main.testPort > 0) {
            return;
        }
        try {
            Files.write(FILE_PATH, new byte[0], StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static void printMessage(Exception ex) {
        Log.printMessage(true, ex.getMessage());
        ex.printStackTrace();
    }

    public static void printMessage(String message) {
        Log.printMessage(false, message);
    }

    public static void printMessage(boolean isError, String message) {
        (isError ? System.err : System.out).println(message);
        Log.logMessage(message);
    }

    private static void logMessage(String message) {
        if (Main.testPort > 0) {
            return;
        }
        try {
            Files.writeString(FILE_PATH, (CharSequence)(message + System.lineSeparator()), StandardOpenOption.APPEND);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static List<String> readLastMessages(int numLines) {
        try {
            ArrayDeque<String> deque = new ArrayDeque<String>(numLines);
            try (BufferedReader reader = Files.newBufferedReader(FILE_PATH);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (deque.size() == numLines) {
                        deque.removeFirst();
                    }
                    deque.addLast(line);
                }
            }
            return new ArrayList<String>(deque);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    private Log() {
    }
}

