/*
 * Decompiled with CFR 0.152.
 */
package open.batoru;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import open.batoru.Main;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.networking.UtilHash;
import open.batoru.parsers.LanguageParser;
import open.batoru.parsers.SettingsParser;
import open.batoru.ui.UI;

public final class Settings {
    public static final Settings INSTANCE = new Settings();
    private String gameVersionClient;
    private String autoUpdateServiceHash;
    private String gameLang;
    private SettingsParser parser;
    private final EnumMap<DeckSource, Deck> decks = new EnumMap(DeckSource.class);
    private boolean attemptedDeckSyncWhileWaitingInRoom;

    private Settings() {
    }

    public void init() {
        if (this.parser != null) {
            return;
        }
        try (JarInputStream jarStream = new JarInputStream(this.getClass().getProtectionDomain().getCodeSource().getLocation().openStream());){
            Manifest manifest = jarStream.getManifest();
            if (manifest != null) {
                Attributes attr = manifest.getMainAttributes();
                this.gameVersionClient = attr.getValue("Client-Version");
            } else {
                System.err.println("Error: Couldn't find MANIFEST.MF in the JAR file.");
            }
        }
        catch (IOException ex) {
            System.err.println("Error: Couldn't read the JAR file or open it.");
        }
        this.autoUpdateServiceHash = UtilHash.generateFileHash(Path.of("downloads/update.jar", new String[0]));
        this.parser = new SettingsParser();
        this.gameLang = this.parser.getValue("LANG");
        LanguageParser.gatherAvailableLanguages();
        LanguageParser.load(this.gameLang);
        File deckFile = new File(this.parser.getValue("DECK"));
        this.decks.put(DeckSource.EDIT, new Deck(deckFile));
        this.decks.put(DeckSource.PLAY, new Deck(deckFile));
        this.clearTempFiles();
    }

    private boolean areDecksSynced() {
        return this.decks.get((Object)DeckSource.EDIT).getSourceFileName().equals(this.decks.get((Object)DeckSource.PLAY).getSourceFileName());
    }

    private boolean isNotWaitingInRoom() {
        return Player.getCurrentRoom() == null || Game.getCurrentGame() != null && Game.getCurrentGame().getGameServerPortOffset() != 0;
    }

    public void loadDeckFile(DeckSource deckSource) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Load Deck");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Deck File", new String[]{"*.deck"}));
        fileChooser.setInitialDirectory(new File("decks/"));
        File deckFile = fileChooser.showOpenDialog((Window)Main.getStage());
        if (deckFile != null) {
            boolean wasSynced = this.areDecksSynced() || this.attemptedDeckSyncWhileWaitingInRoom;
            this.loadNewDeck(deckSource, deckFile);
            if (deckSource == DeckSource.EDIT) {
                UI.getTabDeck().getDeckBuilder().reloadDeck();
                UI.getTabDeck().updateCurrentDeckFileName();
                if (wasSynced) {
                    if (this.isNotWaitingInRoom()) {
                        this.loadNewDeck(DeckSource.PLAY, deckFile);
                        UI.getTabRooms().getControls().updateCurrentDeckFileName();
                        this.attemptedDeckSyncWhileWaitingInRoom = false;
                    } else {
                        this.attemptedDeckSyncWhileWaitingInRoom = true;
                    }
                }
            } else {
                UI.getTabRooms().getControls().updateCurrentDeckFileName();
                this.attemptedDeckSyncWhileWaitingInRoom = false;
            }
        }
    }

    public void saveDeckFile() {
        block17: {
            try {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Save Deck");
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Deck File", new String[]{"*.deck"}));
                try {
                    Path directory = Path.of("decks/", new String[0]);
                    if (!Files.exists(directory, new LinkOption[0])) {
                        Files.createDirectory(directory, new FileAttribute[0]);
                    }
                    fileChooser.setInitialDirectory(directory.toFile());
                }
                catch (IOException ex) {
                    fileChooser.setInitialDirectory(new File("."));
                }
                File newFile = fileChooser.showSaveDialog((Window)Main.getStage());
                if (newFile == null) break block17;
                if (!newFile.getPath().endsWith(".deck")) {
                    newFile = new File(newFile.getPath() + ".deck");
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(newFile));){
                    List<String> deckList = this.decks.get((Object)DeckSource.EDIT).getDeckList();
                    for (String imageSet : deckList) {
                        writer.append(imageSet);
                        writer.newLine();
                    }
                }
                if (this.areDecksSynced() || this.attemptedDeckSyncWhileWaitingInRoom) {
                    if (this.isNotWaitingInRoom()) {
                        this.loadNewDeck(DeckSource.PLAY, newFile);
                        UI.getTabRooms().getControls().updateCurrentDeckFileName();
                        this.attemptedDeckSyncWhileWaitingInRoom = false;
                    } else {
                        this.attemptedDeckSyncWhileWaitingInRoom = true;
                        if (this.areDecksSynced() && UI.getTabRooms().getControls().isDeckLoadButtonDisabled()) {
                            UI.getTabRooms().getControls().updateCurrentDeckFileName(true);
                        }
                    }
                }
                this.loadNewDeck(DeckSource.EDIT, newFile);
                if (this.areDecksSynced() && UI.getTabRooms().getControls().isDeckLoadButtonDisabled()) {
                    UI.getTabRooms().getControls().updateCurrentDeckFileName(true);
                }
                UI.getTabDeck().getDeckBuilder().reloadDeck();
                UI.getTabDeck().updateCurrentDeckFileName();
            }
            catch (IOException ex) {
                System.err.println("Deck Error: " + ex.getMessage());
            }
        }
    }

    public void reloadDeck(DeckSource deckSource) {
        this.loadNewDeck(deckSource, this.decks.get((Object)deckSource).getSourceFile());
    }

    private void loadNewDeck(DeckSource deckSource, File newDeckFile) {
        this.decks.put(deckSource, new Deck(newDeckFile));
        this.loadDeckCards(deckSource);
        this.parser.updateValue("DECK", newDeckFile.getPath());
        this.parser.writeSettings();
    }

    public void loadDeckCards(DeckSource deckSource) {
        Deck deck = this.decks.get((Object)deckSource);
        try (BufferedReader reader = new BufferedReader(new FileReader(deck.getSourceFile()));){
            String imageSet;
            while ((imageSet = reader.readLine()) != null) {
                if (imageSet.isEmpty() || deck.addCard(imageSet) != -1) continue;
                System.err.println("Warning: Attempted to load an invalid card from deck (" + imageSet + "). Ignored.");
            }
        }
        catch (IOException ex) {
            System.err.println("Deck Error: " + ex.getMessage());
        }
    }

    private void clearTempFiles() {
        Path pathTemp = Path.of("downloads/temp", new String[0]);
        try (Stream<Path> stream = Files.walk(pathTemp, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(path -> {
                block10: {
                    try {
                        if (Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".replay")) {
                            Files.delete(path);
                            break block10;
                        }
                        if (!Files.isDirectory(path, new LinkOption[0]) || path == pathTemp) break block10;
                        try (Stream<Path> subFiles = Files.list(path);){
                            if (subFiles.findAny().isEmpty()) {
                                Files.delete(path);
                            }
                        }
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            });
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public SettingsParser getParser() {
        return this.parser;
    }

    public void setGameLanguage(String lang) {
        this.parser.updateValue("LANG", lang);
        this.parser.writeSettings();
    }

    public boolean shouldAlwaysShowImageSetInPreview() {
        return this.parser.getValue("ALWAYS_SHOW_PREVIEW_IMAGESET").equals("1");
    }

    public void setShouldAlwaysShowImageSetInPreview(boolean set) {
        this.parser.updateValue("ALWAYS_SHOW_PREVIEW_IMAGESET", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldPlayPhaseAnimation() {
        return this.parser.getValue("PLAY_ANI_PHASE").equals("1");
    }

    public void setShouldPlayPhaseAnimation(boolean set) {
        this.parser.updateValue("PLAY_ANI_PHASE", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldAutoSaveReplays() {
        return this.parser.getValue("AUTO_SAVE_REPLAYS").equals("1");
    }

    public void setShouldAutoSaveReplays(boolean set) {
        this.parser.updateValue("AUTO_SAVE_REPLAYS", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean isUsingDarkTheme() {
        return this.parser.getValue("UI_THEME").equals("dark");
    }

    public void setUseDarkTheme(boolean set) {
        this.parser.updateValue("UI_THEME", set ? "dark" : "default");
        this.parser.writeSettings();
    }

    public boolean shouldAutoConfirmSIGNIPlacement() {
        return this.parser.getValue("AUTO_CONFIRM_SIGNI").equals("1");
    }

    public void setShouldAutoConfirmSIGNIPlacement(boolean set) {
        this.parser.updateValue("AUTO_CONFIRM_SIGNI", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldAutoConfirmSpellUsage() {
        return this.parser.getValue("AUTO_CONFIRM_SPELL").equals("1");
    }

    public void setShouldAutoConfirmSpellUsage(boolean set) {
        this.parser.updateValue("AUTO_CONFIRM_SPELL", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldAutoConfirmActionActivation() {
        return this.parser.getValue("AUTO_CONFIRM_ACTION").equals("1");
    }

    public void setShouldAutoConfirmActionActivation(boolean set) {
        this.parser.updateValue("AUTO_CONFIRM_ACTION", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldAutoConfirmUseFromLRIGDeck() {
        return this.parser.getValue("AUTO_CONFIRM_LRIG").equals("1");
    }

    public void setShouldAutoConfirmUseFromLRIGDeck(boolean set) {
        this.parser.updateValue("AUTO_CONFIRM_LRIG", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldAutoConfirmChosenCards() {
        return this.parser.getValue("AUTO_CONFIRM_TARGETS").equals("1");
    }

    public void setShouldAutoConfirmChosenCards(boolean set) {
        this.parser.updateValue("AUTO_CONFIRM_TARGETS", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldAutoSkipSIGNIAttackPhase() {
        return this.parser.getValue("AUTO_SKIP_SIGNI").equals("1");
    }

    public void setShouldAutoSkipSIGNIAttackPhase(boolean set) {
        this.parser.updateValue("AUTO_SKIP_SIGNI", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldAutoSkipLRIGAttackPhase() {
        return this.parser.getValue("AUTO_SKIP_LRIG").equals("1");
    }

    public void setShouldAutoSkipLRIGAttackPhase(boolean set) {
        this.parser.updateValue("AUTO_SKIP_LRIG", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldExpandEnerPay() {
        return this.parser.getValue("EXPAND_ENER_PAY").equals("1");
    }

    public void setShouldExpandEnerPay(boolean set) {
        this.parser.updateValue("EXPAND_ENER_PAY", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean shouldReorderAtOnce() {
        return this.parser.getValue("REORDER_AT_ONCE").equals("1");
    }

    public void setShouldReorderAtOnce(boolean set) {
        this.parser.updateValue("REORDER_AT_ONCE", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean isNotificationWindowFlashEnabled() {
        return this.parser.getValue("NOTIFY_WINDOW_FLASH").equals("1");
    }

    public void setNotificationWindowFlashEnabled(boolean set) {
        this.parser.updateValue("NOTIFY_WINDOW_FLASH", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public boolean isNotificationAlertSoundEnabled() {
        return this.parser.getValue("NOTIFY_ALERT_SOUND").equals("1");
    }

    public void setNotificationAlertSoundEnabled(boolean set) {
        this.parser.updateValue("NOTIFY_ALERT_SOUND", set ? "1" : "0");
        this.parser.writeSettings();
    }

    public String getLastRememberedLoginUsername() {
        return this.parser.getValue("LAST_AUTH_REMEMBER_USERNAME");
    }

    public String getLastRememberedLoginKey() {
        return this.parser.getValue("LAST_AUTH_REMEMBER_KEY");
    }

    public void setLastRememberedLoginInfo(String username, String key) {
        this.parser.updateValue("LAST_AUTH_REMEMBER_USERNAME", username);
        this.parser.updateValue("LAST_AUTH_REMEMBER_KEY", key);
        this.parser.writeSettings();
    }

    public void forgetRememberedLoginInfo() {
        this.setLastRememberedLoginInfo("", "");
    }

    public int getLastSelectedDeckBuilderFormat() {
        return this.parser.getIntegerValue("LAST_DECK_FORMAT");
    }

    public void setLastSelectedDeckBuilderFormat(int id) {
        this.parser.updateValue("LAST_DECK_FORMAT", String.valueOf(id));
        this.parser.writeSettings();
    }

    public boolean isConnectNewDirect() {
        return this.parser.getValue("CONNECT_NEW_DIRECT").equals("1");
    }

    public String getGameVersionClient() {
        return this.gameVersionClient;
    }

    public String getAutoUpdateServiceHash() {
        return this.autoUpdateServiceHash;
    }

    public String getGameLanguage() {
        return this.gameLang;
    }

    public Deck getCurrentDeck() {
        return this.decks.get((Object)DeckSource.EDIT);
    }

    public Deck getCurrentPlayDeck() {
        return this.decks.get((Object)DeckSource.PLAY);
    }

    public double getAnimationSpeed() {
        return this.parser.getDoubleValue("ANI_SPEED");
    }

    public static enum DeckSource {
        EDIT,
        PLAY;

    }
}

