/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.Duration;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.catalog.CardSorter;
import open.batoru.catalog.Catalog;
import open.batoru.catalog.SearchFilter;
import open.batoru.catalog.UtilCardDataFormatter;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardLoader;
import open.batoru.data.Cost;
import open.batoru.parsers.LanguageParser;
import open.batoru.parsers.RestrictedCardsParser;
import open.batoru.parsers.UnreleasedCardsParser;
import open.batoru.ui.UI;
import open.batoru.ui.deck.CardImageSetPicker;

public final class CardCatalog
extends StackPane
implements Catalog {
    private final Consumer<Integer> handlerCardsCount;
    private final ListView<Card> listView = new ListView();
    private final Button buttonImageSet;
    private final Button buttonGrowLine;
    private SearchFilter filter;
    private List<Card> sortingList;
    private String imageSetBias = "";

    public CardCatalog(Consumer<Integer> handlerCardsCount) {
        this.handlerCardsCount = handlerCardsCount;
        this.setPrefWidth(250.0);
        this.listView.getStyleClass().add((Object)"ui_deck_panel");
        this.listView.setFocusTraversable(false);
        this.listView.setSelectionModel(null);
        this.listView.setCellFactory(listView -> new ListCell<Card>(){
            private final CatalogEntry entry;
            {
                this.getStyleClass().add((Object)"ui_deck_panel");
                this.setPadding(new Insets(5.0));
                this.setFocusTraversable(false);
                this.entry = new CatalogEntry();
            }

            public void updateItem(Card item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setGraphic(null);
                    this.setOnMouseEntered(null);
                    this.setOnMouseExited(null);
                    this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), false);
                } else {
                    this.setGraphic((Node)this.entry);
                    this.entry.setCard(item);
                    this.setOnMouseEntered(e -> this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), true));
                    this.setOnMouseExited(e -> this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), false));
                }
            }
        });
        this.buttonImageSet = new Button("\ud83c\udfa8");
        this.buttonImageSet.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)18.0));
        this.buttonImageSet.setPadding(Insets.EMPTY);
        this.buttonImageSet.setPrefSize(30.0, 30.0);
        this.buttonImageSet.getStyleClass().add((Object)"ui_deck_panel_button_art");
        StackPane.setAlignment((Node)this.buttonImageSet, (Pos)Pos.TOP_LEFT);
        this.buttonGrowLine = new Button("\ud83d\udd22");
        this.buttonGrowLine.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)18.0));
        this.buttonGrowLine.setPadding(Insets.EMPTY);
        this.buttonGrowLine.setPrefSize(30.0, 30.0);
        this.buttonGrowLine.getStyleClass().add((Object)"ui_deck_panel_button_art");
        StackPane.setAlignment((Node)this.buttonGrowLine, (Pos)Pos.BOTTOM_LEFT);
        this.getChildren().add(this.listView);
        this.resetSortingList();
    }

    public void setSearchFilter(SearchFilter filter) {
        this.filter = filter;
    }

    public SearchFilter getSearchFilter() {
        return this.filter;
    }

    @Override
    public void resetSortingList() {
        this.sortingList = new ArrayList<Card>(CardLoader.getDataCardObjects());
        if (this.imageSetBias.isEmpty()) {
            CardSorter.sortByUniqueRandom(this.sortingList);
        } else {
            CardSorter.sortByImageSet(this.imageSetBias, this.sortingList);
        }
        this.listView.getItems().setAll(this.sortingList);
    }

    @Override
    public void updateSortingList(List<Card> newList) {
        this.sortingList = newList;
        if (this.imageSetBias.isEmpty()) {
            CardSorter.sortByName(this.sortingList);
        } else {
            CardSorter.sortByImageSet(this.imageSetBias, this.sortingList);
        }
        this.listView.getItems().setAll(this.sortingList);
    }

    @Override
    public void resetCatalogScroll() {
        this.listView.scrollTo(0);
    }

    @Override
    public void updateCardsCountMessage(int count) {
        this.handlerCardsCount.accept(count);
    }

    @Override
    public List<Card> getSortingList() {
        return this.sortingList;
    }

    @Override
    public void setImageSetBias(String imageSetPrefix) {
        this.imageSetBias = imageSetPrefix;
    }

    private class CatalogEntry
    extends GridPane {
        private Card cardObject;
        private String displayImageSet;
        private final StackPane containerDoubleFaceSeparator = new StackPane();
        private final Text textFace = new Text();
        private final Text textName = new Text();
        private final Text textType = new Text();
        private final Text textColor = new Text();
        private final Text textLRIGType = new Text();
        private final Text textSIGNIClassAndCoins = new Text();
        private final Text textPowerAndLimit = new Text();
        private final Text textLevelAndCost = new Text();
        private final ImageView imageCard = new ImageView();
        private final ImageView iconRestrictUnreleased = new ImageView(ImageCache.INSTANCE.getImageIcon("restrict/unreleased"));
        private final ImageView iconRestrictGeneric = new ImageView();
        private final ImageView iconRestrictSimultaneous = new ImageView(ImageCache.INSTANCE.getImageIcon("restrict/simultaneous"));
        private final Tooltip tooltipRestrictUnreleased = new Tooltip();
        private final Tooltip tooltipRestrictGeneric = new Tooltip();
        private final Tooltip tooltipRestrictSimultaneous = new Tooltip();
        private final Map<CardConst.PlayFormat, ImageView> mapPlayFormatIcons = new HashMap<CardConst.PlayFormat, ImageView>();

        public CatalogEntry() {
            this.setHgap(5.0);
            this.setVgap(5.0);
            this.setCursor(Cursor.HAND);
            StackPane imageContainer = new StackPane();
            this.imageCard.setFitWidth(63.0);
            this.imageCard.setFitHeight(87.0);
            Rectangle clip = new Rectangle(63.0, 87.0);
            clip.setArcWidth(9.0);
            clip.setArcHeight(9.0);
            this.imageCard.setClip((Node)clip);
            Group groupIconsRestrict = new Group();
            VBox containerIconsRestrict = new VBox();
            this.iconRestrictUnreleased.setVisible(false);
            this.iconRestrictUnreleased.setManaged(false);
            this.tooltipRestrictUnreleased.setShowDelay(Duration.ZERO);
            Tooltip.install((Node)this.iconRestrictUnreleased, (Tooltip)this.tooltipRestrictUnreleased);
            this.iconRestrictGeneric.setVisible(false);
            this.iconRestrictGeneric.setManaged(false);
            this.tooltipRestrictGeneric.setShowDelay(Duration.ZERO);
            Tooltip.install((Node)this.iconRestrictGeneric, (Tooltip)this.tooltipRestrictGeneric);
            this.iconRestrictSimultaneous.setVisible(false);
            this.iconRestrictSimultaneous.setManaged(false);
            this.tooltipRestrictSimultaneous.setShowDelay(Duration.ZERO);
            Tooltip.install((Node)this.iconRestrictSimultaneous, (Tooltip)this.tooltipRestrictSimultaneous);
            containerIconsRestrict.getChildren().addAll((Object[])new Node[]{this.iconRestrictUnreleased, this.iconRestrictGeneric, this.iconRestrictSimultaneous});
            StackPane.setAlignment((Node)groupIconsRestrict, (Pos)Pos.TOP_LEFT);
            groupIconsRestrict.getChildren().add((Object)containerIconsRestrict);
            Group groupIconsFormat = new Group();
            VBox containerIconsFormat = new VBox();
            for (CardConst.PlayFormat playFormat : CardConst.PlayFormat.values()) {
                if (playFormat == CardConst.PlayFormat.ALLSTAR || playFormat == CardConst.PlayFormat.KEY_CLASSIC) continue;
                ImageView iconPlayFormat = new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getPlayFormatIconPath(playFormat)));
                containerIconsFormat.getChildren().addFirst((Object)iconPlayFormat);
                iconPlayFormat.setVisible(false);
                iconPlayFormat.setManaged(false);
                this.mapPlayFormatIcons.put(playFormat, iconPlayFormat);
            }
            StackPane.setAlignment((Node)groupIconsFormat, (Pos)Pos.BOTTOM_RIGHT);
            groupIconsFormat.getChildren().add((Object)containerIconsFormat);
            StackPane.setMargin((Node)this.textFace, (Insets)new Insets(3.0, 6.0, 3.0, 6.0));
            this.textFace.getStyleClass().add((Object)"ui_deck_panel_text_red");
            this.textFace.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)24.0));
            Line faceSeparator = new Line(63.0, 0.0, 0.0, 87.0);
            faceSeparator.setStroke((Paint)Color.RED);
            faceSeparator.getStrokeDashArray().add((Object)8.0);
            this.containerDoubleFaceSeparator.getChildren().addAll((Object[])new Node[]{this.textFace, faceSeparator});
            this.containerDoubleFaceSeparator.setVisible(false);
            imageContainer.getChildren().addAll((Object[])new Node[]{this.imageCard, groupIconsRestrict, groupIconsFormat, this.containerDoubleFaceSeparator});
            this.add((Node)imageContainer, 0, 0, 1, 4);
            this.add((Node)this.textName, 1, 0, 4, 1);
            this.add((Node)this.textType, 1, 1);
            this.add((Node)this.textLevelAndCost, 1, 2);
            this.add((Node)this.textPowerAndLimit, 1, 3);
            this.add((Node)this.textColor, 2, 1);
            this.add((Node)this.textSIGNIClassAndCoins, 2, 2);
            this.add((Node)this.textLRIGType, 2, 3);
            this.setOnMouseEntered(e -> {
                if (!e.isAltDown()) {
                    UI.getTabDeck().getCardPreview().update(this.displayImageSet);
                }
                if (this.cardObject.getImageSets().getImageSetsNum() > 1) {
                    imageContainer.getChildren().add((Object)CardCatalog.this.buttonImageSet);
                    CardCatalog.this.buttonImageSet.setOnAction(e2 -> {
                        CardImageSetPicker picker = new CardImageSetPicker(this.cardObject.getImageSets().getDataArray(), imageSetPicked -> {
                            UI.getTabDeck().setCardImageSetPicker(null);
                            if (imageSetPicked != null) {
                                UI.getTabDeck().getDeckBuilder().addNewCardToDeck(imageSetPicked);
                            }
                        });
                        UI.getTabDeck().setCardImageSetPicker(picker);
                    });
                }
                if (this.cardObject.getLevel() >= 1 && CardConst.CardType.isLRIG(this.cardObject.getType())) {
                    imageContainer.getChildren().add((Object)CardCatalog.this.buttonGrowLine);
                    CardCatalog.this.buttonGrowLine.setOnAction(e2 -> {
                        String cardSet = this.displayImageSet.substring(0, this.displayImageSet.lastIndexOf("-"));
                        CardConst.PlayFormat playFormat = CardCatalog.this.filter.getFilterFormat();
                        ArrayList<List<String>> cacheImageSets = new ArrayList<List<String>>();
                        for (int level = 0; level < this.cardObject.getLevel(); ++level) {
                            int refLevel = level;
                            List<Card> cards = CardLoader.getDataCardObjects().stream().filter(c -> c.getLRIGType().matches(this.cardObject.getLRIGType()) && c.getColor().getPrimaryValue() == this.cardObject.getColor().getPrimaryValue() && (playFormat == null || c.isAllowedInPlayFormat(playFormat)) && (refLevel == 0 && c.getLevel() == 0 && c.getType() == CardConst.CardType.LRIG || c.getLevel() == refLevel && c.getType() == this.cardObject.getType())).toList();
                            if (cards.isEmpty()) continue;
                            List imageSets = cards.stream().flatMap(c -> c.getImageSets().getDataArray().stream()).toList();
                            if (level == 0 || imageSets.size() == 1 || cards.stream().allMatch(c -> c.getDescription().isEmpty())) {
                                String foundImageSet = imageSets.stream().filter(imageSet -> imageSet.startsWith(cardSet)).findFirst().orElse((String)imageSets.getFirst());
                                UI.getTabDeck().getDeckBuilder().addNewCardToDeck(foundImageSet);
                                continue;
                            }
                            cacheImageSets.add(imageSets);
                        }
                        UI.getTabDeck().getDeckBuilder().addNewCardToDeck(this.displayImageSet);
                        if (!cacheImageSets.isEmpty()) {
                            this.recursivePick(cacheImageSets, cacheImageSets.size() - 1);
                        }
                    });
                }
            });
            this.setOnMouseExited(e -> imageContainer.getChildren().removeAll((Object[])new Node[]{CardCatalog.this.buttonImageSet, CardCatalog.this.buttonGrowLine}));
            this.setOnMouseClicked(e -> {
                if (e.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                UI.getTabDeck().getDeckBuilder().addNewCardToDeck(this.displayImageSet);
            });
        }

        public void setCard(Card cardObject) {
            if (this.cardObject == cardObject) {
                return;
            }
            this.cardObject = cardObject;
            this.displayImageSet = cardObject.getImageSets().getImageSetByPrefixBias(CardCatalog.this.imageSetBias);
            this.imageCard.setImage(ImageCache.INSTANCE.getCardImage(this.displayImageSet));
            this.imageCard.setOpacity(!Settings.INSTANCE.getGameLanguage().equals("jp") && cardObject.getTranslatedName().isEmpty() ? 0.66 : 1.0);
            this.mapPlayFormatIcons.forEach((playFormat, icon) -> {
                icon.setVisible(cardObject.isAllowedInPlayFormat((CardConst.PlayFormat)((Object)playFormat)));
                icon.setManaged(icon.isVisible());
            });
            if (cardObject.getReleaseDate() != null) {
                this.iconRestrictUnreleased.setVisible(true);
                this.iconRestrictUnreleased.setManaged(true);
                this.tooltipRestrictUnreleased.setText(UnreleasedCardsParser.formatUnreleasedTooltipText(cardObject));
            } else {
                this.iconRestrictUnreleased.setVisible(false);
                this.iconRestrictUnreleased.setManaged(false);
            }
            if (cardObject.getBanlistRestriction() != RestrictedCardsParser.RestrictType.NONE) {
                this.iconRestrictGeneric.setImage(ImageCache.INSTANCE.getImageIcon(ImageCache.getRestrictIconPath(cardObject.getBanlistRestriction())));
                this.iconRestrictGeneric.setVisible(true);
                this.iconRestrictGeneric.setManaged(true);
                this.tooltipRestrictGeneric.setText(RestrictedCardsParser.formatRestrictTooltipText(cardObject.getBanlistRestriction()));
            } else {
                this.iconRestrictGeneric.setVisible(false);
                this.iconRestrictGeneric.setManaged(false);
            }
            if (cardObject.getBanlistSimultaneousNum() != 0) {
                this.iconRestrictSimultaneous.setVisible(true);
                this.iconRestrictSimultaneous.setManaged(true);
                this.tooltipRestrictSimultaneous.setText(RestrictedCardsParser.formatSimultaneousRestrictTooltipText(cardObject));
            } else {
                this.iconRestrictSimultaneous.setVisible(false);
                this.iconRestrictSimultaneous.setManaged(false);
            }
            if (cardObject.getDoubleFacedCardPairObject() != null) {
                if (cardObject.getCardFace() == CardConst.CardFace.FRONT) {
                    this.textFace.setText("A");
                    StackPane.setAlignment((Node)this.textFace, (Pos)Pos.TOP_LEFT);
                } else {
                    this.textFace.setText("B");
                    StackPane.setAlignment((Node)this.textFace, (Pos)Pos.BOTTOM_RIGHT);
                }
                this.containerDoubleFaceSeparator.setVisible(true);
                this.containerDoubleFaceSeparator.setManaged(true);
            } else {
                this.containerDoubleFaceSeparator.setVisible(false);
                this.containerDoubleFaceSeparator.setManaged(false);
            }
            this.textName.setText(cardObject.getName());
            this.textName.setFont(null);
            CardConst.CardType cardType = cardObject.getType();
            this.textType.setText(cardType.getLabel());
            this.textColor.setText(UtilCardDataFormatter.formatColor(cardObject.getColor()));
            if (cardType != CardConst.CardType.ARTS && cardType != CardConst.CardType.SPELL && cardType != CardConst.CardType.KEY && cardType != CardConst.CardType.PIECE) {
                this.textLevelAndCost.setText(UtilCardDataFormatter.formatLevel(cardObject.getLevel()));
                if (cardType == CardConst.CardType.LRIG || cardType == CardConst.CardType.LRIG_ASSIST) {
                    this.textPowerAndLimit.setText(UtilCardDataFormatter.formatLimit(cardObject.getLimit(), cardType == CardConst.CardType.LRIG_ASSIST));
                    if (cardObject.getLevel() == 0) {
                        this.textName.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)-1.0));
                    }
                    this.textSIGNIClassAndCoins.setText(cardObject.getCoins() > 0 ? UtilCardDataFormatter.formatCoins(cardObject.getCoins()) : null);
                    this.textLRIGType.setText(UtilCardDataFormatter.formatLRIGType(cardObject.getLRIGType(), false));
                } else if (cardType != CardConst.CardType.TOKEN) {
                    this.textPowerAndLimit.setText(UtilCardDataFormatter.formatPower(cardObject.getPower()));
                    this.textSIGNIClassAndCoins.setText(UtilCardDataFormatter.formatSIGNIClass(cardObject.getSIGNIClass()));
                    this.textLRIGType.setText(UtilCardDataFormatter.formatLRIGType(cardObject.getLRIGType(), true));
                } else {
                    this.textColor.setText(null);
                    this.textLevelAndCost.setText(null);
                    this.textPowerAndLimit.setText(null);
                    this.textSIGNIClassAndCoins.setText(null);
                    this.textLRIGType.setText(null);
                }
            } else {
                this.textLevelAndCost.setText(UtilCardDataFormatter.formatCost(Cost.getOriginalCostAsNumber(cardObject)));
                this.textPowerAndLimit.setText(null);
                this.textSIGNIClassAndCoins.setText(null);
                this.textLRIGType.setText(UtilCardDataFormatter.formatLRIGType(cardObject.getLRIGType(), true));
            }
        }

        private void recursivePick(List<List<String>> cacheImageSets, int current) {
            CardImageSetPicker picker = new CardImageSetPicker(cacheImageSets.get(current), imageSetPicked -> {
                UI.getTabDeck().setCardImageSetPicker(null);
                if (imageSetPicked != null) {
                    UI.getTabDeck().getDeckBuilder().addNewCardToDeck(imageSetPicked);
                }
                if (current > 0) {
                    this.recursivePick(cacheImageSets, current - 1);
                }
            });
            UI.getTabDeck().setCardImageSetPicker(picker);
        }
    }
}

