/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.catalog;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.web.WebView;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.catalog.CardInformation;
import open.batoru.catalog.UtilCardDataFormatter;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardDataLRIGType;
import open.batoru.data.CardDataSIGNIClass;
import open.batoru.data.CardLoader;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.parsers.LanguageParser;
import open.batoru.parsers.RestrictedCardsParser;
import open.batoru.ui.OutlinedText;
import open.batoru.ui.UI;
import open.batoru.ui.UtilDispose;

public class CardPreview {
    private final VBox node = new VBox();
    private final ImageView cardImage;
    private final FlowPane containerLinkedCardImages;
    private final OutlinedText cardImageSetText;
    private final Button buttonCardWebInfo;
    private final Text nameText;
    private final Text typeText;
    private final Text colorText;
    private final Text levelText;
    private final TilePane costIcons;
    private final Text powerAndLimitText;
    private final Text LRIGTypeText;
    private final Text classText;
    private final WebView descriptionWebView;
    private String oldImageSet;
    private Card oldCardObject;
    private final Button buttonAdd;

    public CardPreview() {
        this.node.setAlignment(Pos.TOP_CENTER);
        this.node.setSpacing(10.0);
        StackPane imageContainer = new StackPane();
        imageContainer.setAlignment(Pos.TOP_CENTER);
        this.cardImage = new ImageView();
        this.cardImage.setFitWidth(175.0);
        this.cardImage.setFitHeight(244.0);
        this.cardImageSetText = new OutlinedText(1.5);
        this.cardImageSetText.getText().setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)14.0));
        this.cardImageSetText.getText().getStyleClass().add((Object)"ui_deck_panel_preview_imageset_text");
        this.cardImageSetText.setMouseTransparent(true);
        this.cardImageSetText.setVisible(Settings.INSTANCE.shouldAlwaysShowImageSetInPreview());
        this.cardImage.hoverProperty().addListener((ov, oldValue, newValue) -> {
            if (!Settings.INSTANCE.shouldAlwaysShowImageSetInPreview()) {
                this.cardImageSetText.setVisible((boolean)newValue);
            }
        });
        this.buttonCardWebInfo = new Button("?");
        this.buttonCardWebInfo.setPadding(Insets.EMPTY);
        this.buttonCardWebInfo.setPrefSize(20.0, 20.0);
        this.buttonCardWebInfo.setVisible(false);
        StackPane.setAlignment((Node)this.buttonCardWebInfo, (Pos)Pos.TOP_RIGHT);
        this.buttonCardWebInfo.setOnAction(e -> {
            if (this.oldCardObject == null) {
                return;
            }
            this.buttonCardWebInfo.setDisable(true);
            new CardInformation(this.buttonCardWebInfo, this.oldCardObject.getImageSets().getPrimaryImageSet()).show();
        });
        this.containerLinkedCardImages = new FlowPane(Orientation.VERTICAL);
        this.containerLinkedCardImages.setAlignment(Pos.BOTTOM_LEFT);
        this.containerLinkedCardImages.setHgap(4.0);
        this.containerLinkedCardImages.setVgap(4.0);
        this.containerLinkedCardImages.maxHeightProperty().bind((ObservableValue)imageContainer.heightProperty());
        UtilDispose.PERM.attachChildDisposeListener((Node)this.containerLinkedCardImages);
        imageContainer.getChildren().addAll((Object[])new Node[]{this.containerLinkedCardImages, this.cardImage, this.cardImageSetText, this.buttonCardWebInfo});
        this.buttonAdd = new Button("\u2795");
        this.buttonAdd.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)8.0));
        this.buttonAdd.setPadding(Insets.EMPTY);
        this.buttonAdd.setPrefSize(16.0, 16.0);
        this.buttonAdd.getStyleClass().add((Object)"ui_deck_panel_button_art");
        this.buttonAdd.setFocusTraversable(false);
        this.buttonAdd.setOnAction(e -> {
            if (this.oldCardObject == null) {
                return;
            }
            UI.getTabDeck().getDeckBuilder().addNewCardToDeck(this.oldCardObject.getImageSets().getPrimaryImageSet());
        });
        GridPane infoGrid = new GridPane();
        infoGrid.setMinWidth(250.0);
        infoGrid.setMaxWidth(250.0);
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setPercentWidth(35.0);
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setPercentWidth(65.0);
        c2.setHalignment(HPos.RIGHT);
        infoGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{c1, c2});
        Rectangle clip = new Rectangle(175.0, 244.0);
        clip.setArcWidth(21.0);
        clip.setArcHeight(21.0);
        this.cardImage.setClip((Node)clip);
        this.nameText = new Text();
        this.nameText.setWrappingWidth(250.0);
        this.nameText.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        this.typeText = new Text();
        this.colorText = new Text();
        this.levelText = new Text();
        this.powerAndLimitText = new Text();
        this.LRIGTypeText = new Text();
        this.classText = new Text();
        this.classText.setTextAlignment(TextAlignment.RIGHT);
        this.costIcons = new TilePane();
        this.costIcons.setAlignment(Pos.CENTER_RIGHT);
        this.costIcons.setHgap(2.0);
        this.costIcons.setVgap(2.0);
        this.costIcons.setPrefColumns(5);
        infoGrid.add((Node)this.typeText, 0, 0);
        infoGrid.add((Node)this.colorText, 1, 0);
        infoGrid.add((Node)this.levelText, 0, 2);
        infoGrid.add((Node)this.costIcons, 1, 2);
        infoGrid.add((Node)this.classText, 1, 2);
        infoGrid.add((Node)this.powerAndLimitText, 0, 3);
        infoGrid.add((Node)this.LRIGTypeText, 1, 3);
        this.descriptionWebView = new WebView();
        this.descriptionWebView.setContextMenuEnabled(false);
        this.descriptionWebView.getEngine().setJavaScriptEnabled(false);
        this.descriptionWebView.getEngine().loadContent("<body style=\"background-color: " + DescriptionParser.getThemedDescriptionParser().getBackgroundColor() + ";\">");
        this.node.getChildren().addAll((Object[])new Node[]{imageContainer, this.nameText, infoGrid, this.descriptionWebView});
    }

    public WebView getDescriptionWebView() {
        return this.descriptionWebView;
    }

    public void update(String imageSet) {
        if (imageSet.equals(this.oldImageSet)) {
            return;
        }
        Card cardObject = CardLoader.getCardByImageSet(imageSet);
        if (cardObject == null) {
            return;
        }
        this.updateTable(cardObject, imageSet, cardObject.getLevel(), cardObject.getLimit(), cardObject.getCostAsDataCostLists());
        this.descriptionWebView.getEngine().loadContent(DescriptionParser.getThemedDescriptionParser().parseDescription(cardObject, true));
    }

    private void updateTable(Card cardObject, String imageSet, int levelModified, double limitModified, List<AbilityCostList> dataCostListsModified) {
        this.oldImageSet = imageSet;
        this.oldCardObject = cardObject;
        CardConst.CardType cardType = cardObject.getType();
        CardDataLRIGType cardLRIGType = cardObject.getLRIGType();
        CardDataColor cardColor = cardObject.getColor();
        CardDataSIGNIClass cardSIGNIClass = cardObject.getSIGNIClass();
        this.classText.setOnMouseEntered(e -> {
            if (cardSIGNIClass.getPrimaryValue() != null) {
                this.classText.setText(UtilCardDataFormatter.formatSIGNIClassFamily(cardSIGNIClass));
            }
        });
        this.classText.setOnMouseExited(e -> {
            if (cardSIGNIClass.getPrimaryValue() != null) {
                this.classText.setText(UtilCardDataFormatter.formatSIGNIClass(cardSIGNIClass));
            }
        });
        this.buttonCardWebInfo.setVisible(true);
        CardDataImageSet.MaskType maskType = CardLoader.getImageSetMaskType(imageSet);
        boolean hasVerticalImage = !CardConst.CardType.isCardInHorizontalOrientation(cardType) && maskType != CardDataImageSet.MaskType.VERTICAL;
        this.cardImage.setImage(ImageCache.INSTANCE.getCardImage(imageSet));
        this.cardImageSetText.setText(maskType != CardDataImageSet.MaskType.DOUBLE_FACED_UR ? imageSet : imageSet.substring(1));
        this.nameText.setText(cardObject.getName());
        this.typeText.setText(UtilCardDataFormatter.formatType(cardType));
        this.colorText.setText(UtilCardDataFormatter.formatColor(cardColor));
        if (!this.containerLinkedCardImages.isHover()) {
            this.containerLinkedCardImages.getChildren().clear();
            List<String> linkedImageSets = cardObject.getLinkedImageSets();
            if (linkedImageSets != null) {
                this.containerLinkedCardImages.setOrientation(hasVerticalImage ? Orientation.VERTICAL : Orientation.HORIZONTAL);
                double sizeMulti = linkedImageSets.size() <= 5 ? 2.0 : 2.4;
                for (String linkedImageSet : linkedImageSets) {
                    ImageView linkedCardImage = new ImageView(ImageCache.INSTANCE.getCardImage(linkedImageSet));
                    linkedCardImage.setFitWidth(63.0 / sizeMulti);
                    linkedCardImage.setFitHeight(87.0 / sizeMulti);
                    Rectangle clip = new Rectangle(63.0 / sizeMulti, 87.0 / sizeMulti);
                    clip.setArcWidth(9.0 / sizeMulti);
                    clip.setArcHeight(9.0 / sizeMulti);
                    linkedCardImage.setClip((Node)clip);
                    StackPane containerImage = new StackPane(new Node[]{linkedCardImage});
                    Card linkedCardObject = CardLoader.getCardByImageSet(linkedImageSet);
                    if (linkedCardObject != null && CardConst.CardType.isCardInHorizontalOrientation(linkedCardObject.getType()) || CardLoader.getImageSetMaskType(linkedImageSet) == CardDataImageSet.MaskType.VERTICAL || !hasVerticalImage) {
                        containerImage.setRotate(90.0);
                        FlowPane.setMargin((Node)containerImage, (Insets)new Insets(0.0, hasVerticalImage ? 0.0 : 12.0, -6.0, 0.0));
                    }
                    boolean canBeAddedToDeck = linkedCardObject != null && linkedCardObject.getBanlistRestriction() != RestrictedCardsParser.RestrictType.TOKEN;
                    containerImage.setOnMouseEntered(e -> {
                        this.update(linkedImageSet);
                        if (canBeAddedToDeck) {
                            containerImage.getChildren().add((Object)this.buttonAdd);
                        }
                    });
                    if (canBeAddedToDeck) {
                        containerImage.setOnMouseExited(e -> containerImage.getChildren().remove((Object)this.buttonAdd));
                    }
                    UtilDispose.PERM.setOnDisposed((Node)containerImage, () -> {
                        linkedCardImage.setImage(null);
                        containerImage.setOnMouseEntered(null);
                        containerImage.setOnMouseExited(null);
                    });
                    this.containerLinkedCardImages.getChildren().add((Object)containerImage);
                    if (this.containerLinkedCardImages.getChildren().size() <= 6) continue;
                    FlowPane.setMargin((Node)containerImage, (Insets)new Insets(0.0, 0.0, 0.0, 191.0));
                }
                this.containerLinkedCardImages.setOnMouseExited(e -> this.update(imageSet));
            } else {
                this.containerLinkedCardImages.setOrientation(Orientation.HORIZONTAL);
                this.containerLinkedCardImages.setOnMouseExited(null);
            }
        }
        this.cardImage.setRotate(hasVerticalImage && (!this.containerLinkedCardImages.isHover() || this.containerLinkedCardImages.getOrientation() == Orientation.VERTICAL) ? 0.0 : 90.0);
        this.costIcons.getChildren().clear();
        if (cardType != CardConst.CardType.ARTS && cardType != CardConst.CardType.SPELL && cardType != CardConst.CardType.KEY && cardType != CardConst.CardType.PIECE) {
            if (cardType == CardConst.CardType.LRIG || cardType == CardConst.CardType.LRIG_ASSIST) {
                this.levelText.setText(UtilCardDataFormatter.formatLevel(levelModified));
                if (cardObject.getCoins() > 0) {
                    this.levelText.setText(this.levelText.getText() + " " + UtilCardDataFormatter.formatCoins(cardObject.getCoins()));
                }
                this.powerAndLimitText.setText(UtilCardDataFormatter.formatLimit(limitModified, cardType == CardConst.CardType.LRIG_ASSIST));
                this.updateTextColor(this.levelText, cardObject.getLevel(), levelModified);
                this.updateTextColor(this.powerAndLimitText, cardObject.getLimit(), limitModified);
                this.classText.setText("");
                this.LRIGTypeText.setText(UtilCardDataFormatter.formatLRIGType(cardLRIGType, false));
                UtilCardDataFormatter.formatCostIcons(this.costIcons, cardObject, dataCostListsModified);
            } else if (cardType != CardConst.CardType.TOKEN) {
                this.levelText.setText(UtilCardDataFormatter.formatLevel(levelModified));
                if (cardObject.getLimit() > 0.0) {
                    this.levelText.setText(this.levelText.getText() + " " + UtilCardDataFormatter.formatLimit(cardObject.getLimit(), false));
                }
                this.powerAndLimitText.setText(UtilCardDataFormatter.formatPower(cardObject.getPower()));
                this.updateTextColor(this.levelText, cardObject.getLevel(), levelModified);
                this.updateTextColor(this.powerAndLimitText, cardObject.getPower(), cardObject.getPower());
                this.classText.setText(UtilCardDataFormatter.formatSIGNIClass(cardSIGNIClass));
                this.LRIGTypeText.setText(UtilCardDataFormatter.formatLRIGType(cardLRIGType, true));
            } else {
                this.colorText.setText("");
                this.levelText.setText("");
                this.powerAndLimitText.setText("");
                this.classText.setText("");
                this.LRIGTypeText.setText("");
            }
        } else {
            UtilCardDataFormatter.formatCostIcons(this.costIcons, cardObject, dataCostListsModified);
            this.levelText.setText("");
            this.powerAndLimitText.setText("");
            this.classText.setText("");
            this.LRIGTypeText.setText(UtilCardDataFormatter.formatLRIGType(cardLRIGType, true));
        }
    }

    private void updateTextColor(Text text, double valueOriginal, double valueModified) {
        text.getStyleClass().removeAll((Object[])new String[]{"ui_deck_panel_text_darkgreen", "ui_deck_panel_text_red"});
        if (valueModified > valueOriginal) {
            text.getStyleClass().add((Object)"ui_deck_panel_text_darkgreen");
        } else if (valueModified < valueOriginal) {
            text.getStyleClass().add((Object)"ui_deck_panel_text_red");
        }
    }

    public void updateCardImageSetTextVisibility(boolean isVisible) {
        this.cardImageSetText.setVisible(isVisible);
    }

    public VBox getNode() {
        return this.node;
    }
}

