/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.catalog;

import java.util.ArrayList;
import open.batoru.catalog.Catalog;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.Cost;
import open.batoru.parsers.RestrictedCardsParser;

public class SearchFilter {
    public static final int ANY_NUMBER = -1;
    private final Catalog catalog;
    private String filterSearchText = "";
    private int filterLevel = -1;
    private int filterPower = -1;
    private int filterCost = -1;
    private CardConst.CardType filterType;
    private final CardConst.CardColor[] filterColor = new CardConst.CardColor[2];
    private CardConst.CardLRIGType filterLRIGType;
    private CardConst.CardSIGNIClass filterClass;
    private String filterSets = "";
    private RestrictedCardsParser.RestrictType filterRestrict = RestrictedCardsParser.RestrictType.NONE;
    private Boolean filterLifeBurst = null;
    private Boolean filterGuard = null;
    private CardConst.PlayFormat filterFormat = null;
    private final ArrayList<AdvancedKeywordFilter> listAdvancedKeywordFilters = new ArrayList();
    private boolean invertKeywordFilters;
    private RestrictedCardsParser.SpecialRestrictType filterRestrictSpecial;
    private SearchMode filterSearchMode = SearchMode.NAME;
    private boolean isLocked;

    public SearchFilter(Catalog catalog) {
        this.catalog = catalog;
    }

    public void applyFiltersInLockedState(LockedFiltersAction handlerFilters) {
        this.isLocked = true;
        handlerFilters.exec(this);
        this.isLocked = false;
        this.applyFilter();
    }

    public void search(String newValue) {
        this.filterSearchText = newValue;
        if (newValue.startsWith("!!")) {
            this.filterSearchText = this.filterSearchText.substring(2).toLowerCase();
            this.filterSearchMode = SearchMode.DESCRIPTION;
        } else if (newValue.startsWith("??")) {
            this.filterSearchText = this.filterSearchText.substring(2);
            this.filterSearchMode = SearchMode.IMAGESET;
            this.catalog.setImageSetBias(this.filterSearchText);
        } else {
            this.filterSearchText = this.filterSearchText.toLowerCase();
            this.filterSearchMode = SearchMode.NAME;
            this.catalog.setImageSetBias(this.filterSets);
        }
        this.applyFilter();
    }

    public void filterToggleKeyword(AdvancedKeywordFilter advancedFilter) {
        if (!this.listAdvancedKeywordFilters.contains(advancedFilter)) {
            this.listAdvancedKeywordFilters.add(advancedFilter);
        } else {
            this.listAdvancedKeywordFilters.remove(advancedFilter);
        }
        this.applyFilter();
    }

    public void filterToggleInvertKeywords() {
        this.invertKeywordFilters = !this.invertKeywordFilters;
        this.applyFilter();
    }

    public void clearKeywordFilter() {
        this.listAdvancedKeywordFilters.clear();
        this.invertKeywordFilters = false;
        this.applyFilter();
    }

    public void filterLevel(int level) {
        this.filterLevel = level;
        this.applyFilter();
    }

    public void filterPower(int power) {
        this.filterPower = power == -1 ? -1 : power * 1000;
        this.applyFilter();
    }

    public void filterCost(int cost) {
        this.filterCost = cost;
        this.applyFilter();
    }

    public void filterType(CardConst.CardType cardType) {
        this.filterType = cardType;
        this.applyFilter();
    }

    public void filterColor(CardConst.CardColor color) {
        this.filterColor[0] = color;
        this.applyFilter();
    }

    public void filterColor2(CardConst.CardColor color) {
        this.filterColor[1] = color;
        this.applyFilter();
    }

    public void filterLRIGType(CardConst.CardLRIGType cardLRIGType) {
        this.filterLRIGType = cardLRIGType;
        this.applyFilter();
    }

    public void filterClass(CardConst.CardSIGNIClass cardSIGNIClass) {
        this.filterClass = cardSIGNIClass;
        this.applyFilter();
    }

    public void filterSets(String imageSetPrefix) {
        this.filterSets = imageSetPrefix;
        this.catalog.setImageSetBias(this.filterSets);
        this.applyFilter();
    }

    public void filterRestrict(RestrictedCardsParser.RestrictType restrictType, RestrictedCardsParser.SpecialRestrictType specialRestrictType) {
        this.filterRestrict = restrictType;
        this.filterRestrictSpecial = specialRestrictType;
        this.applyFilter();
    }

    public void filterLifeBurst(boolean indeterminate, boolean set) {
        if (indeterminate) {
            if (!set) {
                return;
            }
            this.filterLifeBurst = null;
        } else {
            this.filterLifeBurst = set;
        }
        this.applyFilter();
    }

    public void filterGuard(boolean indeterminate, boolean set) {
        if (indeterminate) {
            if (!set) {
                return;
            }
            this.filterGuard = null;
        } else {
            this.filterGuard = set;
        }
        this.applyFilter();
    }

    public void filterFormat(CardConst.PlayFormat playFormat) {
        this.filterFormat = playFormat;
        this.applyFilter();
    }

    public CardConst.PlayFormat getFilterFormat() {
        return this.filterFormat;
    }

    private void applyFilter() {
        if (this.isLocked) {
            return;
        }
        this.catalog.resetSortingList();
        this.catalog.resetCatalogScroll();
        ArrayList<Card> listFiltered = new ArrayList<Card>();
        for (Card c : this.catalog.getSortingList()) {
            if (!this.checkFilterSearchText(c) || !this.checkFilterAdvancedKeywords(c) || !this.checkFilterLevel(c) || !this.checkFilterPower(c) || !this.checkFilterCost(c) || !this.checkFilterType(c) || !this.checkFilterColor(c) || !this.checkFilterLRIGType(c) || !this.checkFilterClass(c) || !this.checkFilterImageSets(c) || !this.checkFilterRestrict(c) || !this.checkFilterLifeBurst(c) || !this.checkFilterGuard(c) || !this.checkFilterFormat(c)) continue;
            listFiltered.add(c);
        }
        if (listFiltered.size() != this.catalog.getSortingList().size()) {
            this.catalog.updateSortingList(listFiltered);
        }
        this.catalog.updateCardsCountMessage(listFiltered.size());
    }

    private boolean checkFilterSearchText(Card c) {
        return this.filterSearchMode == SearchMode.NAME && (c.getOriginalName().toLowerCase().contains(this.filterSearchText) || c.getName().toLowerCase().contains(this.filterSearchText) || c.getAltNames().toLowerCase().contains(this.filterSearchText)) || this.filterSearchMode == SearchMode.DESCRIPTION && c.getDescription().toLowerCase().contains(this.filterSearchText) || this.filterSearchMode == SearchMode.IMAGESET && c.getImageSets().getDataArray().stream().anyMatch(imageSet -> imageSet.contains(this.filterSearchText));
    }

    private boolean checkFilterAdvancedKeywords(Card c) {
        return this.listAdvancedKeywordFilters.isEmpty() || this.listAdvancedKeywordFilters.stream().allMatch(advancedFilter -> this.invertKeywordFilters != (c.getDescription().contains(advancedFilter.keywordText()) || advancedFilter.alternativeCardFilter() != null && advancedFilter.alternativeCardFilter().check(c)));
    }

    private boolean checkFilterLevel(Card c) {
        return this.filterLevel == -1 || c.getLevel() == this.filterLevel && c.getType() != CardConst.CardType.ARTS && c.getType() != CardConst.CardType.SPELL && c.getType() != CardConst.CardType.KEY && c.getType() != CardConst.CardType.PIECE;
    }

    private boolean checkFilterPower(Card c) {
        return this.filterPower == -1 || c.getPower() >= (double)this.filterPower && c.getPower() < (double)(this.filterPower + 1000) && CardConst.CardType.isSIGNI(c.getType());
    }

    private boolean checkFilterCost(Card c) {
        return this.filterCost == -1 || !CardConst.CardType.isSIGNI(c.getType()) && this.invertKeywordFilters != Cost.getOriginalCostAsNumber(c) <= this.filterCost;
    }

    private boolean checkFilterType(Card c) {
        return this.filterType == null || c.getType() == this.filterType;
    }

    private boolean checkFilterColor(Card c) {
        return this.filterColor[0] == null && this.filterColor[1] == null || this.filterColor[1] == null && c.getColor().matches(this.filterColor[0]) || this.filterColor[0] == null && c.getColor().matches(this.filterColor[1]) || this.filterColor[0] != null && this.filterColor[1] != null && c.getColor().matches(this.filterColor[0]) && c.getColor().matches(this.filterColor[1]) || this.filterColor[0] == CardConst.CardColor.COLORLESS && c.getColor().getPrimaryValue() == CardConst.CardColor.COLORLESS;
    }

    private boolean checkFilterLRIGType(Card c) {
        return this.filterLRIGType == null || c.getLRIGType().matches(this.filterLRIGType) || this.filterLRIGType == CardConst.CardLRIGType.NO_LRIG_LIMIT && c.getLRIGType().getPrimaryValue() == CardConst.CardLRIGType.NO_LRIG_LIMIT;
    }

    private boolean checkFilterClass(Card c) {
        return this.filterClass == null || c.getSIGNIClass().matches(this.filterClass);
    }

    private boolean checkFilterImageSets(Card c) {
        if (this.filterSets.isEmpty() || c.getImageSets().getPrimaryImageSet().startsWith(this.filterSets)) {
            return true;
        }
        if (c.getImageSets().getImageSetsNum() > 1) {
            for (String imageSet : c.getImageSets().getDataArray()) {
                if (!imageSet.startsWith(this.filterSets)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkFilterRestrict(Card c) {
        return this.filterRestrictSpecial == null && (this.filterRestrict == RestrictedCardsParser.RestrictType.NONE || c.getBanlistRestriction() == this.filterRestrict) || this.filterRestrictSpecial == RestrictedCardsParser.SpecialRestrictType.SIMULTANEOUS && c.getBanlistSimultaneousNum() > 0 || this.filterRestrictSpecial == RestrictedCardsParser.SpecialRestrictType.UNRELEASED && c.getReleaseDate() != null;
    }

    private boolean checkFilterLifeBurst(Card c) {
        return this.filterLifeBurst == null || c.hasLifeBurst() == this.filterLifeBurst.booleanValue();
    }

    private boolean checkFilterGuard(Card c) {
        return this.filterGuard == null || c.canGuard() == this.filterGuard.booleanValue();
    }

    private boolean checkFilterFormat(Card c) {
        return this.filterFormat == null || c.isAllowedInPlayFormat(this.filterFormat);
    }

    private static enum SearchMode {
        NAME,
        DESCRIPTION,
        IMAGESET;

    }

    @FunctionalInterface
    public static interface LockedFiltersAction {
        public void exec(SearchFilter var1);
    }

    public record AdvancedKeywordFilter(String keywordText, AlternativeCardFilter alternativeCardFilter) {
    }

    @FunctionalInterface
    public static interface AlternativeCardFilter {
        public boolean check(Card var1);
    }
}

