/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import open.batoru.Log;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEmpty;
import open.batoru.ui.UI;
import open.batoru.ui.UserAttentionNotifier;

public class ActionQueue
implements Disposable {
    private final Map<Integer, GameAction<?>> mapActions = new ConcurrentHashMap();
    private final Map<GameAction<?>, ActionTask> mapActionTasks = new HashMap();
    private final List<Integer> cacheCompletedActions = new ArrayList<Integer>();
    private final List<String> cacheActionsClassNames = new ArrayList<String>();
    private final List<GameAction<?>> suspendedActions = new ArrayList();
    private final ConcurrentLinkedQueue<ActionTask> frozenActions = new ConcurrentLinkedQueue();
    private final AtomicInteger lastOrder = new AtomicInteger(0);
    private boolean isIdle;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    private ActionTask lastTask;
    private int lastProcessedOrder;
    private boolean isStopped;
    private boolean isPaused;
    private boolean shouldPauseNext;
    private OnNextTaskEndHandler handlerOnNextTaskEnd;
    private OnActionDispatchedHandler handlerOnActionDispatched;

    public int addAction(GameAction<?> action) {
        return this.internalAddAction(this.lastOrder.get() + 1, action, false);
    }

    public void addServerAction(int orderId, GameAction<?> action) {
        this.internalAddAction(orderId, action, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalAddAction(int orderId, GameAction<?> action, boolean isServerOrder) {
        if (action == null) {
            Log.printMessage(true, "Warning: Attempted to add a null action to ActionQueue.");
            return 0;
        }
        int currentLastOrder = this.getLastOrder();
        if (orderId < currentLastOrder) {
            Log.printMessage(true, "Warning: Received action out of order: " + orderId + " <= " + currentLastOrder + " | " + String.valueOf(action));
            return 0;
        }
        while (this.mapActions.containsKey(orderId) || this.cacheCompletedActions.contains(orderId)) {
            if (isServerOrder) {
                Log.printMessage(true, "Warning: Received a duplicate action (already completed): " + orderId + " | " + String.valueOf(action));
                return 0;
            }
            ++orderId;
        }
        Log.printMessage(orderId + ". " + String.valueOf(action));
        action.setOrderId(orderId);
        if (isServerOrder) {
            action.setAsServerOrder();
        }
        Map<Integer, GameAction<?>> map = this.mapActions;
        synchronized (map) {
            this.mapActions.put(orderId, action);
        }
        ActionTask lastFrozenAction = this.frozenActions.poll();
        if (lastFrozenAction != null) {
            lastFrozenAction.releaseThreadLock();
        }
        ActionTask task = new ActionTask();
        this.mapActionTasks.put(action, task);
        try {
            this.exec.submit(task);
        }
        catch (RejectedExecutionException ex) {
            Log.printMessage(true, "Warning: Execution of action was rejected: " + orderId + " | " + String.valueOf(action));
            return 0;
        }
        if (orderId > this.getLastOrder() && action.getCallbackAction() != null) {
            action.getCallbackAction().getCallbackThread().setThreadLock("add");
        }
        return orderId;
    }

    public void addEmptyAction(String hint) {
        int orderId = this.addAction(new ActionEmpty());
        Log.printMessage(orderId + " = " + hint);
    }

    public void addEmptyServerAction(int orderId, String hint) {
        this.addServerAction(orderId, new ActionEmpty());
        Log.printMessage(orderId + " = " + hint);
    }

    public void suspendWaitingActions() {
        Iterator<Map.Entry<Integer, GameAction<?>>> iterator = this.mapActions.entrySet().iterator();
        int minOrderId = 0;
        while (iterator.hasNext()) {
            Map.Entry<Integer, GameAction<?>> entry = iterator.next();
            GameAction<?> actionWaiting = entry.getValue();
            if (actionWaiting.isDispatched() || actionWaiting.getOrderId() < this.getLastOrder() + 1) continue;
            Log.printMessage("!suspend: " + String.valueOf(actionWaiting) + " (" + actionWaiting.getOrderId() + ")");
            if (actionWaiting.getOrderId() > minOrderId) {
                minOrderId = actionWaiting.getOrderId();
            }
            this.suspendedActions.add(actionWaiting);
            iterator.remove();
            this.mapActionTasks.computeIfPresent(actionWaiting, (key, task) -> {
                task.disable();
                return null;
            });
        }
        if (!this.suspendedActions.isEmpty()) {
            this.cacheCompletedActions.remove((Object)minOrderId);
        }
    }

    public void resumeSuspendedActions() {
        if (this.suspendedActions.isEmpty()) {
            Game.getCurrentGame().getGameRules().getRuleProcessor().process();
        } else {
            Log.printMessage("!resume: " + this.suspendedActions.size() + " actions");
            for (GameAction<?> suspendedAction : this.suspendedActions) {
                if (!suspendedAction.isServerOrder()) {
                    this.addAction(suspendedAction);
                    continue;
                }
                this.addServerAction(suspendedAction.getOrderId(), suspendedAction);
            }
            this.suspendedActions.clear();
        }
    }

    public void stop() {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        this.setLastActionAsComplete();
        this.exec.shutdownNow();
    }

    public void togglePause() {
        boolean bl = this.shouldPauseNext = !this.shouldPauseNext;
        if (this.isPaused && !this.shouldPauseNext) {
            this.setLastActionAsComplete();
        }
    }

    public void setOnNextTaskEnd(OnNextTaskEndHandler handler) {
        this.handlerOnNextTaskEnd = handler;
        if (this.isPaused) {
            handler.handle();
        }
    }

    public void setOnActionDispatched(OnActionDispatchedHandler handler) {
        this.handlerOnActionDispatched = handler;
    }

    public void setLastOrder(int orderId) {
        this.lastOrder.set(orderId);
    }

    public int getLastOrder() {
        return this.lastOrder.get();
    }

    public int getLastProcessedOrder() {
        return this.lastProcessedOrder;
    }

    public String getActionClassName(int orderId) {
        int arrayId = orderId - 1;
        return arrayId >= 0 && arrayId < this.cacheActionsClassNames.size() ? this.cacheActionsClassNames.get(arrayId) : "<Unknown>";
    }

    public void prepareNextActionClassName(int nextOrderId, String className) {
        if (nextOrderId == this.cacheActionsClassNames.size() - 1) {
            this.cacheActionsClassNames.add(className);
        }
    }

    public boolean isBusy() {
        return !this.isIdle;
    }

    public void setLastActionAsComplete() {
        if (this.lastTask != null) {
            this.lastTask.releaseThreadLock();
        }
    }

    @Override
    public void dispose() {
        this.mapActions.clear();
        this.mapActionTasks.clear();
        this.suspendedActions.clear();
        this.frozenActions.clear();
        this.lastTask = null;
        this.handlerOnNextTaskEnd = null;
        this.handlerOnActionDispatched = null;
    }

    private class ActionTask
    implements Runnable {
        private GameAction<?> action;
        private boolean isDisabled;

        private ActionTask() {
        }

        private void disable() {
            this.isDisabled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            if (this.isDisabled) {
                return;
            }
            while (true) {
                int nextOrderId;
                Map<Integer, GameAction<?>> map = ActionQueue.this.mapActions;
                synchronized (map) {
                    nextOrderId = ActionQueue.this.getLastOrder() + 1;
                    this.action = ActionQueue.this.mapActions.get(nextOrderId);
                    if (this.action != null || ActionQueue.this.isStopped) {
                        break;
                    }
                    Log.printMessage("!frozen: " + nextOrderId);
                    ActionQueue.this.frozenActions.offer(this);
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    Log.printMessage(true, "Warning: Interrupt attempt in ActionQueue thread (frozen).");
                }
                Log.printMessage("!unfrozen: " + nextOrderId);
                Map<Integer, GameAction<?>> ex = ActionQueue.this.mapActions;
                synchronized (ex) {
                    if (ActionQueue.this.mapActions.containsKey(nextOrderId)) {
                        ActionQueue.this.frozenActions.remove(this);
                    }
                }
            }
            if (ActionQueue.this.isStopped) {
                return;
            }
            if (this.action.isCompleted()) {
                Log.printMessage(true, "Warning: Attempted to execute an already completed action (" + String.valueOf(this.action) + " -> " + this.action.getOrderId() + ")");
                return;
            }
            ActionQueue.this.lastTask = this;
            Game.getCurrentGame().getIdleStateCoordinator().markAsBusy(Game.getCurrentGame().getActionQueue());
            if (this.action.getOrderId() == ActionQueue.this.cacheActionsClassNames.size() + 1) {
                ActionQueue.this.cacheActionsClassNames.add(this.action.getClass().getSimpleName());
            }
            Platform.runLater(() -> {
                if (ActionQueue.this.isStopped) {
                    return;
                }
                if (ActionQueue.this.handlerOnActionDispatched != null) {
                    ActionQueue.this.handlerOnActionDispatched.handle(this.action.getOrderId());
                }
                ActionQueue.this.isIdle = false;
                if (this.action.isServerOrder() && Game.getCurrentGame().getFakeReceiver() == null) {
                    UserAttentionNotifier.notifyUser(false, UI.getTabGame());
                }
                Log.printMessage("dispatch: " + String.valueOf(this.action) + " (" + this.action.getOrderId() + ") " + (this.action.isRuleProcAction() ? "(ruleproc)" : ""));
                this.action.dispatchInternal();
            });
            while (!this.action.isCompleted() && !ActionQueue.this.isStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    Log.printMessage(true, "Warning: Interrupt attempt in ActionQueue thread.");
                }
            }
            if (ActionQueue.this.isStopped) {
                return;
            }
            ActionQueue.this.cacheCompletedActions.add(this.action.getOrderId());
            ActionQueue.this.mapActions.remove(this.action.getOrderId());
            Log.printMessage("done: " + String.valueOf(this.action) + " (!" + this.action.getOrderId() + ")");
            if (this.action.getCallbackAction() != null) {
                this.action.getCallbackAction().getCallbackThread().releaseThreadLock("completed");
            }
            if (Game.getCurrentGame().getGameState() != Game.GameState.IN_PROGRESS) {
                return;
            }
            if (this.action.isRuleProcAction()) {
                Game.getCurrentGame().getGameRules().getRuleProcessor().setRuleProcActionAsComplete(this.action);
            } else if (!this.action.isMidEffAction() && Game.getCurrentGame().getGameRules().getEffectProcessor().isIdle()) {
                Game.getCurrentGame().getGameRules().getRuleProcessor().process();
            }
            ActionQueue.this.isPaused = ActionQueue.this.shouldPauseNext;
            if (ActionQueue.this.handlerOnNextTaskEnd != null) {
                ActionQueue.this.handlerOnNextTaskEnd.handle();
                ActionQueue.this.handlerOnNextTaskEnd = null;
                if (ActionQueue.this.isStopped) {
                    return;
                }
            }
            if (ActionQueue.this.isPaused) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.printMessage(true, "Warning: Interrupt attempt in ActionQueue thread (pause).");
                }
            }
            ActionQueue.this.shouldPauseNext = false;
            ActionQueue.this.isPaused = false;
            if (ActionQueue.this.isStopped) {
                return;
            }
            ActionQueue.this.lastProcessedOrder = this.action.getOrderId();
            boolean hasPlayerOrders = ActionQueue.this.mapActions.values().stream().anyMatch(remainingAction -> !remainingAction.isServerOrder());
            if (!hasPlayerOrders) {
                ActionQueue.this.isIdle = true;
                Game.getCurrentGame().getIdleStateCoordinator().markAsIdle(Game.getCurrentGame().getActionQueue());
            }
        }

        private synchronized void releaseThreadLock() {
            this.notify();
        }
    }

    @FunctionalInterface
    public static interface OnNextTaskEndHandler {
        public void handle();
    }

    @FunctionalInterface
    public static interface OnActionDispatchedHandler {
        public void handle(int var1);
    }
}

