/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.Card;
import open.batoru.data.CardDataColor;
import open.batoru.data.CardDataLRIGType;
import open.batoru.data.CardDataSIGNIClass;
import open.batoru.data.ModifiableDouble;
import open.batoru.data.ModifiableFlag;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ModifiableString;
import open.batoru.data.ability.cost.AbilityCost;

public class CardIndexSnapshot
implements AbilityCost.Payable {
    private final CardIndex source;
    private int instanceId;
    private final GameConst.CardLocation location;
    private final GameConst.CardLocation oldLocation;
    private final int cardId;
    private final Card idCardRef;
    private CardDataLRIGType idLRIGType;
    private CardDataSIGNIClass idSIGNIClass;
    private CardDataColor idColor;
    private ModifiableString idName;
    private ModifiableInteger idLevel;
    private ModifiableDouble idPower;
    private ModifiableFlag idFlagsCardState;
    private final GameConst.CardUnderType idUnderType;
    private final Game.GamePlayerRole idTempOwner;

    public CardIndexSnapshot(CardIndex source) {
        this.source = source;
        this.cardId = source.getId();
        this.location = source.getLocation();
        this.oldLocation = source.getOldLocation();
        this.idCardRef = source.getCardReference();
        this.idUnderType = source.getUnderType();
        if (source.getIndexedInstance() != null) {
            this.instanceId = source.getIndexedInstance().getInstanceId();
            this.idLRIGType = new CardDataLRIGType(source.getIndexedInstance().getLRIGType());
            this.idSIGNIClass = new CardDataSIGNIClass(source.getIndexedInstance().getSIGNIClass());
            this.idColor = new CardDataColor(source.getIndexedInstance().getColor());
            this.idName = new ModifiableString(source.getIndexedInstance().getName().getValue());
            this.idLevel = new ModifiableInteger(source.getIndexedInstance().getLevel().getValue());
            this.idLevel.adoptByReferenceValues(source.getIndexedInstance().getLevel());
            this.idLevel.setSourceCardIndex(source);
            this.idPower = new ModifiableDouble(source.getIndexedInstance().getPower().getValue());
            this.idFlagsCardState = new ModifiableFlag(source.getIndexedInstance().getCardStateFlags().getValue());
            this.idTempOwner = source.getIndexedInstance().getCurrentOwner();
        } else {
            this.idTempOwner = source.getCurrentOwnerSafe();
        }
    }

    public CardIndex getSourceCardIndex() {
        return this.source;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public GameConst.CardLocation getLocation() {
        return this.location;
    }

    public GameConst.CardLocation getOldLocation() {
        return this.oldLocation;
    }

    public boolean isEffectivelyAtLocation(GameConst.CardLocation location) {
        return this.getLocation() == location || (this.getLocation() == GameConst.CardLocation.REVEALED || this.getLocation() == GameConst.CardLocation.LOOKED) && this.getOldLocation() == location;
    }

    public int getId() {
        return this.cardId;
    }

    public Card getCardReference() {
        return this.idCardRef;
    }

    public CardDataLRIGType getLRIGType() {
        return this.idLRIGType;
    }

    public CardDataSIGNIClass getSIGNIClass() {
        return this.idSIGNIClass;
    }

    public CardDataColor getColor() {
        return this.idColor;
    }

    public ModifiableString getName() {
        return this.idName;
    }

    public ModifiableInteger getLevel() {
        return this.idLevel;
    }

    public ModifiableDouble getPower() {
        return this.idPower;
    }

    public ModifiableFlag getCardStateFlags() {
        return this.idFlagsCardState;
    }

    public GameConst.CardUnderType getUnderType() {
        return this.idUnderType;
    }

    public Game.GamePlayerRole getOwner() {
        return this.idTempOwner;
    }

    public final boolean isState(int flagCardState) {
        return (this.idFlagsCardState.getValue() & flagCardState) != 0;
    }
}

