/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst;

public class ChronoRecordScheduler
implements Disposable {
    private final List<ChronoRecord> records = new ArrayList<ChronoRecord>();

    public void tick(Game.GamePlayerRole roleTurnPlayer, GameConst.GamePhase currentPhase, boolean isPhaseEnd) {
        ArrayList<ChronoRecord> cacheRecords = new ArrayList<ChronoRecord>(this.records);
        ArrayList<ChronoRecord> cacheToBeRemoved = new ArrayList<ChronoRecord>();
        for (ChronoRecord record : cacheRecords) {
            if (record.tick(roleTurnPlayer, currentPhase, isPhaseEnd)) continue;
            cacheToBeRemoved.add(record);
        }
        this.records.removeAll(cacheToBeRemoved);
        for (ChronoRecord record : cacheToBeRemoved) {
            record.dispose();
        }
    }

    public void addChronoRecord(ChronoRecord record) {
        if (record != null) {
            this.records.add(record);
            record.getOnChronoRecordAddedHandlersList().forEach(ChronoRecord.ChronoRecordHandler::handle);
            record.getOnChronoRecordAddedHandlersList().clear();
        }
    }

    private void removeChronoRecord(ChronoRecord record) {
        this.records.remove(record);
    }

    private boolean hasChronoRecord(ChronoRecord record) {
        return this.records.contains(record);
    }

    public void eraseChronoRecords(CardIndex cardIndex, boolean isSafe) {
        ArrayList<ChronoRecord> cacheRecords = new ArrayList<ChronoRecord>(this.records);
        ArrayList<ChronoRecord> cacheToBeRemoved = new ArrayList<ChronoRecord>();
        for (ChronoRecord record : cacheRecords) {
            if (record.getSourceCardIndex() != cardIndex || isSafe && record.isProtected()) continue;
            record.forceExpire();
            cacheToBeRemoved.add(record);
        }
        this.records.removeAll(cacheToBeRemoved);
        for (ChronoRecord record : cacheToBeRemoved) {
            record.dispose();
        }
    }

    public void eraseChronoRecords(CardIndex cardIndex, String alias) {
        if (alias == null) {
            return;
        }
        ArrayList<ChronoRecord> cacheRecords = new ArrayList<ChronoRecord>(this.records);
        ArrayList<ChronoRecord> cacheToBeRemoved = new ArrayList<ChronoRecord>();
        for (ChronoRecord record : cacheRecords) {
            if (record.getSourceCardIndex() != cardIndex || !alias.equals(record.getAlias())) continue;
            record.forceExpire();
            cacheToBeRemoved.add(record);
        }
        this.records.removeAll(cacheToBeRemoved);
        for (ChronoRecord record : cacheToBeRemoved) {
            record.dispose();
        }
    }

    @Override
    public void dispose() {
        this.records.forEach(Disposable::dispose);
        this.records.clear();
    }

    public static class ChronoRecord
    implements Disposable {
        private CardIndex sourceCardIndex;
        private ChronoDuration chronoDuration;
        private final List<ChronoRecordHandler> listHandlersOnAdded = new ArrayList<ChronoRecordHandler>();
        private final List<ChronoRecordHandler> listHandlersOnExpired = new ArrayList<ChronoRecordHandler>();
        private boolean isProtected;
        private String alias;

        public ChronoRecord(CardIndex sourceCardIndex, ChronoDuration chronoDuration) {
            this.sourceCardIndex = sourceCardIndex;
            this.chronoDuration = chronoDuration;
        }

        public ChronoRecord(ChronoDuration chronoDuration) {
            this(null, chronoDuration);
        }

        public ChronoDuration getChronoDuration() {
            return this.chronoDuration;
        }

        public void setAsProtected(boolean set) {
            this.isProtected = set;
        }

        public boolean isProtected() {
            return this.isProtected;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setOnChronoRecordAdded(ChronoRecordHandler handlerChronoRecordAdded) {
            this.listHandlersOnAdded.add(handlerChronoRecordAdded);
        }

        public void setOnChronoRecordExpired(ChronoRecordHandler handlerChronoRecordExpired) {
            this.listHandlersOnExpired.add(handlerChronoRecordExpired);
        }

        public List<ChronoRecordHandler> getOnChronoRecordAddedHandlersList() {
            return this.listHandlersOnAdded;
        }

        public List<ChronoRecordHandler> getOnChronoRecordExpiredHandlersList() {
            return this.listHandlersOnExpired;
        }

        protected boolean tick(Game.GamePlayerRole roleTurnPlayer, GameConst.GamePhase currentPhase, boolean isPhaseEnd) {
            if (this.chronoDuration != ChronoDuration.permanent() && this.chronoDuration.check(roleTurnPlayer, currentPhase, isPhaseEnd)) {
                this.listHandlersOnExpired.forEach(ChronoRecordHandler::handle);
                this.listHandlersOnExpired.clear();
                return false;
            }
            return true;
        }

        public void forceExpire() {
            if (!Game.getCurrentGame().getChronoScheduler().hasChronoRecord(this)) {
                return;
            }
            this.chronoDuration = ChronoDuration.nextPhase();
            this.tick(null, null, false);
            Game.getCurrentGame().getChronoScheduler().removeChronoRecord(this);
        }

        public CardIndex getSourceCardIndex() {
            return this.sourceCardIndex;
        }

        @Override
        public void dispose() {
            this.sourceCardIndex = null;
            this.chronoDuration = null;
            this.listHandlersOnAdded.clear();
            this.listHandlersOnExpired.clear();
        }

        @FunctionalInterface
        public static interface ChronoRecordHandler {
            public void handle();
        }
    }
}

