/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import open.batoru.Log;
import open.batoru.core.Deck;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CutInResponse;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionEffectProcessComplete;
import open.batoru.core.gameplay.actions.ActionEffectProcessResolveNext;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.ConstantEffect;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Card3D;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class EffectProcessing
implements Disposable {
    private final List<OnEffectProcessingFinishedHandler> listHandlers = new ArrayList<OnEffectProcessingFinishedHandler>();
    private final Map<Game.GamePlayerRole, EffectBucket> mapPlayerEffectBuckets = new EnumMap<Game.GamePlayerRole, EffectBucket>(Game.GamePlayerRole.class);
    private final Map<Ability, List<List<GameEvent>>> mapConstantModCalledEvents = new ConcurrentHashMap<Ability, List<List<GameEvent>>>();
    private final ArrayList<PostProcessingJobHandler> constantUpdatePostProcessingJobs = new ArrayList();
    private CutInResponse currentCutInResponse;
    private boolean isIdle = true;

    public EffectProcessing() {
        this.mapPlayerEffectBuckets.put(Game.GamePlayerRole.HOST, new EffectBucket(Game.GamePlayerRole.HOST));
        this.mapPlayerEffectBuckets.put(Game.GamePlayerRole.GUEST, new EffectBucket(Game.GamePlayerRole.GUEST));
    }

    public void setCutInResponse(CutInResponse cutInResponse) {
        this.currentCutInResponse = cutInResponse;
    }

    public CutInResponse getCutInResponse() {
        return this.currentCutInResponse;
    }

    public void processAbilities(GameEvent ... events) {
        this.internalProcessAbilities(events);
        this.resolveWaitingEffects();
    }

    public void processAbilitiesAndWait(GameEvent ... events) {
        this.internalProcessAbilities(events);
    }

    private void internalProcessAbilities(GameEvent ... events) {
        if (events.length == 0) {
            return;
        }
        EffectBucket bucketTurnPlayer = this.mapPlayerEffectBuckets.get((Object)Game.getCurrentGame().getGameRules().getTurnPlayer());
        EffectBucket bucketTurnPlayerOpponent = this.mapPlayerEffectBuckets.get((Object)Game.getCurrentGame().getGameRules().getTurnPlayerOpponent());
        for (GameEvent event : events) {
            Game.getCurrentGame().getGameLog().addRecord(event);
        }
        for (GameEvent event : events) {
            if (event != null) {
                Log.printMessage("@CALL: " + String.valueOf((Object)event.getId()));
            }
            bucketTurnPlayer.prepareAbilities(event);
            bucketTurnPlayerOpponent.prepareAbilities(event);
        }
    }

    public void resolveWaitingEffects() {
        if (!this.isIdle()) {
            return;
        }
        if (this.currentCutInResponse != null && this.currentCutInResponse.isWaitingForOpponentResponse()) {
            EffectBucket bucketCutInOpponent = this.mapPlayerEffectBuckets.get((Object)Game.GamePlayerRole.getOpponentRole(this.currentCutInResponse.getSourceEffectBucket().getOwner()));
            Ability nextAbility = bucketCutInOpponent.getNextAbility();
            if (nextAbility != null && (nextAbility.getActiveUseTiming().getValue() & 4) != 0) {
                this.setAsIdle(false);
                Game.getCurrentGame().getActionQueue().addAction(new ActionEffectProcessResolveNext(bucketCutInOpponent));
            }
            return;
        }
        this.setAsIdle(false);
        EffectBucket bucketTurnPlayer = this.mapPlayerEffectBuckets.get((Object)Game.getCurrentGame().getGameRules().getTurnPlayer());
        EffectBucket bucketTurnPlayerOpponent = this.mapPlayerEffectBuckets.get((Object)Game.getCurrentGame().getGameRules().getTurnPlayerOpponent());
        if (bucketTurnPlayer.getAbilitiesNum() > 0) {
            Game.getCurrentGame().getActionQueue().addAction(new ActionEffectProcessResolveNext(bucketTurnPlayer));
        } else if (bucketTurnPlayerOpponent.getAbilitiesNum() > 0) {
            Game.getCurrentGame().getActionQueue().addAction(new ActionEffectProcessResolveNext(bucketTurnPlayerOpponent));
        } else {
            this.handleFinished();
        }
    }

    public void setEffectAsCompleted(EffectBucket sourceBucket) {
        sourceBucket.setEffectAsCompleted();
        if (this.currentCutInResponse != null && this.currentCutInResponse.isWaitingForOpponentResponse()) {
            return;
        }
        EffectBucket bucketTurnPlayer = this.mapPlayerEffectBuckets.get((Object)Game.getCurrentGame().getGameRules().getTurnPlayer());
        EffectBucket bucketTurnPlayerOpponent = this.mapPlayerEffectBuckets.get((Object)Game.getCurrentGame().getGameRules().getTurnPlayerOpponent());
        if (bucketTurnPlayer.hasNextAbility()) {
            Game.getCurrentGame().getActionQueue().addAction(new ActionEffectProcessResolveNext(bucketTurnPlayer));
        } else if (bucketTurnPlayerOpponent.hasNextAbility()) {
            Game.getCurrentGame().getActionQueue().addAction(new ActionEffectProcessResolveNext(bucketTurnPlayerOpponent));
        } else {
            Game.getCurrentGame().getActionQueue().addAction(new ActionEffectProcessComplete());
        }
    }

    public EffectBucket getSourceBucket(Ability ability) {
        return this.getPlayerBucket(ability.getAbilityOwner());
    }

    public EffectBucket getTurnPlayerBucket() {
        return this.getPlayerBucket(Game.getCurrentGame().getGameRules().getTurnPlayer());
    }

    public EffectBucket getTurnPlayerOpponentBucket() {
        return this.getPlayerBucket(Game.getCurrentGame().getGameRules().getTurnPlayerOpponent());
    }

    public EffectBucket getPlayerBucket(Game.GamePlayerRole rolePlayer) {
        return this.mapPlayerEffectBuckets.get((Object)rolePlayer);
    }

    public void handleFinished() {
        this.setAsIdle(true);
        this.listHandlers.forEach(OnEffectProcessingFinishedHandler::handle);
        this.listHandlers.clear();
    }

    public void setOnEffectProcessingFinished(OnEffectProcessingFinishedHandler handler) {
        if (handler != null) {
            this.listHandlers.add(handler);
        }
    }

    public void setAsIdle(boolean set) {
        this.isIdle = set;
        Game.getCurrentGame().getPlayerControl().setPlayerLock(!set);
        if (!set) {
            Game.getCurrentGame().getIdleStateCoordinator().markAsBusy(this);
        } else {
            Game.getCurrentGame().getIdleStateCoordinator().markAsIdle(this);
        }
    }

    public boolean isIdle() {
        return this.isIdle;
    }

    public boolean isComplete() {
        return this.isIdle() && (this.currentCutInResponse != null || !this.mapPlayerEffectBuckets.get((Object)Game.GamePlayerRole.HOST).hasNextAbility() && !this.mapPlayerEffectBuckets.get((Object)Game.GamePlayerRole.GUEST).hasNextAbility());
    }

    public void cacheAvailableAbilities(List<Ability> cacheAbilities, Game.GamePlayerRole rolePlayer) {
        int i;
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            int totalCards;
            for (int ii = totalCards = field.getSIGNIZone(zonePosition).getTotalCards() - 1; ii >= 0; --ii) {
                Card3D card3D = field.getSIGNIZone(zonePosition).getZoneCardList().get(ii);
                if (card3D.getCardIndex().getIndexedInstance() == null) continue;
                for (int iii = 0; iii < card3D.getCardIndex().getIndexedInstance().getAbilityList().size(); ++iii) {
                    Ability ability = card3D.getCardIndex().getIndexedInstance().getAbilityList().get(iii);
                    if (!card3D.getCardIndex().isFaceUp() && !(ability instanceof ConstantAbility) || ii != totalCards && ability instanceof ConstantEffect && !(ability instanceof ConstantAbility)) continue;
                    cacheAbilities.add(ability);
                }
            }
        }
        for (i = field.getLRIGZone().getTotalCards() - 1; i >= 0; --i) {
            Card3D card3D = field.getLRIGZone().getZoneCardList().get(i);
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
            for (i = field.getLRIGAssistZoneLeft().getTotalCards() - 1; i >= 0; --i) {
                Card3D card3D = field.getLRIGAssistZoneLeft().getZoneCardList().get(i);
                if (card3D.getCardIndex().getIndexedInstance() == null) continue;
                cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
            }
        }
        if (FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
            for (i = field.getLRIGAssistZoneRight().getTotalCards() - 1; i >= 0; --i) {
                Card3D card3D = field.getLRIGAssistZoneRight().getZoneCardList().get(i);
                if (card3D.getCardIndex().getIndexedInstance() == null) continue;
                cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
            }
        }
        for (Card3D card3D : field.getKeyZone().getZoneCardList()) {
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        for (int i2 = field.getCheckZone().getTotalCards() - 1; i2 >= 0; --i2) {
            Card3D card3D = field.getCheckZone().getZoneCardList().get(i2);
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        for (Card3D card3D : field.getEnerZone().getZoneCardList()) {
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        for (int i3 = 0; i3 < field.getTrashZone(Deck.DeckType.MAIN).getTotalCards(); ++i3) {
            Card3D card3D = field.getTrashZone(Deck.DeckType.MAIN).getZoneCardList().get(i3);
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        for (Card3D card3D : field.getTrashZone(Deck.DeckType.LRIG).getZoneCardList()) {
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        for (Card3D card3D : field.getRevealZone().getZoneCardList()) {
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        for (int i4 = 0; i4 < field.getDeckZone(Deck.DeckType.MAIN).getTotalCards(); ++i4) {
            Card3D card3D = field.getDeckZone(Deck.DeckType.MAIN).getZoneCardList().get(i4);
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        for (Card3D card3D : field.getHand().getZoneCardList()) {
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        for (Card3D card3D : field.getLookZone().getZoneCardList()) {
            if (card3D.getCardIndex().getIndexedInstance() == null) continue;
            cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList());
        }
        if (rolePlayer == Game.getCurrentGame().getPlayerRole()) {
            for (int i5 = 0; i5 < field.getDeckZone(Deck.DeckType.LRIG).getTotalCards(); ++i5) {
                Card3D card3D = field.getDeckZone(Deck.DeckType.LRIG).getZoneCardList().get(i5);
                if (card3D.getCardIndex().getIndexedInstance() == null) continue;
                cacheAbilities.addAll(card3D.getCardIndex().getIndexedInstance().getAbilityList().stream().filter(ConstantAbility.class::isInstance).toList());
            }
        }
        cacheAbilities.addAll(Game.getCurrentGame().getPlayerGameData(rolePlayer).getPlayerAbilities());
    }

    public synchronized void updateConstantAbilities() {
        ArrayList<Ability> cacheAbilities = new ArrayList<Ability>();
        Game.GamePlayerRole turnPlayer = Game.getCurrentGame().getGameRules().getTurnPlayer();
        Game.GamePlayerRole turnPlayerOpponent = Game.GamePlayerRole.getOpponentRole(turnPlayer);
        this.cacheAvailableAbilities(cacheAbilities, turnPlayer);
        this.cacheAvailableAbilities(cacheAbilities, turnPlayerOpponent);
        cacheAbilities.stream().filter(ConstantEffect.class::isInstance).map(ConstantEffect.class::cast).sorted(Comparator.comparingInt(ConstantEffect::getPriority)).forEach(ConstantEffect::update);
        FX.run(() -> {
            UI.getTabGame().getFieldScene().getGameField().getTopPlayerField().getVisualStateCoordinator().update();
            UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getVisualStateCoordinator().update();
        });
        for (Ability sourceAbility : this.mapConstantModCalledEvents.keySet()) {
            for (List<GameEvent> listEvent : this.mapConstantModCalledEvents.get(sourceAbility)) {
                for (int i = 0; i < listEvent.size(); ++i) {
                    GameEvent event = listEvent.get(i);
                    event.setAtOnce(i, listEvent.size());
                    this.processAbilitiesAndWait(event);
                }
            }
        }
        if (!this.mapConstantModCalledEvents.isEmpty()) {
            this.resolveWaitingEffects();
            this.mapConstantModCalledEvents.clear();
        }
        this.constantUpdatePostProcessingJobs.forEach(PostProcessingJobHandler::handle);
        this.constantUpdatePostProcessingJobs.clear();
    }

    public synchronized void updateConstantAbilitiesUnsafe() {
        TargetFilter.setIsUnsafeMode(true);
        this.updateConstantAbilities();
        TargetFilter.setIsUnsafeMode(false);
    }

    public void addConstantUpdatePostProcessingJob(PostProcessingJobHandler job) {
        this.constantUpdatePostProcessingJobs.add(job);
    }

    public void callConstantModifierEvent(ConstantAbility sourceAbility, GameEvent event) {
        int arrayId = -1;
        if (this.mapConstantModCalledEvents.get(sourceAbility) != null) {
            for (int i = 0; i < this.mapConstantModCalledEvents.get(sourceAbility).size(); ++i) {
                if (!this.mapConstantModCalledEvents.get(sourceAbility).get(i).getFirst().getClass().equals(event.getClass())) continue;
                arrayId = i;
                break;
            }
        } else {
            arrayId = -2;
        }
        if (arrayId < 0) {
            ArrayList<GameEvent> listEvent = new ArrayList<GameEvent>();
            listEvent.add(event);
            if (arrayId == -2) {
                this.mapConstantModCalledEvents.put(sourceAbility, new ArrayList());
            }
            this.mapConstantModCalledEvents.get(sourceAbility).add(listEvent);
        } else {
            this.mapConstantModCalledEvents.get(sourceAbility).get(arrayId).add(event);
        }
    }

    @Override
    public void dispose() {
        this.listHandlers.clear();
        this.mapPlayerEffectBuckets.values().forEach(EffectBucket::dispose);
        this.mapPlayerEffectBuckets.clear();
        this.mapConstantModCalledEvents.clear();
        this.constantUpdatePostProcessingJobs.clear();
        this.currentCutInResponse = null;
    }

    @FunctionalInterface
    public static interface PostProcessingJobHandler {
        public void handle();
    }

    @FunctionalInterface
    public static interface OnEffectProcessingFinishedHandler {
        public void handle();
    }
}

