/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.actions.ActionCallThreadedOverride;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.actions.override.OverrideResult;
import open.batoru.core.gameplay.callback.CallbackGameAction;
import open.batoru.data.DataTable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.networking.PacketParser;
import open.batoru.networking.SpecFakeGameReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public abstract class GameAction<T> {
    private int flags;
    private List<GameActionHandler> listHandlersDispatched;
    private List<GameActionHandler> listHandlersCompleted;
    private GameActionHandler handlerBlocked;
    private GameActionHandler handlerOverridden;
    private int orderId;
    private GameAction<?> parentAction;
    private DataTable<T> dataTable = new DataTable();
    private CallbackGameAction callbackAction;
    private CardIndex sourceCardIndex;
    private Ability sourceAbility;
    private AbilityCost sourceCost;
    private LogEvent logEvent;
    private OverrideResult sourceOverrideResult;
    private GameAction<T> prevAtOnceAction;
    private boolean isLastAtOnce = true;
    private int totalNumAtOnce = 1;
    private int requestMinExpectedArgs;
    private PacketParser ppReceived;

    public final void setOrderId(int orderId) {
        this.orderId = orderId;
    }

    public final void setAsServerOrder() {
        this.flags |= 0x80;
    }

    public final boolean isServerOrder() {
        return (this.flags & 0x80) != 0;
    }

    public final void setCallbackAction(CallbackGameAction callbackAction) {
        this.callbackAction = callbackAction;
    }

    public final CallbackGameAction getCallbackAction() {
        return this.callbackAction;
    }

    public final void setSourceCardIndex(CardIndex cardIndex) {
        this.sourceCardIndex = cardIndex;
    }

    public final void setSourceAbility(Ability ability) {
        if (ability == null) {
            return;
        }
        this.sourceCardIndex = ability.getSourceCardIndex();
        this.sourceAbility = ability;
    }

    public final void setSourceCost(AbilityCost cost) {
        if (cost == null) {
            return;
        }
        this.sourceCost = cost;
        if (cost.getSourceAbility() != null) {
            this.setSourceAbility(cost.getSourceAbility());
        } else {
            this.setSourceCardIndex(cost.getSourceCardIndex());
        }
    }

    public final CardIndex getSourceCardIndex() {
        return this.sourceCardIndex;
    }

    public final Ability getSourceAbility() {
        return this.sourceAbility;
    }

    public final AbilityCost getSourceCost() {
        return this.sourceCost;
    }

    public void setLogEvent(LogEvent logEvent) {
        this.setLogEvent(logEvent, false);
    }

    public void setLogEvent(LogEvent logEvent, boolean isRuleCheckEntry) {
        if (logEvent == null || this.isBlocked()) {
            return;
        }
        UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEvent, isRuleCheckEntry);
        this.logEvent = logEvent;
    }

    public final LogEvent getLogEvent() {
        return this.logEvent;
    }

    public final boolean isSuccessful() {
        return !this.dataTable.isEmpty() && this.dataTable.get() != null;
    }

    public final void setAtOnce(GameAction<T> prevAtOnceAction, int numCurrent, int numTotal) {
        this.prevAtOnceAction = prevAtOnceAction;
        this.isLastAtOnce = numCurrent == numTotal - 1;
        this.totalNumAtOnce = numTotal;
    }

    public final GameAction<T> getPrevAtOnceAction() {
        return this.prevAtOnceAction;
    }

    public final int getNumAtOnce() {
        int num = 0;
        GameAction<T> prevAction = this;
        do {
            if (!prevAction.isSuccessful()) continue;
            ++num;
        } while ((prevAction = prevAction.getPrevAtOnceAction()) != null);
        return num;
    }

    public final int getTotalNumAtOnce() {
        return this.totalNumAtOnce;
    }

    public final boolean isLastAtOnce() {
        return this.isLastAtOnce;
    }

    public final void treatAsMidEffAction() {
        this.flags |= 8;
    }

    public final boolean isMidEffAction() {
        return (this.flags & 8) != 0;
    }

    public final boolean isDispatched() {
        return (this.flags & 4) != 0;
    }

    public final void treatAsNonMandatoryAction() {
        this.flags |= 0x100;
    }

    public final boolean isNonMandatoryAction() {
        return (this.flags & 0x100) != 0;
    }

    @Deprecated
    public final void setAsNonOverridableAction() {
        this.flags |= 0x400;
    }

    @Deprecated
    public final boolean isNonOverridableAction() {
        return (this.flags & 0x400) != 0;
    }

    public final void dispatchInternal() {
        if (this.isDispatched()) {
            Log.printMessage("!!!duplicate dispatch " + this.orderId);
            return;
        }
        Game.getCurrentGame().getActionQueue().setLastOrder(this.orderId);
        if (!this.isChildAction() && this.listHandlersDispatched != null) {
            this.listHandlersDispatched.forEach(GameActionHandler::handle);
            this.listHandlersDispatched = null;
        }
        this.flags |= 4;
        this.dispatch();
    }

    protected abstract void dispatch();

    public final void dispatchAsChild(GameAction<T> parent) {
        this.setSourceCardIndex(parent.getSourceCardIndex());
        this.setSourceAbility(parent.getSourceAbility());
        this.setSourceCost(parent.getSourceCost());
        this.dataTable = parent.getDataTable();
        this.setOnActionCompleted(parent::setAsCompleted);
        this.parentAction = parent;
        this.flags |= 0x40;
        this.dispatch();
    }

    public final boolean isChildAction() {
        return (this.flags & 0x40) != 0;
    }

    public final GameAction<?> getParentAction() {
        return this.parentAction;
    }

    public final void setAsBlocked(OverrideResult overrideResult) {
        this.setAsBlocked(overrideResult, false);
    }

    @Deprecated
    public final void setAsBlocked(OverrideResult overrideResult, boolean isForcedBlock) {
        if (!isForcedBlock && this.isNonOverridableAction()) {
            this.setAsCompleted();
            return;
        }
        if (this.isBlocked()) {
            Log.printMessage("!!!duplicate block " + this.orderId);
            return;
        }
        if (this.logEvent != null) {
            FX.run(() -> this.logEvent.disable());
        }
        Log.printMessage("!!!blocked " + this.orderId);
        this.sourceOverrideResult = overrideResult;
        if (this.callbackAction == null || this.isRuleProcAction()) {
            if (this.isRuleProcAction()) {
                Game.getCurrentGame().getGameRules().getRuleProcessor().purgeRuleProcAction(this);
            }
            this.flags |= 8;
            if (this.sourceOverrideResult != null) {
                Game.getCurrentGame().getActionQueue().suspendWaitingActions();
                Game.getCurrentGame().getActionQueue().addAction(new ActionCallThreadedOverride(this.sourceOverrideResult));
            }
        }
        this.flags |= 0x22;
        if (!this.isChildAction()) {
            if (this.handlerBlocked != null) {
                this.handlerBlocked.handle();
            }
            Game.getCurrentGame().getActionQueue().setLastActionAsComplete();
        } else if (this.listHandlersCompleted != null) {
            this.listHandlersCompleted.forEach(GameActionHandler::handle);
            this.listHandlersCompleted = null;
        }
    }

    public final boolean isBlocked() {
        return (this.flags & 0x20) != 0;
    }

    public final OverrideResult getSourceOverrideResult() {
        return this.sourceOverrideResult;
    }

    public final void setSourceOverrideResult(OverrideResult overrideResult) {
        this.sourceOverrideResult = overrideResult;
    }

    public boolean applyActiveOverrideActions(Game.GamePlayerRole roleOwner, GameEvent ... listEvents) {
        OverrideResult overrideResult;
        if (!(this.isBlocked() || this.getSourceOverrideResult() != null || this.isNonOverridableAction() || (overrideResult = OverrideAction.findActiveOverrideActions(roleOwner, this, listEvents)).isEmpty())) {
            this.setAsBlocked(overrideResult);
            return true;
        }
        return false;
    }

    public final void setAsCompleted() {
        if (this.isCompleted()) {
            Log.printMessage("!!!duplicate complete " + this.orderId);
            return;
        }
        if (!this.isChildAction() && !this.isMidEffAction() && Game.getCurrentGame().getGameState() == Game.GameState.IN_PROGRESS) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
        }
        if (this.listHandlersCompleted != null) {
            this.listHandlersCompleted.forEach(GameActionHandler::handle);
            this.listHandlersCompleted = null;
        }
        this.flags |= 2;
        if (!this.isChildAction()) {
            Game.getCurrentGame().getActionQueue().setLastActionAsComplete();
        }
    }

    public final boolean isCompleted() {
        return (this.flags & 2) != 0;
    }

    public final void reset() {
        this.dataTable.clear();
        this.flags &= 0xFFFFFF91;
        this.setAsNonOverridableAction();
        this.sourceOverrideResult = null;
        if (this.logEvent != null) {
            FX.run(() -> this.logEvent.enable());
        }
    }

    public final void setAsRuleProcAction() {
        this.flags |= 0x10;
    }

    public final boolean isRuleProcAction() {
        return (this.flags & 0x10) != 0;
    }

    public final int getOrderId() {
        return this.orderId;
    }

    public final DataTable<T> getDataTable() {
        return this.dataTable;
    }

    public final void setOnActionDispatched(GameActionHandler handler) {
        if (this.listHandlersDispatched == null) {
            this.listHandlersDispatched = new ArrayList<GameActionHandler>();
        }
        this.listHandlersDispatched.add(handler);
    }

    public final void setOnActionCompleted(GameActionHandler handler) {
        if (this.listHandlersCompleted == null) {
            this.listHandlersCompleted = new ArrayList<GameActionHandler>();
        }
        this.listHandlersCompleted.add(handler);
    }

    protected final void setOnActionBlocked(GameActionHandler handler) {
        this.handlerBlocked = handler;
    }

    public final void setOnActionOverridden(GameActionHandler handler) {
        this.handlerOverridden = handler;
    }

    public final void callOnActionOverridden() {
        if (this.handlerOverridden != null) {
            this.handlerOverridden.handle();
        }
    }

    public final boolean isDataReceived() {
        return (this.flags & 0x200) != 0;
    }

    public final void setReceivedPacketData(PacketParser pp) {
        this.ppReceived = pp;
    }

    public final void requestData() {
        this.requestData(2);
    }

    public final void requestData(int minExpectedArgs) {
        this.requestMinExpectedArgs = minExpectedArgs;
        if (Game.getCurrentGame().getFakeReceiver() instanceof SpecFakeGameReceiver) {
            FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameControls().setWaitingServerRequest(true));
        }
        if (this.ppReceived != null) {
            if (this.ppReceived.getDataArgsNum() < minExpectedArgs || !this.ppReceived.getDataArgument(0).equals(String.valueOf(this.orderId))) {
                this.ppReceived = null;
                return;
            }
            this.internalOnDataReceived(this.ppReceived);
            return;
        }
        try {
            GameSendActionAttempt attempt = new GameSendActionAttempt("RQ", this, this.getClass().getSimpleName());
            Player.getNetworkFrame().getGameReceiver().setCustomPacketRedirectByToken("RQX", pp -> {
                if (this.isDataReceived() || pp.getDataArgsNum() < 2) {
                    return;
                }
                if (pp.getDataArgsNum() < minExpectedArgs || !pp.getDataArgument(0).equals(String.valueOf(!this.isChildAction() ? this.orderId : Game.getCurrentGame().getActionQueue().getLastOrder()))) {
                    return;
                }
                Player.getNetworkFrame().getGameReceiver().stopPacketRedirectByToken("RQX");
                attempt.setReceivedPacketAsSatisfying();
                this.internalOnDataReceived(pp);
            });
            attempt.send();
        }
        catch (UnknownHostException ex) {
            Log.printMessage(ex);
        }
    }

    private void internalOnDataReceived(PacketParser pp) {
        this.flags |= 0x200;
        FX.run(() -> {
            if (Game.getCurrentGame().getFakeReceiver() instanceof SpecFakeGameReceiver) {
                UI.getTabGame().getFieldSceneOverlay().getGameControls().setWaitingServerRequest(false);
            }
            this.onDataReceived(pp);
            this.dispatch();
        });
    }

    public int getRequestMinExpectedArgs() {
        return this.requestMinExpectedArgs;
    }

    protected void onDataReceived(PacketParser pp) {
    }

    public static class ActionFlag {
        private static final int COMPLETED = 2;
        private static final int DISPATCHED = 4;
        private static final int MID_EFFECT = 8;
        private static final int RULE_PROC = 16;
        private static final int BLOCKED = 32;
        private static final int CHILD = 64;
        private static final int SERVER = 128;
        private static final int NON_MANDATORY = 256;
        private static final int RECEIVED_DATA = 512;
        @Deprecated
        private static final int NON_OVERRIDABLE = 1024;
    }

    @FunctionalInterface
    public static interface GameActionHandler {
        public void handle();
    }
}

