/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.EffectProcessing;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.RuleProcessing;
import open.batoru.core.gameplay.phases.PhaseList;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.game.GameField;
import open.batoru.game.overlay.log.events.LogEventAdvancePhase;
import open.batoru.game.overlay.log.events.LogEventAdvanceTurn;
import open.batoru.ui.UI;

public class GameRules
implements Disposable {
    private int turnCount;
    private Game.GamePlayerRole roleTurnPlayer;
    private boolean wasRetireUsed;
    private boolean isGuardStep;
    private int countTurnPlayerRefreshes;
    private boolean isTurnTerminated;
    private final PhaseList phaseList = new PhaseList();
    private final EffectProcessing processEffects = new EffectProcessing();
    private final RuleProcessing processRules = new RuleProcessing();
    private final PlayerRuleCheckRegistry ruleChecksHost = new PlayerRuleCheckRegistry();
    private final PlayerRuleCheckRegistry ruleChecksOP = new PlayerRuleCheckRegistry();

    public final PlayerRuleCheckRegistry getPlayerRuleChecks(Game.GamePlayerRole rolePlayer) {
        if (rolePlayer == Game.GamePlayerRole.HOST) {
            return this.ruleChecksHost;
        }
        if (rolePlayer == Game.GamePlayerRole.GUEST) {
            return this.ruleChecksOP;
        }
        throw new IllegalArgumentException();
    }

    public void advancePhase() {
        if (this.turnCount > 1 || this.phaseList.getCurrentPhase().getId() != GameConst.GamePhase.MAIN) {
            this.advanceNextPhaseEnd();
        } else {
            this.skipFirstTurnAttackPhase();
        }
    }

    private void advanceNextPhaseEnd() {
        if (this.getPlayerRuleChecks(this.roleTurnPlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.MUST_SKIP_PHASE).check(new PlayerRuleCheckData(this.roleTurnPlayer, null, null, new Object[]{this.phaseList.getNextPhase().getId()})) == RuleCheck.RuleCheckState.OK) {
            this.phaseList.skipNextPhase();
        }
        this.phaseList.getCurrentPhase().internalOnEnd();
    }

    public void advanceNextPhaseStart() {
        if (this.phaseList.getCurrentPhase().getId() == GameConst.GamePhase.END) {
            this.advanceTurn();
        }
        this.phaseList.advancePhaseId();
        if (this.isTurnTerminated) {
            this.phaseList.getCurrentPhase().setShouldForceCallNextEffects(false);
        }
        this.phaseList.getCurrentPhase().internalOnStart();
        this.isTurnTerminated = false;
        UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(new LogEventAdvancePhase(this.phaseList.getCurrentPhase().getId()));
    }

    private void advanceTurn() {
        ++this.turnCount;
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            Game.getCurrentGame().getRoom().getTurnCountProperty().set(this.turnCount);
        }
        if (this.getPlayerRuleChecks(this.roleTurnPlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.MUST_PASS_TURN_PLAYER).check(this.roleTurnPlayer) == RuleCheck.RuleCheckState.OK) {
            this.roleTurnPlayer = this.getTurnPlayerOpponent();
            if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
                Game.getCurrentGame().getRoom().getTurnPlayerRoleIdProperty().set(this.roleTurnPlayer.getId());
            }
        }
        this.wasRetireUsed = false;
        this.countTurnPlayerRefreshes = 0;
        UI.getTabGame().getFieldSceneOverlay().getGameControls().getButtonRetire().setDisable(false);
        UI.getTabGame().getFieldSceneOverlay().getGameControls().getButtonNextPhase().setDisable(this.roleTurnPlayer != Game.getCurrentGame().getPlayerRole());
        UI.getTabGame().getFieldSceneOverlay().getGameControls().setTurnCountNum(this.turnCount);
        UI.getTabGame().getFieldSceneOverlay().getGameControls().setActiveTurnPlayerArrow(this.roleTurnPlayer);
        GameField.highlightPlayerField(null);
        UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(new LogEventAdvanceTurn(this.roleTurnPlayer, this.turnCount));
    }

    public void setStartingPlayer(Game.GamePlayerRole rolePlayerFirst) {
        if (this.turnCount != 0) {
            return;
        }
        this.roleTurnPlayer = rolePlayerFirst;
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            Game.getCurrentGame().getRoom().getTurnPlayerRoleIdProperty().set(this.roleTurnPlayer.getId());
        }
        UI.getTabGame().getFieldSceneOverlay().getGameControls().setActiveTurnPlayerArrow(rolePlayerFirst);
    }

    public void initFirstTurn() {
        if (this.turnCount != 0) {
            return;
        }
        this.turnCount = 1;
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            Game.getCurrentGame().getRoom().getTurnCountProperty().set(this.turnCount);
        }
        UI.getTabGame().getFieldSceneOverlay().getGameControls().setTurnCountNum(1);
        GameField.highlightPlayerField(null);
        this.phaseList.setPhaseId(1);
        this.phaseList.getCurrentPhase().internalOnStart();
    }

    public void skipFirstTurnAttackPhase() {
        if (this.turnCount != 1) {
            return;
        }
        this.phaseList.getCurrentPhase().internalOnEnd();
        this.phaseList.setPhaseId(this.phaseList.getLastPhaseIndex() - 1);
    }

    public void forceEndTurn() {
        this.phaseList.setPhaseId(this.phaseList.getLastPhaseIndex() - 1);
        this.phaseList.getCurrentPhase().setShouldForceCallNextEffects(false);
        this.isTurnTerminated = true;
        this.advancePhase();
        this.phaseList.getCurrentPhase().setShouldForceCallNextEffects(false);
    }

    public boolean isTurnTerminated() {
        return this.isTurnTerminated;
    }

    public PhaseList getPhaseList() {
        return this.phaseList;
    }

    public EffectProcessing getEffectProcessor() {
        return this.processEffects;
    }

    public RuleProcessing getRuleProcessor() {
        return this.processRules;
    }

    public void setRetireAsUsed() {
        this.wasRetireUsed = true;
        UI.getTabGame().getFieldSceneOverlay().getGameControls().getButtonRetire().setDisable(true);
    }

    public boolean wasRetireUsed() {
        return this.wasRetireUsed;
    }

    public void setIsGuardStep(boolean set) {
        this.isGuardStep = set;
    }

    public boolean isGuardStep() {
        return this.isGuardStep;
    }

    public void incrementTurnPlayerRefreshesCount() {
        ++this.countTurnPlayerRefreshes;
    }

    public int getTurnPlayerRefreshesCount() {
        return this.countTurnPlayerRefreshes;
    }

    public int getTurnCount() {
        return this.turnCount;
    }

    public Game.GamePlayerRole getTurnPlayer() {
        return this.roleTurnPlayer;
    }

    public Game.GamePlayerRole getTurnPlayerOpponent() {
        return Game.GamePlayerRole.getOpponentRole(this.roleTurnPlayer);
    }

    public boolean isOwnTurn() {
        return this.roleTurnPlayer == Game.getCurrentGame().getPlayerRole();
    }

    @Override
    public void dispose() {
        this.phaseList.dispose();
        this.processEffects.dispose();
        this.processRules.dispose();
        this.ruleChecksHost.dispose();
        this.ruleChecksOP.dispose();
    }
}

