/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import open.batoru.Log;
import open.batoru.core.Deck;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionBanish;
import open.batoru.core.gameplay.actions.ActionEffectDecideLifeBurst;
import open.batoru.core.gameplay.actions.ActionEffectManualDecideLifeBurst;
import open.batoru.core.gameplay.actions.ActionExclude;
import open.batoru.core.gameplay.actions.ActionForceTurnEnd;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.actions.ActionPutInEner;
import open.batoru.core.gameplay.actions.ActionRefresh;
import open.batoru.core.gameplay.actions.ActionShuffleDeck;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.actions.override.OverrideActionList;
import open.batoru.core.gameplay.actions.override.OverrideResult;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.DataTable;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.events.EventRefresh;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneCheck;
import open.batoru.game.ZoneDeck;
import open.batoru.game.ZoneLRIGAssist;
import open.batoru.game.ZoneSIGNI;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class RuleProcessing
implements Disposable {
    private final List<OnRuleProcessingFinishedHandler> listHandlers = Collections.synchronizedList(new ArrayList());
    private final List<GameAction<?>> listRuleProcActions = new ArrayList();
    private final Map<Game.GamePlayerRole, Integer> stepLRIGCheckValuesExceed = new EnumMap<Game.GamePlayerRole, Integer>(Game.GamePlayerRole.class);
    private final Map<CardIndex, Integer> cacheLRIGCheckSIGNILevels = new HashMap<CardIndex, Integer>();
    private final List<AbilityCostList> costLists = new ArrayList<AbilityCostList>();
    private int waitingCosts;
    private boolean wasEffectActivatedByWaitingCosts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process() {
        if (!this.listRuleProcActions.isEmpty()) {
            return;
        }
        Log.printMessage(">>> rule processing");
        Game.GamePlayerRole turnPlayer = Game.getCurrentGame().getGameRules().getTurnPlayer();
        Game.GamePlayerRole turnPlayerOpponent = Game.getCurrentGame().getGameRules().getTurnPlayerOpponent();
        if (this.processZeroPowerSIGNI(turnPlayer) && this.processZeroPowerSIGNI(turnPlayerOpponent) && this.processLRIGValuesExceed(turnPlayer) && this.processLRIGValuesExceed(turnPlayerOpponent) && this.processOrphanedUnderCards(turnPlayer) && this.processOrphanedUnderCards(turnPlayerOpponent) && this.processLifeBurst(turnPlayer) && this.processLifeBurst(turnPlayerOpponent) && this.processRefresh(turnPlayer) && this.processRefresh(turnPlayerOpponent) && this.processKeys(turnPlayer) && this.processKeys(turnPlayerOpponent) && this.processSIGNINumLimits(turnPlayer) && this.processSIGNINumLimits(turnPlayerOpponent) && this.processAssistLRIGTypeConflicts(turnPlayer) && this.processAssistLRIGTypeConflicts(turnPlayerOpponent)) {
            if (this.listRuleProcActions.isEmpty() && this.waitingCosts == 0) {
                List<OnRuleProcessingFinishedHandler> list = this.listHandlers;
                synchronized (list) {
                    if (!this.listHandlers.isEmpty()) {
                        this.listHandlers.forEach(OnRuleProcessingFinishedHandler::handle);
                        this.listHandlers.clear();
                        Log.printMessage(">>> handled");
                    }
                }
                Game.getCurrentGame().getIdleStateCoordinator().markAsIdle(this);
            }
        } else {
            Game.getCurrentGame().getIdleStateCoordinator().markAsBusy(this);
        }
    }

    private boolean processZeroPowerSIGNI(Game.GamePlayerRole rolePlayer) {
        ArrayList<ActionBanish> cacheActions = new ArrayList<ActionBanish>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            CardIndex cardIndex;
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (!FieldZone.isOccupied(zoneSIGNI) || !CardConst.CardType.isSIGNI((cardIndex = zoneSIGNI.getTopCard().getCardIndex()).getCardReference().getType()) || !(cardIndex.getIndexedInstance().getPower().getValue() <= 0.0) || cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_BANISHED).check(cardIndex) != RuleCheck.RuleCheckState.OK) continue;
            ActionBanish action = new ActionBanish(cardIndex);
            cacheActions.add(action);
        }
        if (!cacheActions.isEmpty()) {
            this.addActions(cacheActions);
            return false;
        }
        return true;
    }

    private boolean processLRIGValuesExceed(Game.GamePlayerRole rolePlayer) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        int level = field.getLRIGZone().getTopCard().getCardIndex().getIndexedInstance().getLevel().getValue();
        double limit = field.getLRIGZone().getTopCard().getCardIndex().getIndexedInstance().getLimit().getValue();
        TargetFilter filterLevelExceed = null;
        if ((double)field.getSIGNILimitSum() > limit || (filterLevelExceed = new TargetFilter(TargetFilter.TargetHint.TRASH, rolePlayer).own().SIGNI().withLevel(level + 1, 0)).getValidTargetsCount(true) > 0) {
            int step = this.stepLRIGCheckValuesExceed.getOrDefault((Object)rolePlayer, 0);
            switch (step) {
                case 0: {
                    for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                        CardIndex cardIndex;
                        ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
                        if (!FieldZone.isOccupied(zoneSIGNI) || this.cacheLRIGCheckSIGNILevels.get(cardIndex = zoneSIGNI.getTopCard().getCardIndex()) != null) continue;
                        this.cacheLRIGCheckSIGNILevels.put(cardIndex, cardIndex.getIndexedInstance().getLevel().getValue());
                    }
                    if (filterLevelExceed != null && filterLevelExceed.getValidTargetsCount() > 0) {
                        GameAction actionChoice = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualTargetCard(1, 1, filterLevelExceed, null, AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(filterLevelExceed);
                        this.addAction(actionChoice);
                        this.addAction(new ActionTrash());
                        return false;
                    }
                    this.stepLRIGCheckValuesExceed.put(rolePlayer, step + 1);
                }
                case 1: {
                    DataTable<CardIndex> dataLevelChanged = new DataTable<CardIndex>();
                    for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
                        CardIndex cardIndex;
                        ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
                        if (!FieldZone.isOccupied(zoneSIGNI) || this.cacheLRIGCheckSIGNILevels.get(cardIndex = zoneSIGNI.getTopCard().getCardIndex()) == null || Objects.equals(cardIndex.getIndexedInstance().getLevel().getValue(), this.cacheLRIGCheckSIGNILevels.get(cardIndex))) continue;
                        dataLevelChanged.add(cardIndex);
                    }
                    if (!dataLevelChanged.isEmpty()) {
                        TargetFilter filterLevelChanged = new TargetFilter(TargetFilter.TargetHint.TRASH, rolePlayer).own().SIGNI().match(dataLevelChanged);
                        GameAction actionChoice = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualTargetCard(1, 1, filterLevelChanged, null, AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(filterLevelChanged);
                        this.addAction(actionChoice);
                        this.addAction(new ActionTrash());
                        return false;
                    }
                    this.stepLRIGCheckValuesExceed.put(rolePlayer, step + 1);
                }
                case 2: {
                    if (field.getSIGNICount(true) > 0) {
                        TargetFilter filterTrashGeneric = new TargetFilter(TargetFilter.TargetHint.TRASH, rolePlayer).own().SIGNI();
                        GameAction actionChoice = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualTargetCard(1, 1, filterTrashGeneric, null, AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(filterTrashGeneric);
                        this.addAction(actionChoice);
                        this.addAction(new ActionTrash());
                        return false;
                    }
                    this.stepLRIGCheckValuesExceed.remove((Object)rolePlayer);
                }
            }
        } else {
            this.stepLRIGCheckValuesExceed.remove((Object)rolePlayer);
            this.cacheLRIGCheckSIGNILevels.entrySet().removeIf(set -> ((CardIndex)set.getKey()).getCurrentOwnerSafe() == rolePlayer);
        }
        return true;
    }

    private boolean processOrphanedUnderCards(Game.GamePlayerRole rolePlayer) {
        ArrayList<ActionTrash> cacheActions = new ArrayList<ActionTrash>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (zoneSIGNI.getTopCard() == null) continue;
            CardIndex cardIndexTop = zoneSIGNI.getTopCard().getCardIndex();
            for (int i = zoneSIGNI.getTotalCards() - 1; i >= 0; --i) {
                CardIndex cardIndex = zoneSIGNI.getZoneCardList().get(i).getCardIndex();
                if (cardIndex.getUnderType().getUnderCategory() == GameConst.CardUnderCategory.ZONE || !(cardIndex.getIndexedInstance() != null && cardIndex.getIndexedInstance().isState(256) || cardIndexTop.getIndexedInstance().isState(256) || cardIndexTop.getUnderType().getUnderCategory() == GameConst.CardUnderCategory.ZONE && cardIndex.getUnderType().getUnderCategory() != GameConst.CardUnderCategory.UNDER || !CardConst.CardType.isSIGNI(cardIndexTop.getCardReference().getType())) && (cardIndex == cardIndexTop || cardIndex.getUnderType() != GameConst.CardUnderType.NONE || CardConst.CardType.isSIGNI(cardIndex.getCardReference().getType()))) continue;
                cacheActions.add((ActionTrash)(!cardIndex.getIndexedInstance().isState(8) ? new ActionTrash(cardIndex) : new ActionExclude(cardIndex)));
            }
        }
        if (!cacheActions.isEmpty()) {
            this.addActions(cacheActions);
            return false;
        }
        return true;
    }

    private boolean processLifeBurst(Game.GamePlayerRole rolePlayer) {
        ArrayList<ActionPutInEner> cacheActions = new ArrayList<ActionPutInEner>();
        ArrayList<CardIndex> cacheUndecidedLBCards = new ArrayList<CardIndex>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        ZoneCheck zoneCheck = field.getCheckZone();
        for (int i = zoneCheck.getTotalCards() - 1; i >= 0; --i) {
            CardIndex cardIndex = zoneCheck.getZoneCardList().get(i).getCardIndex();
            if (cardIndex.getIndexedInstance().isState(256)) {
                cacheActions.add(new ActionPutInEner(cardIndex));
                continue;
            }
            if (!cardIndex.getIndexedInstance().isState(64)) continue;
            cacheUndecidedLBCards.add(cardIndex);
        }
        if (!cacheActions.isEmpty() || !cacheUndecidedLBCards.isEmpty()) {
            if (!cacheActions.isEmpty()) {
                this.addActions(cacheActions);
            }
            if (!cacheUndecidedLBCards.isEmpty()) {
                GameAction actionDecideLB = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionEffectManualDecideLifeBurst(cacheUndecidedLBCards) : new ActionEffectDecideLifeBurst(rolePlayer, cacheUndecidedLBCards);
                this.addAction(actionDecideLB);
            }
            return false;
        }
        if (!this.costLists.isEmpty()) {
            this.waitingCosts = this.costLists.size();
            for (AbilityCostList costList : this.costLists) {
                this.addAction(new ActionPayCost(costList));
            }
            this.costLists.clear();
            return false;
        }
        return true;
    }

    public void addCostList(AbilityCostList costList) {
        costList.setForcedMandatoryState(false);
        this.costLists.add(costList);
    }

    public void markCostAsHandled(boolean wasEffectActivated) {
        if (this.waitingCosts <= 0) {
            return;
        }
        if (wasEffectActivated) {
            this.wasEffectActivatedByWaitingCosts = true;
        }
        if (--this.waitingCosts == 0) {
            if (!this.wasEffectActivatedByWaitingCosts) {
                this.process();
            } else {
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            }
            this.wasEffectActivatedByWaitingCosts = false;
        }
    }

    private boolean processRefresh(Game.GamePlayerRole rolePlayer) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        ZoneDeck zoneDeck = field.getDeckZone(Deck.DeckType.MAIN);
        ZoneDeck zoneTrash = field.getTrashZone(Deck.DeckType.MAIN);
        if (zoneDeck.getZoneCardList().isEmpty() && !zoneTrash.getZoneCardList().isEmpty()) {
            if (rolePlayer == Game.getCurrentGame().getGameRules().getTurnPlayer()) {
                Game.getCurrentGame().getGameRules().incrementTurnPlayerRefreshesCount();
            }
            ActionRefresh actionRefresh = new ActionRefresh(rolePlayer);
            this.addAction(actionRefresh);
            GameAction lastRefreshAction = new ActionShuffleDeck(rolePlayer, -1, Deck.DeckPosition.TOP);
            this.addAction(lastRefreshAction);
            EventRefresh eventRefresh = new EventRefresh(rolePlayer);
            OverrideResult overrideResult = OverrideAction.findActiveOverrideActions(rolePlayer, actionRefresh, eventRefresh);
            if (overrideResult.isEmpty()) {
                if (!field.getLifeClothZone().getZoneCardList().isEmpty() && Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.MUST_TRASH_LC_ON_REFRESH).check(rolePlayer) == RuleCheck.RuleCheckState.OK) {
                    lastRefreshAction = new ActionTrash();
                    this.addAction(lastRefreshAction);
                }
            } else {
                OverrideAction overrideAction = overrideResult.getOverrideActions().getFirst();
                overrideResult.setCurrentOverrideAction(overrideAction);
                OverrideActionList list = overrideAction.prepareOverrideActionList(overrideResult);
                for (int i = 0; i < list.getTotalActions(); ++i) {
                    lastRefreshAction = list.getAction(i, 0);
                    this.addAction(lastRefreshAction);
                }
            }
            if (Game.getCurrentGame().getGameRules().getTurnPlayerRefreshesCount() < 2) {
                lastRefreshAction.setOnActionCompleted(() -> Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(eventRefresh));
            } else {
                this.addAction(new ActionForceTurnEnd());
            }
            return false;
        }
        return true;
    }

    private boolean processKeys(Game.GamePlayerRole rolePlayer) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        if (field.getKeyZone().getTotalCards() == 0) {
            return true;
        }
        int max = Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleValue(PlayerRuleCheckRegistry.PlayerRuleValueType.MAX_ALLOWED_KEYS).getValue();
        int numToTrash = field.getKeyZone().getTotalCards() - max;
        if (numToTrash > 0) {
            TargetFilter filter = new TargetFilter(TargetFilter.TargetHint.TRASH, rolePlayer).own().key().not(new TargetFilter().withState(1024));
            DataTable data = filter.getExportedData(true);
            if (data.size() == 1) {
                this.addAction(new ActionTrash((CardIndex)data.get()));
            } else {
                GameAction actionChoice = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualTargetCard(numToTrash, numToTrash, filter, null, AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(filter);
                this.addAction(actionChoice);
                for (int i = 0; i < numToTrash; ++i) {
                    this.addAction(new ActionTrash());
                }
            }
            return false;
        }
        return true;
    }

    private boolean processSIGNINumLimits(Game.GamePlayerRole rolePlayer) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        for (GameConst.SIGNIZonePosition zonePosition : GameConst.SIGNIZonePosition.values()) {
            ZoneSIGNI zoneSIGNI = field.getSIGNIZone(zonePosition);
            if (!ZoneSIGNI.isOccupied(zoneSIGNI)) continue;
            CardIndex cardIndexTop = zoneSIGNI.getTopCard().getCardIndex();
            TargetFilter filter = new TargetFilter(TargetFilter.TargetHint.TRASH, rolePlayer).own().fromLocation(zoneSIGNI.getZoneLocation()).withUnderType(GameConst.CardUnderType.NONE);
            if (filter.getValidTargetsCount(true) <= 1) continue;
            GameAction actionChoice = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualTargetCard(1, 1, filter, null, AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(filter);
            this.addAction(actionChoice);
            ActionTrash actionTrash = new ActionTrash();
            actionTrash.setOnActionCompleted(() -> {
                if (actionTrash.getCardIndex() == cardIndexTop) {
                    Game.getCurrentGame().getGameRules().getEffectProcessor().addConstantUpdatePostProcessingJob(() -> FX.run(() -> {
                        zoneSIGNI.resetListeners();
                        zoneSIGNI.updateZone(null);
                    }));
                }
            });
            this.addAction(actionTrash);
            return false;
        }
        int max = Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleValue(PlayerRuleCheckRegistry.PlayerRuleValueType.MAX_ALLOWED_SIGNI).getValue();
        int numToTrash = field.getSIGNICount(true) - max;
        if (numToTrash > 0) {
            TargetFilter filter = new TargetFilter(TargetFilter.TargetHint.TRASH, rolePlayer).own().SIGNI();
            GameAction actionChoice = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualTargetCard(numToTrash, numToTrash, filter, null, AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(filter);
            this.addAction(actionChoice);
            for (int i = 0; i < numToTrash; ++i) {
                this.addAction(new ActionTrash());
            }
            return false;
        }
        return true;
    }

    private boolean processAssistLRIGTypeConflicts(Game.GamePlayerRole rolePlayer) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer);
        if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft()) || FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
            CardIndex cardIndex;
            Object centerLRIGTypes = field.getLRIGZone().getTopCard().getCardIndex().getIndexedInstance().getLRIGType().getValue();
            Object assistLRIGTypes = null;
            ArrayList<ZoneLRIGAssist> cacheLRIGToTrash = null;
            if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
                cardIndex = field.getLRIGAssistZoneLeft().getTopCard().getCardIndex();
                if (cardIndex.getIndexedInstance().getLRIGType().getValue().equals(centerLRIGTypes)) {
                    cacheLRIGToTrash = new ArrayList<ZoneLRIGAssist>();
                    cacheLRIGToTrash.add(field.getLRIGAssistZoneLeft());
                } else {
                    assistLRIGTypes = cardIndex.getIndexedInstance().getLRIGType().getValue();
                }
            }
            if (FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
                cardIndex = field.getLRIGAssistZoneRight().getTopCard().getCardIndex();
                if (cardIndex.getIndexedInstance().getLRIGType().getValue().equals(centerLRIGTypes)) {
                    if (cacheLRIGToTrash == null) {
                        cacheLRIGToTrash = new ArrayList();
                    }
                    cacheLRIGToTrash.add(field.getLRIGAssistZoneRight());
                } else if (cardIndex.getIndexedInstance().getLRIGType().getValue().equals(assistLRIGTypes)) {
                    cacheLRIGToTrash = new ArrayList();
                    cacheLRIGToTrash.add(field.getLRIGAssistZoneLeft());
                    cacheLRIGToTrash.add(field.getLRIGAssistZoneRight());
                }
            }
            if (cacheLRIGToTrash != null) {
                if (cacheLRIGToTrash.size() == 1) {
                    ArrayList<ActionTrash> cacheActions = new ArrayList<ActionTrash>();
                    FieldZone zone = (FieldZone)cacheLRIGToTrash.getFirst();
                    for (int i = zone.getTotalCards() - 1; i >= 0; --i) {
                        ActionTrash actionTrash = new ActionTrash(zone.getZoneCardList().get(i).getCardIndex());
                        cacheActions.add(actionTrash);
                    }
                    this.addActions(cacheActions);
                } else {
                    TargetFilter filterTrashLRIG = new TargetFilter(TargetFilter.TargetHint.TRASH, rolePlayer).own().anyLRIG().except(GameConst.CardLocation.LRIG);
                    int maxNumToTrash = Math.max(((FieldZone)cacheLRIGToTrash.getFirst()).getTotalCards(), ((FieldZone)cacheLRIGToTrash.getLast()).getTotalCards());
                    GameAction actionChoice = PlayerControl.isChoosingPlayer(rolePlayer) ? new ActionManualTargetCard(1, 1, filterTrashLRIG, null, AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(filterTrashLRIG);
                    this.addAction(actionChoice);
                    for (int i = 0; i < maxNumToTrash; ++i) {
                        this.addAction(new ActionTrash());
                    }
                }
                return false;
            }
        }
        return true;
    }

    private <T> void addActions(List<? extends GameAction<T>> cacheActions) {
        GameAction<T> prevAction = null;
        for (int i = 0; i < cacheActions.size(); ++i) {
            GameAction<T> action = cacheActions.get(i);
            action.setAtOnce(prevAction, i, cacheActions.size());
            prevAction = action;
            this.addAction(action);
        }
    }

    private void addAction(GameAction<?> action) {
        action.setAsRuleProcAction();
        this.listRuleProcActions.add(action);
        Game.getCurrentGame().getActionQueue().addAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnRuleProcessingFinished(OnRuleProcessingFinishedHandler handler) {
        if (handler != null) {
            List<OnRuleProcessingFinishedHandler> list = this.listHandlers;
            synchronized (list) {
                this.listHandlers.add(handler);
            }
        }
    }

    public void purgeRuleProcAction(GameAction<?> action) {
        if (!this.listRuleProcActions.remove(action)) {
            Log.printMessage(true, "Warning: Attempted to purge an action not in rule processing list. (" + String.valueOf(action) + ")");
        }
    }

    public void setRuleProcActionAsComplete(GameAction<?> action) {
        if (this.listRuleProcActions.remove(action)) {
            if (this.listRuleProcActions.isEmpty()) {
                this.process();
            }
        } else {
            Log.printMessage(true, "Warning: Attempted to complete an action not in rule processing list. (" + String.valueOf(action) + ")");
        }
    }

    @Override
    public void dispose() {
        this.listHandlers.clear();
        this.listRuleProcActions.clear();
        this.stepLRIGCheckValuesExceed.clear();
        this.cacheLRIGCheckSIGNILevels.clear();
    }

    @FunctionalInterface
    public static interface OnRuleProcessingFinishedHandler {
        public void handle();
    }
}

