/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game.PlayerField;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionAddToHand
extends TransientCardGameAction {
    public ActionAddToHand(CardIndex cardIndex) {
        super(cardIndex);
    }

    public ActionAddToHand() {
    }

    @Override
    protected void dispatch() {
        if (!this.isDataReceived() && (this.getCardIndex() == null || this.getCardIndex().getIndexedInstance() == null && this.getCardIndex().getLocation() == GameConst.CardLocation.LOOKED)) {
            this.requestData();
            return;
        }
        if (this.getCardIndex() == null || this.getCardIndex().getLocation() == GameConst.CardLocation.HAND || this.getSourceAbility() != null && this.getCardIndex().getIndexedInstance() != null && (this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, new Object[]{GameConst.CardLocation.HAND}) == RuleCheck.RuleCheckState.BLOCK)) {
            this.setAsCompleted();
            return;
        }
        EventMove event = new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.HAND);
        event.setAtOnce(this);
        this.setLogEvent(new LogEventMove(event, AbilityConst.ActionHint.HAND));
        if (this.getCardIndex().getIndexedInstance() != null && (this.applyActiveOverrideActions(this.getCardIndex().getCurrentOwnerSafe(), event) || ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this))) {
            return;
        }
        if (this.getCardIndex().getLocation() == GameConst.CardLocation.LIFE_CLOTH) {
            UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.getCardIndex().getCurrentOwnerSafe()).moveNext(this.getCardIndex().getImageSet(), false, this.getLogEvent());
        }
        this.addCardIndexData();
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(event);
        AnimationTracker tracker = new AnimationTracker(this.getCardIndex().getIndexedInstance() != null && this.getCardIndex().getLocation() != GameConst.CardLocation.REVEALED && GameConst.CardLocation.isPublic(this.getCardIndex().getLocation()) && this.getCardIndex().isFaceUp() ? 2 : 1);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getCurrentOwnerSafe());
        if (tracker.getMaxCount() > 1) {
            TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
            AnimationCardMove aniReveal = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), field.getRevealZone());
            aniReveal.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniReveal);
            AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), field.getHand());
            aniMove.setDelay(300.0);
            aniMove.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniMove);
            seqAni.play();
        } else {
            AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), field.getHand());
            if (this.getCardIndex().getLocation() != GameConst.CardLocation.REVEALED && this.getCardIndex().getOldLocation() == GameConst.CardLocation.HAND && this.getCardIndex().isFaceUp()) {
                aniMove.setDelay(300.0);
            }
            aniMove.setAnimationTracker(tracker);
            aniMove.play();
        }
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (this.getCardIndex() != null && this.getCardIndex().isFaceUp()) {
            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(1), this.getCardIndex().getSourceCard3D());
        } else {
            CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> this.setCardIndex(card3D.getCardIndex()));
        }
    }
}

