/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.events.EventAttach;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game.FieldStackZone;
import open.batoru.game.Zone;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionAttach
extends TransientCardGameAction {
    private final CardIndex target;
    private final GameConst.CardUnderType underType;

    public ActionAttach(CardIndex target, CardIndex source, GameConst.CardUnderType underType) {
        super(source);
        this.target = target;
        this.underType = underType;
    }

    public ActionAttach(CardIndex target, GameConst.CardLocation location, GameConst.CardUnderType underType) {
        this.target = target;
        this.underType = underType;
    }

    @Override
    protected void dispatch() {
        if (!(this.isDataReceived() || this.getCardIndex() != null && this.getCardIndex().getIndexedInstance() != null)) {
            this.requestData();
            return;
        }
        if (this.target == null || this.getCardIndex().getIndexedInstance() == null || !GameConst.CardLocation.isSIGNI(this.target.getLocation()) && !GameConst.CardLocation.isLRIG(this.target.getLocation()) || this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, new Object[]{this.target.getLocation()}) == RuleCheck.RuleCheckState.BLOCK) {
            this.setAsCompleted();
            return;
        }
        if (this.underType.getUnderCategory() == GameConst.CardUnderCategory.ATTACHED && !ActionAttach.canAttachTo(this.target, this.underType)) {
            this.setAsCompleted();
            return;
        }
        EventMove eventMove = new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), this.target.getLocation(), true);
        eventMove.setAtOnce(this);
        this.setLogEvent(new LogEventMove(eventMove, this.underType.getUnderCategory().getTargetHint()));
        if (ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this)) {
            return;
        }
        this.addCardIndexData();
        if (this.getCardIndex().getIndexedInstance() != null && !CardIndex.isOwnCard(this.getCardIndex())) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.getCardIndex());
        }
        FieldStackZone zoneTarget = (FieldStackZone)this.target.getZoneByLocation();
        EventAttach eventAttach = new EventAttach(this.target, this.underType, this.getCardIndex(), this.getSourceAbility());
        eventAttach.setAtOnce(this);
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventAttach, eventMove);
        AnimationTracker tracker = new AnimationTracker(this.shouldPseudoReveal() ? 2 : 1);
        tracker.setOnTrackerAllFinished(() -> {
            zoneTarget.getZoneUnderCardsIndicators().addUnderType(this.underType);
            this.getCardIndex().setUnderType(this.underType);
            switch (this.underType) {
                case UNDER_BLOOD_CRYSTAL_ARM: {
                    this.target.getIndexedInstance().getCardStateFlags().addValue(524288);
                }
            }
            this.setAsCompleted();
        });
        AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), (Zone)zoneTarget, Zone.ZonePosition.BOTTOM);
        aniMove.setAnimationTracker(tracker);
        if (tracker.getMaxCount() == 1) {
            aniMove.play();
        } else {
            TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
            AnimationCardMove aniReveal = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getCurrentOwnerSafe()).getRevealZone());
            aniReveal.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniReveal);
            aniMove.setDelay(300.0);
            seqAni.getAnimationList().add(aniMove);
            seqAni.play();
        }
    }

    private boolean shouldPseudoReveal() {
        return this.getCardIndex().getIndexedInstance() != null && !GameConst.CardLocation.isSIGNI(this.getCardIndex().getLocation()) && this.getCardIndex().getLocation() != GameConst.CardLocation.ENER && (this.target.getLocation() != GameConst.CardLocation.LRIG || this.getCardIndex().getLocation() != GameConst.CardLocation.LRIG_ASSIST_LEFT && this.getCardIndex().getLocation() != GameConst.CardLocation.LRIG_ASSIST_RIGHT);
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (this.getCardIndex() != null) {
            CardIndex.assignCardFromShortPacketData(pp.getDataArgument(1), this.getCardIndex().getSourceCard3D());
        } else {
            CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> this.setCardIndex(card3D.getCardIndex()));
        }
    }

    public static boolean canAttachTo(CardIndex cardIndex, GameConst.CardUnderType underType) {
        return cardIndex.getIndexedInstance().getCardsUnderCount(underType) < cardIndex.getIndexedInstance().getRCRegistry().getRuleValue(CardRuleCheckRegistry.CardRuleValueType.MAX_ATTACHMENTS).getValue();
    }
}

