/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.LinkedHashSet;
import java.util.List;
import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionAttackBattlePre;
import open.batoru.core.gameplay.actions.ActionAttackLRIG;
import open.batoru.core.gameplay.actions.ActionManualChoiceCost;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.card.RuleCheckCanAttackSIGNIZone;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.EventAttack;
import open.batoru.data.ability.events.EventHeaven;
import open.batoru.game.FieldZoneCrossIndicator;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneLRIG;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game.animations.AnimationCardRotate;
import open.batoru.game.animations.AnimationHeaven;
import open.batoru.game.animations.AnimationTexturedMeshFlash;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.ui.UI;

public class ActionAttack
extends GameAction<CardIndex> {
    private CardIndex cardIndex;
    private int instanceId;
    private final EventAttack eventAttack;
    private RuleCheckCanAttackSIGNIZone.SIGNIZoneAttackPositionGroup groupAtkTargets;
    private Game.GamePlayerRole rolePlayer;
    private Game.GamePlayerRole rolePlayerOpponent;

    public ActionAttack(CardIndex cardIndex, EventAttack eventAttack) {
        this.cardIndex = cardIndex;
        this.eventAttack = eventAttack;
    }

    @Override
    protected void dispatch() {
        this.rolePlayer = this.cardIndex.getIndexedInstance().getCurrentOwner();
        this.rolePlayerOpponent = Game.GamePlayerRole.getOpponentRole(this.rolePlayer);
        if (this.applyActiveOverrideActions(this.cardIndex.getCurrentOwnerSafe(), this.eventAttack)) {
            return;
        }
        this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(32768);
        Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
        List<AbilityCostList> dataCostListsLandAttack = ((AbilityCost)this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_LAND_ATTACK).check(this.cardIndex)).getSourceCostList().getSourceDataCostLists();
        RuleCheckCanAttackSIGNIZone ruleCheckCanAttackSIGNIZone = (RuleCheckCanAttackSIGNIZone)this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.MUST_ATTACK_SIGNI_ZONE);
        this.groupAtkTargets = (RuleCheckCanAttackSIGNIZone.SIGNIZoneAttackPositionGroup)ruleCheckCanAttackSIGNIZone.check(this.cardIndex);
        this.instanceId = this.cardIndex.getIndexedInstance().getInstanceId();
        GameConst.CardLocation location = this.cardIndex.getLocation();
        Game.getCurrentGame().getGameRules().getEffectProcessor().setOnEffectProcessingFinished(() -> Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> {
            CardIndex activeAttacker = this.eventAttack.getActiveAttacker();
            if (this.cardIndex != activeAttacker) {
                this.cardIndex = activeAttacker;
                if (activeAttacker.getIndexedInstance() != null) {
                    this.instanceId = activeAttacker.getIndexedInstance().getInstanceId();
                }
            }
            Game.getCurrentGame().getIdleStateCoordinator().setOnNextIdle(() -> {
                if (!GameConst.CardLocation.isSIGNI(this.cardIndex.getLocation()) && !GameConst.CardLocation.isLRIG(this.cardIndex.getLocation()) || !this.cardIndex.isFaceUp() || this.cardIndex.getIndexedInstance() == null || this.cardIndex.getIndexedInstance().getInstanceId() != this.instanceId) {
                    return;
                }
                if (this.cardIndex.getLocation() != location) {
                    this.groupAtkTargets = (RuleCheckCanAttackSIGNIZone.SIGNIZoneAttackPositionGroup)ruleCheckCanAttackSIGNIZone.check(this.cardIndex);
                }
                if (!Game.getCurrentGame().getGameRules().isTurnTerminated() && Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.rolePlayerOpponent).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_BE_ATTACKED).check(this.rolePlayerOpponent, this.cardIndex, new Object[0]) == RuleCheck.RuleCheckState.OK && this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_LAND_ATTACK).check(this.cardIndex) == RuleCheck.RuleCheckState.OK) {
                    if (dataCostListsLandAttack.isEmpty()) {
                        this.dispatchAttack();
                    } else {
                        GameAction action = PlayerControl.isChoosingPlayer(this.rolePlayer) ? new ActionManualChoiceCost(dataCostListsLandAttack) : new ActionPlayerChoiceInteger();
                        action.setOnActionCompleted(() -> {
                            if (ActionPayCost.isCostActionSuccessful(action)) {
                                AbilityCostList costListChosen = (AbilityCostList)dataCostListsLandAttack.get((Integer)action.getDataTable().get());
                                if (costListChosen.canBePaid()) {
                                    costListChosen.setOnCostHandledAll(() -> {
                                        if (costListChosen.isPaid()) {
                                            this.dispatchAttack();
                                        } else {
                                            this.dispatchAttackDisable();
                                        }
                                    });
                                    Game.getCurrentGame().getActionQueue().addAction(new ActionPayCost(costListChosen));
                                } else {
                                    this.dispatchAttackDisable();
                                }
                            } else {
                                this.dispatchAttackDisable();
                            }
                        });
                        action.treatAsMidEffAction();
                        Game.getCurrentGame().getActionQueue().addAction(action);
                    }
                } else {
                    this.dispatchAttackDisable();
                }
            });
        }));
        if (!(this.cardIndex.getZoneByLocation() instanceof ZoneSIGNI) || !this.cardIndex.getIndexedInstance().isCrossed()) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(this.eventAttack);
        } else {
            this.dispatchAttackCheckCrossedHeaven();
        }
        this.setAsCompleted();
    }

    private void dispatchAttackCheckCrossedHeaven() {
        LinkedHashSet<CardIndex> listCardsToReachHeaven = new LinkedHashSet<CardIndex>();
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getIndexedInstance().getCurrentOwner());
        AnimationTracker tracker = new AnimationTracker(0);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, 2);
        for (FieldZoneCrossIndicator.CrossPosition position : FieldZoneCrossIndicator.CrossPosition.values()) {
            int expectedAngle;
            GameConst.CardLocation locationOther;
            GameConst.SIGNIZonePosition zonePosOther;
            ZoneSIGNI zoneSIGNIOther;
            CardIndex cardIndexOther;
            int flagCrossedState;
            int n = flagCrossedState = position == FieldZoneCrossIndicator.CrossPosition.LEFT ? 131072 : 262144;
            if (!this.cardIndex.getIndexedInstance().isState(flagCrossedState) || !(cardIndexOther = (zoneSIGNIOther = field.getSIGNIZone(zonePosOther = GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(locationOther = position == FieldZoneCrossIndicator.CrossPosition.LEFT ? GameConst.CardLocation.getLeftSIGNILocation(this.cardIndex.getLocation()) : GameConst.CardLocation.getRightSIGNILocation(this.cardIndex.getLocation())))).getTopCard().getCardIndex()).getIndexedInstance().isState(16384)) continue;
            ZoneSIGNI zoneSIGNIOwn = (ZoneSIGNI)this.cardIndex.getZoneByLocation();
            zoneSIGNIOwn.getZoneCrossIndicator(position).setState(FieldZoneCrossIndicator.CrossState.HEAVEN);
            zoneSIGNIOther.getZoneCrossIndicator(position == FieldZoneCrossIndicator.CrossPosition.LEFT ? FieldZoneCrossIndicator.CrossPosition.RIGHT : FieldZoneCrossIndicator.CrossPosition.LEFT).setState(FieldZoneCrossIndicator.CrossState.HEAVEN);
            AnimationHeaven aniHeaven = new AnimationHeaven(zoneSIGNIOwn, position);
            aniHeaven.play();
            int n2 = expectedAngle = position == FieldZoneCrossIndicator.CrossPosition.LEFT ? 90 : -90;
            if (cardIndexOther.getSourceCard3D().getRotateZ() != (double)expectedAngle) {
                AnimationCardRotate aniFixAngle = new AnimationCardRotate(cardIndexOther.getSourceCard3D(), expectedAngle);
                aniFixAngle.setAnimationTracker(tracker);
                seqAni.getAnimationList(tracker.getMaxCount()).add(aniFixAngle);
                tracker.setMaxCount(tracker.getMaxCount() + 1);
            }
            listCardsToReachHeaven.add(this.cardIndex);
            listCardsToReachHeaven.add(cardIndexOther);
        }
        listCardsToReachHeaven.forEach(cardIndex -> {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventHeaven((CardIndex)cardIndex));
            ZoneSIGNI zoneSIGNI = (ZoneSIGNI)cardIndex.getZoneByLocation();
            AnimationTexturedMeshFlash aniFlash = new AnimationTexturedMeshFlash(zoneSIGNI.getZoneMesh(), zoneSIGNI.getDefaultColor(), Color.GOLD, true, 275);
            aniFlash.play();
        });
        if (tracker.getMaxCount() == 0) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(this.eventAttack);
        } else {
            Game.getCurrentGame().getIdleStateCoordinator().markAsBusy(seqAni);
            tracker.setOnTrackerAllFinished(() -> {
                Game.getCurrentGame().getIdleStateCoordinator().markAsIdle(seqAni);
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(this.eventAttack);
            });
            seqAni.play();
        }
    }

    private void dispatchAttackDisable() {
        this.cardIndex.getIndexedInstance().getCardStateFlags().removeValue(32768);
        if (!Game.getCurrentGame().getGameRules().isTurnTerminated()) {
            if (GameConst.CardLocation.isSIGNI(this.cardIndex.getLocation())) {
                ((ZoneSIGNI)this.cardIndex.getZoneByLocation()).getZoneArrow().flash(Color.RED);
            } else if (GameConst.CardLocation.isLRIG(this.cardIndex.getLocation())) {
                ((ZoneLRIG)this.cardIndex.getZoneByLocation()).flashZoneMesh(Color.RED);
            }
        }
    }

    private void dispatchAttack() {
        if (GameConst.CardLocation.isSIGNI(this.cardIndex.getLocation())) {
            ActionAttackBattlePre actionBattle = new ActionAttackBattlePre(this.groupAtkTargets, this.eventAttack);
            actionBattle.setSourceCardIndex(this.cardIndex);
            Game.getCurrentGame().getActionQueue().addAction(actionBattle);
        } else if (GameConst.CardLocation.isLRIG(this.cardIndex.getLocation())) {
            ActionAttackLRIG actionAttackLRIG = new ActionAttackLRIG(this.eventAttack);
            actionAttackLRIG.setSourceCardIndex(this.cardIndex);
            Game.getCurrentGame().getActionQueue().addAction(actionAttackLRIG);
        }
    }
}

