/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionAttackBattle;
import open.batoru.core.gameplay.actions.ActionDamage;
import open.batoru.core.gameplay.rulechecks.SIGNIZoneRuleCheck;
import open.batoru.core.gameplay.rulechecks.card.RuleCheckCanAttackSIGNIZone;
import open.batoru.data.ability.events.EventAttack;
import open.batoru.data.ability.events.EventAttackBattle;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game.overlay.log.events.LogEventAttackSIGNI;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class ActionAttackBattlePre
extends GameAction<CardIndex> {
    private final RuleCheckCanAttackSIGNIZone.SIGNIZoneAttackPositionGroup groupAtkTargets;
    private final EventAttack eventAttack;
    private boolean shouldDoDamage;

    public ActionAttackBattlePre(RuleCheckCanAttackSIGNIZone.SIGNIZoneAttackPositionGroup groupAtkTargets, EventAttack eventAttack) {
        this.groupAtkTargets = groupAtkTargets;
        this.eventAttack = eventAttack;
    }

    @Override
    protected void dispatch() {
        GameConst.SIGNIZonePosition zonePositionOwn = GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(this.getSourceCardIndex().getLocation());
        if (zonePositionOwn == null || !this.getSourceCardIndex().isSIGNIOnField()) {
            this.setAsCompleted();
            return;
        }
        Game.GamePlayerRole rolePlayerOpponent = Game.GamePlayerRole.getOpponentRole(this.getSourceCardIndex().getIndexedInstance().getCurrentOwner());
        ArrayList cardsToBattle = new ArrayList();
        Arrays.stream(GameConst.SIGNIZonePosition.values()).filter(zonePosition -> this.groupAtkTargets.getState((GameConst.SIGNIZonePosition)((Object)zonePosition)) == SIGNIZoneRuleCheck.SIGNIZonePositionGroup.SIGNIZonePositionState.ALLOW).forEach(zonePosition -> {
            boolean isOppositeZone;
            ZoneSIGNI zoneSIGNIOP = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayerOpponent).getSIGNIZone((GameConst.SIGNIZonePosition)((Object)zonePosition));
            Card3D card3DOP = zoneSIGNIOP.getTopCard();
            boolean bl = isOppositeZone = zonePosition == GameConst.SIGNIZonePosition.getOppositeSIGNIPosition(zonePositionOwn);
            if (Card3D.isFaceUpOnField(card3DOP) && ((this.getSourceCardIndex().getIndexedInstance().getAttackModifierFlags().getValue() & 2) == 0 || !isOppositeZone)) {
                this.setLogEvent(new LogEventAttackSIGNI(this.getSourceCardIndex(), card3DOP.getCardIndex()));
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventAttackBattle(this.getSourceCardIndex(), card3DOP.getCardIndex()), new EventAttackBattle(card3DOP.getCardIndex(), this.getSourceCardIndex()));
                cardsToBattle.add(card3DOP.getCardIndex());
            } else if (isOppositeZone) {
                if (this.groupAtkTargets.getAttackState((GameConst.SIGNIZonePosition)((Object)zonePosition)) == RuleCheckCanAttackSIGNIZone.SIGNIZoneAttackPositionGroup.AttackZoneState.DEFAULT) {
                    this.shouldDoDamage = true;
                } else {
                    zoneSIGNIOP.flashZoneMesh(Color.RED);
                }
            }
        });
        Game.getCurrentGame().getGameRules().getEffectProcessor().setOnEffectProcessingFinished(() -> Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> {
            GameAction action;
            GameAction prevAction = null;
            if (!cardsToBattle.isEmpty()) {
                for (int i = 0; i < cardsToBattle.size(); ++i) {
                    action = new ActionAttackBattle(this.getSourceCardIndex(), (CardIndex)cardsToBattle.get(i));
                    action.setAtOnce(prevAction, i, cardsToBattle.size());
                    prevAction = action;
                    if (i != cardsToBattle.size() - 1) {
                        action.treatAsMidEffAction();
                    }
                    Game.getCurrentGame().getActionQueue().addAction(action);
                }
            }
            if (this.shouldDoDamage) {
                LogEventAttackSIGNI logEventAttackSIGNI = new LogEventAttackSIGNI(this.getSourceCardIndex());
                FX.run(() -> this.setLogEvent(logEventAttackSIGNI));
                action = new ActionDamage(rolePlayerOpponent);
                action.setSourceCardIndex(this.getSourceCardIndex());
                action.setOnActionCompleted(() -> this.lambda$dispatch$4((ActionDamage)action));
                action.setOnActionOverridden(() -> this.eventAttack.callOnAttackEnd(false));
                Game.getCurrentGame().getActionQueue().addAction(action);
            } else if (prevAction == null) {
                this.eventAttack.callOnAttackEnd(false);
            } else {
                prevAction.setOnActionCompleted(() -> Game.getCurrentGame().getIdleStateCoordinator().setOnNextIdle(() -> this.eventAttack.callOnAttackEnd(false)));
                prevAction.setOnActionOverridden(() -> this.eventAttack.callOnAttackEnd(false));
            }
        }));
        Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        this.setAsCompleted();
    }

    private /* synthetic */ void lambda$dispatch$4(ActionDamage action) {
        Game.getCurrentGame().getIdleStateCoordinator().setOnNextIdle(() -> this.eventAttack.callOnAttackEnd(action.isSuccessful()));
    }
}

