/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.List;
import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionAttack;
import open.batoru.core.gameplay.actions.ActionManualChoiceCost;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.EventAttack;
import open.batoru.data.ability.events.EventDown;
import open.batoru.game.FieldZone;
import open.batoru.game.animations.AnimationCardRotate;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionAttackPre
extends GameAction<CardIndex> {
    private CardIndex cardIndex;
    private List<AbilityCostList> dataCostListsAttack;
    private EventAttack eventAttack;

    public ActionAttackPre(CardIndex cardIndex, List<AbilityCostList> dataCostListsAttack) {
        this.cardIndex = cardIndex;
        this.dataCostListsAttack = dataCostListsAttack;
    }

    public ActionAttackPre(PacketParser pp) {
        this.setReceivedPacketData(pp);
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.setAsCompleted();
            }
            return;
        }
        if (this.dataCostListsAttack != null && !AbilityCostList.canPayDataCostLists(this.dataCostListsAttack)) {
            this.setAsCompleted();
            return;
        }
        this.eventAttack = new EventAttack(this.cardIndex);
        boolean wasDowned = this.cardIndex.getIndexedInstance().isState(16384);
        if (!wasDowned) {
            this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(16384);
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventDown(this.cardIndex, null, null, null));
        }
        if (!CardIndex.isOwnCard(this.cardIndex)) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.cardIndex);
        }
        if (!wasDowned) {
            AnimationTracker tracker = new AnimationTracker(1);
            tracker.setOnTrackerAllFinished(this::dispatchAttackCost);
            TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
            AnimationCardRotate aniDown = new AnimationCardRotate(this.cardIndex.getSourceCard3D(), false);
            aniDown.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniDown);
            seqAni.play();
        } else {
            ((FieldZone)this.cardIndex.getSourceCard3D().getOwnerZone()).flashZoneMesh(Color.GREEN);
            this.dispatchAttackCost();
        }
    }

    private void dispatchAttackCost() {
        if (this.dataCostListsAttack == null || this.dataCostListsAttack.isEmpty()) {
            Game.getCurrentGame().getActionQueue().addAction(new ActionAttack(this.cardIndex, this.eventAttack));
        } else {
            GameAction action = PlayerControl.isChoosingPlayer(this.cardIndex.getCurrentOwnerSafe()) ? new ActionManualChoiceCost(this.dataCostListsAttack) : new ActionPlayerChoiceInteger();
            action.setOnActionCompleted(() -> {
                if (ActionPayCost.isCostActionSuccessful(action)) {
                    AbilityCostList costListChosen = this.dataCostListsAttack.get((Integer)action.getDataTable().get());
                    costListChosen.setOnCostHandledAll(() -> {
                        if (costListChosen.isPaid()) {
                            Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> Game.getCurrentGame().getActionQueue().addAction(new ActionAttack(this.cardIndex, this.eventAttack)));
                            Game.getCurrentGame().getGameRules().getRuleProcessor().process();
                        }
                    });
                    Game.getCurrentGame().getActionQueue().addAction(new ActionPayCost(costListChosen));
                } else {
                    Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
                }
            });
            action.treatAsMidEffAction();
            Game.getCurrentGame().getActionQueue().addAction(action);
        }
        this.setAsCompleted();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> {
            this.cardIndex = card3D.getCardIndex();
        });
        this.dataCostListsAttack = ((AbilityCost)this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_ATTACK).check(this.cardIndex)).getSourceCostList().getSourceDataCostLists();
    }
}

