/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.List;
import javafx.animation.Animation;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.events.EventBanish;
import open.batoru.data.ability.events.EventEner;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationPowerChange;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.ui.UI;

public class ActionBanish
extends TransientCardGameAction {
    public ActionBanish(CardIndex cardIndex) {
        super(cardIndex);
    }

    @Override
    protected void dispatch() {
        if (this.getCardIndex() == null || !GameConst.CardLocation.isSIGNI(this.getCardIndex().getLocation()) || this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_BANISHED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, new Object[]{GameConst.CardLocation.ENER}) == RuleCheck.RuleCheckState.BLOCK || this.getSourceAbility() != null && this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.setAsCompleted();
            return;
        }
        if (this.getSourceCardIndex() != null || this.getCardIndex().getIndexedInstance().getPower().getValue() > 0.0 || ((ZoneSIGNI)this.getCardIndex().getZoneByLocation()).getZoneNumbers().getValue() == 0.0) {
            this.dispatchBanish();
        } else {
            AnimationPowerChange aniChange = ((ZoneSIGNI)this.getCardIndex().getZoneByLocation()).getZoneNumbers().getAnimation();
            if (aniChange != null && aniChange.getStatus() == Animation.Status.RUNNING) {
                aniChange.setOnAnimationFinished(this::dispatchBanish);
            } else {
                this.dispatchBanish();
            }
        }
    }

    private void dispatchBanish() {
        GameEvent[] listEvents;
        int miscEventsStartId = 1;
        if (!this.isNonOverridableAction() || this.getSourceOverrideResult() != null) {
            listEvents = new GameEvent[3];
            listEvents[0] = new EventBanish(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost());
        } else {
            listEvents = new GameEvent[2];
            miscEventsStartId = 0;
        }
        listEvents[miscEventsStartId] = new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.ENER);
        listEvents[miscEventsStartId + 1] = new EventEner(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility());
        this.setLogEvent(new LogEventMove((EventMove)listEvents[miscEventsStartId], TargetFilter.TargetHint.BANISH), this.getSourceCardIndex() == null);
        for (GameEvent event : listEvents) {
            event.setAtOnce(this);
        }
        if (this.applyActiveOverrideActions(this.getCardIndex().getCurrentOwnerSafe(), listEvents)) {
            return;
        }
        if (!this.isNonOverridableAction() || this.getSourceOverrideResult() != null) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(listEvents[0]);
        }
        if (ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this)) {
            return;
        }
        this.getCardIndex().getIndexedInstance().getCardStateFlags().addValue(256);
        this.addCardIndexData();
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(listEvents[miscEventsStartId], listEvents[miscEventsStartId + 1]);
        if (this.isLastAtOnce()) {
            this.setOnActionCompleted(() -> Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects()));
        }
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(CardIndex.getOriginalOwner(this.getCardIndex().getId())).getEnerZone());
        aniMove.setAnimationTracker(tracker);
        seqAni.getAnimationList().add(aniMove);
        seqAni.play();
    }

    @Override
    public boolean applyActiveOverrideActions(Game.GamePlayerRole roleOwner, GameEvent ... listEvents) {
        if (super.applyActiveOverrideActions(roleOwner, listEvents)) {
            List<OverrideAction> overrideActions = this.getSourceOverrideResult().getOverrideActions();
            if (overrideActions.stream().anyMatch(overrideAction -> (overrideAction.getActionEvent() == GameConst.GameEventId.BANISH || overrideAction.getActionEvent() == GameConst.GameEventId.MOVE && !GameConst.CardLocation.isSIGNI(((EventMove)overrideAction.getSourceEvent()).getMoveLocation())) && (overrideAction.getOverrideFlags() & 4) != 0)) {
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(listEvents[0]);
            }
            return true;
        }
        return false;
    }
}

