/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.Collections;
import javafx.scene.Node;
import open.batoru.UtilRandom;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.GizmoCraft;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.AnimationCardShatterFragment;
import open.batoru.game.animations.AnimationGizmoCraft;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.ui.UI;

public class ActionCraft
extends GameAction<CardIndex> {
    private final Game.GamePlayerRole rolePlayer;
    private final String imageSet;

    public ActionCraft(Game.GamePlayerRole rolePlayer, String imageSet) {
        this.rolePlayer = rolePlayer;
        this.imageSet = imageSet;
    }

    @Override
    protected void dispatch() {
        CardIndex cardIndex = Game.getCurrentGame().getIndexRegistry().createFreeIndex(this.rolePlayer, GameConst.CardLocation.REVEALED);
        cardIndex.setImageSet(cardIndex.getId(), this.imageSet);
        this.getDataTable().add(cardIndex);
        Card3D card3D = new Card3D(Deck.DeckType.LRIG);
        card3D.setCardIndex(cardIndex);
        if (!cardIndex.getIndexedInstance().isState(8)) {
            cardIndex.getIndexedInstance().getCardStateFlags().setBaseValue(8);
        }
        UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(cardIndex);
        boolean isVertical = !CardConst.CardType.isCardInHorizontalOrientation(cardIndex.getCardReference().getType()) && CardLoader.getImageSetMaskType(cardIndex.getImageSet()) != CardDataImageSet.MaskType.VERTICAL;
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer);
        card3D.setTranslate(field.getRevealZone().getNextCardOrigin());
        if (!isVertical) {
            card3D.setRotateZ(90.0);
        }
        field.getChildren().add((Object)card3D);
        card3D.setOwnerZone(field.getRevealZone());
        GizmoCraft gizmoCraft = new GizmoCraft(isVertical);
        gizmoCraft.setTranslate(field.getRevealZone().getNode());
        if (field.getRevealZone().isFlipped()) {
            gizmoCraft.setRotateZ(180.0);
        }
        field.getChildren().add((Object)gizmoCraft);
        this.playAssembleAnimation(gizmoCraft, card3D);
    }

    private void playAssembleAnimation(GizmoCraft gizmoCraft, Card3D card3D) {
        card3D.shatter();
        ArrayList listFragments = new ArrayList(card3D.getShatter().getChildren());
        Collections.shuffle(listFragments);
        AnimationTracker tracker = new AnimationTracker(card3D.getShatter().getChildren().size() + 1);
        tracker.setOnTrackerAllFinished(() -> {
            card3D.removeShatter();
            UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().remove((Object)gizmoCraft);
            this.setAsCompleted();
        });
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, listFragments.size() + 1);
        AnimationCardShatterFragment aniAssemble = null;
        for (int i = 0; i < listFragments.size(); ++i) {
            Node node = (Node)listFragments.get(i);
            aniAssemble = new AnimationCardShatterFragment((Group3D)node, false, true);
            if (i > 0) {
                aniAssemble.setDelay(i * 25 + UtilRandom.get(-25, 25));
            }
            aniAssemble.setAnimationTracker(tracker);
            seqAni.getAnimationList(i + 1).add(aniAssemble);
        }
        AnimationGizmoCraft aniCraft = new AnimationGizmoCraft(gizmoCraft, aniAssemble.getDelay().toMillis() + aniAssemble.getCycleDuration().toMillis() + 300.0);
        aniCraft.setAnimationTracker(tracker);
        seqAni.getAnimationList(0).add(aniCraft);
        seqAni.play();
    }
}

