/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.List;
import java.util.Optional;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.LifeBurstAbility;
import open.batoru.data.ability.events.EventCrush;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.ZoneLifeCloth;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.log.OverlayGameLogLifeClothTracker;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionCrush
extends GameAction<CardIndex> {
    private final Game.GamePlayerRole rolePlayer;
    private final AbilityConst.LifeBurst lifeBurst;
    private EventCrush eventCrush;
    private CardIndex cardIndex;

    public ActionCrush(Game.GamePlayerRole rolePlayer, AbilityConst.LifeBurst lifeBurst) {
        this.rolePlayer = rolePlayer;
        this.lifeBurst = lifeBurst;
    }

    @Override
    protected void dispatch() {
        ZoneLifeCloth zoneLifeCloth = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getLifeClothZone();
        if (zoneLifeCloth.getTotalCards() == 0) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        this.cardIndex = zoneLifeCloth.getTopCard().getCardIndex();
        if (!this.isDataReceived()) {
            if (!this.isNonOverridableAction() || this.getSourceOverrideResult() != null) {
                this.eventCrush = new EventCrush(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost());
                this.eventCrush.setAtOnce(this);
                if (this.applyActiveOverrideActions(this.rolePlayer, this.eventCrush)) {
                    return;
                }
            }
            this.requestData();
            return;
        }
        if (this.eventCrush != null && this.eventCrush.getCaller() == null) {
            this.eventCrush = new EventCrush(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost());
            this.eventCrush.setAtOnce(this);
        }
        EventMove eventMove = new EventMove(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.CHECK_ZONE);
        eventMove.setAtOnce(this);
        this.setLogEvent(new LogEventMove(eventMove, AbilityConst.ActionHint.CRUSH));
        OverlayGameLogLifeClothTracker.LifeClothTrackerBox lifeClothTrackerBox = UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.rolePlayer).moveNext(this.cardIndex.getImageSet(), true, this.getLogEvent());
        this.getDataTable().add(this.cardIndex);
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(() -> {
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
            if (this.lifeBurst == AbilityConst.LifeBurst.ACTIVATE) {
                Optional<LifeBurstAbility> abilityLB = this.cardIndex.getIndexedInstance().findLifeBurstAbility();
                if (abilityLB.isPresent()) {
                    this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(64);
                    abilityLB.get().setSourceLifeClothTrackerBox(lifeClothTrackerBox);
                } else {
                    this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(256);
                }
            } else {
                lifeClothTrackerBox.disableLBIcon();
                this.cardIndex.getIndexedInstance().getAbilityList().stream().filter(ability -> ability instanceof LifeBurstAbility && !ability.isMuted()).forEach(Ability::mute);
                this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(256);
            }
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventMove);
            if (this.eventCrush != null) {
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(this.eventCrush);
            }
            if (this.isLastAtOnce() && !this.isMidEffAction()) {
                if (this.eventCrush != null) {
                    Game.getCurrentGame().getGameRules().getEffectProcessor().setOnEffectProcessingFinished(() -> {
                        if (this.eventCrush.hasPostAttackTriggers()) {
                            Game.getCurrentGame().getIdleStateCoordinator().setOnNextIdle(() -> {
                                this.eventCrush.callPostAttackTriggers(true);
                                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
                            });
                        }
                    });
                }
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            }
            this.setAsCompleted();
        });
        AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getCheckZone());
        aniMove.setAnimationTracker(tracker);
        aniMove.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.assignCardFromShortPacketData(pp.getDataArgument(1), this.cardIndex.getSourceCard3D());
    }

    @Override
    public boolean applyActiveOverrideActions(Game.GamePlayerRole roleOwner, GameEvent ... listEvents) {
        if (super.applyActiveOverrideActions(roleOwner, listEvents)) {
            List<OverrideAction> overrideActions = this.getSourceOverrideResult().getOverrideActions();
            if (overrideActions.stream().anyMatch(overrideAction -> overrideAction.getActionEvent() == GameConst.GameEventId.CRUSH && (overrideAction.getOverrideFlags() & 4) != 0)) {
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(this.eventCrush);
            }
            return true;
        }
        return false;
    }
}

