/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionCrush;
import open.batoru.core.gameplay.actions.ActionGameEnd;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventDamage;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game.overlay.log.events.LogEventDamage;
import open.batoru.ui.UI;

public class ActionDamage
extends GameAction<Boolean> {
    private final Game.GamePlayerRole rolePlayer;
    private boolean isNotLastDamageInstance;

    public ActionDamage(Game.GamePlayerRole rolePlayer) {
        this.rolePlayer = rolePlayer;
    }

    public void setIsNotLastDamageInstance() {
        this.isNotLastDamageInstance = true;
    }

    @Override
    protected void dispatch() {
        if (this.isNotLastDamageInstance) {
            this.treatAsMidEffAction();
        }
        EventDamage eventDamage = new EventDamage(this.rolePlayer, this.getSourceCardIndex(), this.getSourceAbility());
        this.setLogEvent(new LogEventDamage(eventDamage));
        if (this.getSourceCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_DEAL_DAMAGE).check(this.getSourceCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.getLogEvent().disable();
            if (GameConst.CardLocation.isSIGNI(this.getSourceCardIndex().getLocation())) {
                ((ZoneSIGNI)this.getSourceCardIndex().getZoneByLocation()).getZoneArrow().flash(Color.RED);
            }
            this.setAsCompleted();
            return;
        }
        if (Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.rolePlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_BE_DAMAGED).check(this.rolePlayer, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.getLogEvent().disable();
            UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getLifeClothZone().flashZoneMesh(Color.GREEN);
            this.setAsCompleted();
            return;
        }
        if (this.applyActiveOverrideActions(this.rolePlayer, eventDamage)) {
            return;
        }
        this.getDataTable().add(true);
        int numLC = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getLifeClothZone().getTotalCards();
        if (numLC > 0) {
            int numToCrush = 1;
            if (this.getSourceAbility() == null) {
                if (this.getSourceCardIndex().getIndexedInstance().hasAttackModifier(8)) {
                    numToCrush = 3;
                } else if (this.getSourceCardIndex().getIndexedInstance().hasAttackModifier(4)) {
                    numToCrush = 2;
                }
                if (numToCrush > numLC) {
                    numToCrush = numLC;
                }
            }
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventDamage);
            ActionCrush prevAction = null;
            for (int i = 0; i < numToCrush; ++i) {
                ActionCrush actionCrush = new ActionCrush(this.rolePlayer, AbilityConst.LifeBurst.ACTIVATE);
                if (this.getSourceAbility() == null) {
                    actionCrush.setSourceCardIndex(this.getSourceCardIndex());
                } else {
                    actionCrush.setSourceAbility(this.getSourceAbility());
                }
                actionCrush.setAtOnce(prevAction, i, numToCrush);
                prevAction = actionCrush;
                if (i != numToCrush - 1 || this.isNotLastDamageInstance) {
                    actionCrush.treatAsMidEffAction();
                }
                Game.getCurrentGame().getActionQueue().addAction(actionCrush);
            }
        } else {
            Game.getCurrentGame().getActionQueue().addAction(new ActionGameEnd(Game.GamePlayerRole.getOpponentRole(this.rolePlayer)));
        }
        this.setAsCompleted();
    }
}

