/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.events.EventActivateAction;
import open.batoru.networking.PacketParser;

public class ActionEffectActivateAction
extends GameAction<Void> {
    private CardIndex cardIndex;
    private int abilityIdAction;

    public ActionEffectActivateAction(CardIndex cardIndex, int abilityIdAction) {
        this.cardIndex = cardIndex;
        this.abilityIdAction = abilityIdAction;
    }

    public ActionEffectActivateAction(PacketParser pp) {
        this.setReceivedPacketData(pp);
    }

    @Override
    protected void dispatch() {
        if (!(this.isDataReceived() || this.cardIndex != null && this.cardIndex.getIndexedInstance() != null)) {
            this.requestData();
            return;
        }
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(new EventActivateAction(this.cardIndex, this.abilityIdAction));
        this.setAsCompleted();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> {
            this.cardIndex = card3D.getCardIndex();
        });
        if (pp.getDataArgsNum() > 2) {
            this.abilityIdAction = Integer.parseInt(pp.getDataArgument(2));
        }
    }
}

