/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionManualChoice;
import open.batoru.core.gameplay.actions.ActionManualChoiceCost;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.callback.CostCallbackThread;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.EnterAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.animations.AnimationFlashEffect;
import open.batoru.game.animations.AnimationFlashEffectNegate;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.ui.UI;

public class ActionEffectActivatePayCost
extends ActionPayCost {
    private final GameEvent event;
    private final EffectBucket sourceBucket;

    public ActionEffectActivatePayCost(Ability ability, GameEvent event) {
        super(null);
        this.setSourceAbility(ability);
        this.event = event;
        this.sourceBucket = Game.getCurrentGame().getGameRules().getEffectProcessor().getSourceBucket(ability);
    }

    @Override
    protected void dispatch() {
        if (Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.sourceBucket.getOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_USE_ABILITY).check(this.sourceBucket.getOwner(), this.getSourceAbility().getSourceCardIndex(), this.getSourceAbility(), new Object[0]) == RuleCheck.RuleCheckState.OK) {
            boolean canPayCost;
            Ability ability = this.getSourceAbility();
            if (ability instanceof CheckZoneAbility) {
                CheckZoneAbility checkZoneAbility = (CheckZoneAbility)ability;
                v0 = checkZoneAbility.canPayCost();
            } else {
                v0 = canPayCost = AbilityCostList.canPayDataCostLists(this.getSourceAbility().getCostLists());
            }
            if (canPayCost) {
                if (EffectBucket.isAbilityMandatory(this.getSourceAbility())) {
                    this.dispatchChoiceCost();
                } else {
                    this.dispatchChoiceActivate();
                }
            } else {
                Log.printMessage("!pre cost: can't be paid");
                this.abortAction();
            }
            this.setAsCompleted();
        } else {
            AnimationTracker tracker = new AnimationTracker(1);
            tracker.setOnTrackerAllFinished(() -> {
                this.abortAction();
                this.setAsCompleted();
            });
            AnimationFlashEffectNegate aniFlash = new AnimationFlashEffectNegate(this.getSourceAbility());
            aniFlash.setAnimationTracker(tracker);
            aniFlash.play();
        }
    }

    private void abortAction() {
        UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().removeEffect(this.getSourceAbility());
        Game.getCurrentGame().getGameRules().getEffectProcessor().setEffectAsCompleted(this.sourceBucket);
    }

    private void dispatchChoiceActivate() {
        GameAction action;
        AnimationBorderIcon aniBorder = new AnimationBorderIcon(this.getSourceAbility().getSourceCardIndex().getZoneByLocation(), TargetFilter.TargetHint.ACTIVATE);
        aniBorder.play();
        if (PlayerControl.isChoosingPlayer(this.sourceBucket.getOwner())) {
            action = new ActionManualChoice(this.getSourceAbility());
            if (!AbilityCostList.canPayDataCostListsPrivately(this.getSourceAbility().getCostLists())) {
                ((ActionManualChoice)action).setLocked(true);
            }
        } else {
            action = new ActionPlayerChoiceInteger();
        }
        action.setOnActionCompleted(() -> {
            aniBorder.stop();
            if ((Integer)action.getDataTable().get() == 1) {
                UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().confirmNonMandatoryEffect(this.getSourceAbility());
                this.dispatchChoiceCost();
            } else {
                this.abortAction();
            }
        });
        action.treatAsMidEffAction();
        Game.getCurrentGame().getActionQueue().addAction(action);
    }

    private void dispatchChoiceCost() {
        if (this.getSourceAbility().getCostLists().size() < 2 || this.getSourceAbility().getCostLists().getFirst().getDataArray().isEmpty()) {
            if (!this.getSourceAbility().getCostLists().isEmpty()) {
                this.dispatchPreAnimation(this.getSourceAbility().getCostLists().getFirst());
            } else {
                this.dispatchPreparePay(null);
            }
        } else {
            GameAction action = PlayerControl.isChoosingPlayer(this.sourceBucket.getOwner()) ? new ActionManualChoiceCost(this.getSourceAbility().getCostLists(), true).forceDisableSkip(true) : new ActionPlayerChoiceInteger();
            action.setOnActionCompleted(() -> {
                if (ActionPayCost.isCostActionSuccessful(action)) {
                    this.dispatchPreAnimation(this.getSourceAbility().getCostLists().get((Integer)action.getDataTable().get()));
                } else {
                    this.dispatchPreparePay(null);
                }
            });
            action.treatAsMidEffAction();
            Game.getCurrentGame().getActionQueue().addAction(action);
        }
    }

    private void dispatchPreAnimation(AbilityCostList costList) {
        if ((this.getSourceAbility() instanceof ActionAbility || this.getSourceAbility() instanceof EnterAbility || this.getSourceAbility() instanceof CheckZoneAbility) && costList.isVisuallySignificant()) {
            AnimationFlashEffect aniFlash = new AnimationFlashEffect(this.getSourceAbility());
            aniFlash.setOnAnimationFinished(() -> this.dispatchPreparePay(costList));
            aniFlash.play();
        } else {
            this.dispatchPreparePay(costList);
        }
    }

    private void dispatchPreparePay(AbilityCostList costList) {
        AbilityCost.setCallbackAction(this);
        this.startCallbackThread(new CostCallbackThread(this, costList, this.event));
    }
}

