/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.CostRuleCheck;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.LifeBurstAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.EventActivateLifeBurst;
import open.batoru.game.GameField;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.log.OverlayGameLogLifeClothTracker;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionEffectDecideLifeBurst
extends GameAction<Integer> {
    private final Game.GamePlayerRole rolePlayer;
    private final List<CardIndex> listCards;
    private AnimationBorderIcon aniBorder;
    private List<AbilityCostList> costLists;

    public ActionEffectDecideLifeBurst(Game.GamePlayerRole rolePlayer, List<CardIndex> listCards) {
        this.rolePlayer = rolePlayer;
        this.listCards = listCards;
    }

    @Override
    protected void dispatch() {
        if (!this.isChildAction()) {
            if (this.aniBorder == null) {
                GameField.highlightPlayerField(this.rolePlayer);
                this.aniBorder = new AnimationBorderIcon(UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getCheckZone(), TargetFilter.TargetHint.ACTIVATE);
                this.aniBorder.play();
            }
            if (!this.isDataReceived()) {
                this.requestData();
                return;
            }
        }
        int currentData = 0;
        for (CardIndex cardIndex : this.listCards) {
            cardIndex.getIndexedInstance().getCardStateFlags().removeValue(64);
            List<LifeBurstAbility> abilitiesLB = cardIndex.getIndexedInstance().getAbilityList().stream().filter(ability -> ability instanceof LifeBurstAbility).map(LifeBurstAbility.class::cast).toList();
            OverlayGameLogLifeClothTracker.LifeClothTrackerBox sourceLifeClothTrackerBox = !abilitiesLB.isEmpty() ? abilitiesLB.getFirst().getSourceLifeClothTrackerBox() : null;
            ArrayList<LifeBurstAbility> listSelected = new ArrayList<LifeBurstAbility>();
            for (LifeBurstAbility ability2 : abilitiesLB) {
                if ((Integer)this.getDataTable().get(currentData) != 0) {
                    listSelected.add(ability2);
                }
                ++currentData;
            }
            if (listSelected.isEmpty()) {
                this.declineLifeBurstUsage(cardIndex, sourceLifeClothTrackerBox);
                continue;
            }
            CostRuleCheck costRuleCheckUseLB = (CostRuleCheck)cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.COST_TO_USE_LB);
            List<AbilityCostList> dataCostListsUseLB = ((AbilityCost)costRuleCheckUseLB.check(cardIndex)).getSourceCostList().getSourceDataCostLists();
            if (!dataCostListsUseLB.isEmpty()) {
                AbilityCostList costList = dataCostListsUseLB.getFirst();
                costList.setOnCostHandledAll(() -> {
                    if (!costList.isPaid()) {
                        this.declineLifeBurstUsage(cardIndex, sourceLifeClothTrackerBox);
                    } else {
                        this.activateSelectedLifeBurst(listSelected);
                    }
                    Game.getCurrentGame().getGameRules().getRuleProcessor().markCostAsHandled(costList.isPaid());
                });
                if (this.costLists == null) {
                    this.costLists = new ArrayList<AbilityCostList>();
                }
                this.costLists.add(costList);
                continue;
            }
            Game.GamePlayerRole rolePlayerOP = Game.GamePlayerRole.getOpponentRole(this.rolePlayer);
            CostRuleCheck costRuleCheckDisableLB = (CostRuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayerOP).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.COST_TO_DISABLE_LB);
            AbilityCostList wrappedCostListsDisableLB = costRuleCheckDisableLB.check(new PlayerRuleCheckData(rolePlayerOP, null, null, cardIndex)).getSourceCostList();
            wrappedCostListsDisableLB.setPayerRole(rolePlayerOP);
            List<AbilityCostList> dataCostListsDisableLB = wrappedCostListsDisableLB.getSourceDataCostLists();
            if (!dataCostListsDisableLB.isEmpty()) {
                AbilityCostList costList = dataCostListsDisableLB.getFirst();
                costList.setOnCostHandledAll(() -> {
                    if (costList.isPaid()) {
                        this.declineLifeBurstUsage(cardIndex, sourceLifeClothTrackerBox);
                    } else {
                        this.activateSelectedLifeBurst(listSelected);
                    }
                    Game.getCurrentGame().getGameRules().getRuleProcessor().markCostAsHandled(!costList.isPaid());
                });
                if (this.costLists == null) {
                    this.costLists = new ArrayList<AbilityCostList>();
                }
                this.costLists.add(costList);
                continue;
            }
            this.activateSelectedLifeBurst(listSelected);
        }
        if (this.costLists != null) {
            for (AbilityCostList costList : this.costLists) {
                Game.getCurrentGame().getGameRules().getRuleProcessor().addCostList(costList);
            }
        }
        if (this.aniBorder != null) {
            this.aniBorder.stop();
        }
        GameField.highlightPlayerField(null);
        this.setAsCompleted();
    }

    private void declineLifeBurstUsage(CardIndex cardIndex, OverlayGameLogLifeClothTracker.LifeClothTrackerBox sourceLifeClothTrackerBox) {
        cardIndex.getIndexedInstance().getCardStateFlags().addValue(256);
        if (sourceLifeClothTrackerBox != null) {
            sourceLifeClothTrackerBox.disableLBIcon();
        }
    }

    private void activateSelectedLifeBurst(List<LifeBurstAbility> listSelected) {
        for (LifeBurstAbility ability : listSelected) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(new EventActivateLifeBurst(ability));
        }
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        for (int i = 1; i < pp.getDataArgsNum(); ++i) {
            this.getDataTable().add(Integer.parseInt(pp.getDataArgument(i)));
        }
    }
}

