/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEffectWaitReorder;
import open.batoru.game.GameField;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowEffectReorder;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;

public class ActionEffectManualWaitReorder
extends GameAction<Integer> {
    private final EffectBucket sourceBucket;

    public ActionEffectManualWaitReorder(EffectBucket sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    @Override
    protected void dispatch() {
        this.treatAsMidEffAction();
        GameField.highlightPlayerField(this.sourceBucket.getOwner());
        OverlayWindowEffectReorder window = new OverlayWindowEffectReorder();
        window.getConfirmButton().setOnAction(e -> {
            int intShouldReorderAtOnce;
            window.lockControls(true);
            StringBuilder packetData = new StringBuilder();
            List<Integer> orderDiffData = window.getAbilityOrderDiffData();
            for (Integer diff : orderDiffData) {
                this.getDataTable().add(diff);
                packetData.append(diff).append("|");
            }
            int n = intShouldReorderAtOnce = Game.getCurrentGame().getPlayerGameData(Game.getCurrentGame().getPlayerRole()).shouldReorderEffectsAtOnce() ? 1 : 0;
            if (Game.getCurrentGame().getFakeReceiver() == null) {
                this.getDataTable().add(intShouldReorderAtOnce);
            }
            packetData.append(intShouldReorderAtOnce);
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELA", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofSimpleGameAction(this.getOrderId()), pp -> {
                    OverlayWindow.removeFromFieldOverlay(window);
                    ActionEffectWaitReorder actionReorder = new ActionEffectWaitReorder(this.sourceBucket);
                    actionReorder.dispatchAsChild(this);
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }
}

