/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.HashMap;
import open.batoru.core.Game;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.GameField;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionEffectWaitReorder
extends GameAction<Integer> {
    private final EffectBucket sourceBucket;

    public ActionEffectWaitReorder(EffectBucket sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    @Override
    protected void dispatch() {
        int i;
        this.treatAsMidEffAction();
        GameField.highlightPlayerField(this.sourceBucket.getOwner());
        if (!this.isDataReceived() && this.getDataTable().size() < 2) {
            this.requestData();
            return;
        }
        if (this.getDataTable().size() < 2) {
            this.setAsCompleted();
            return;
        }
        int numCompleted = this.sourceBucket.getCompletedEffectsNum();
        HashMap<Integer, Ability> mapOrderedAbilities = new HashMap<Integer, Ability>();
        HashMap<Integer, GameEvent> mapOrderedEvents = new HashMap<Integer, GameEvent>();
        for (i = 0; i < this.getDataTable().size() - 1; ++i) {
            int oldIndex = numCompleted + i;
            int newIndex = oldIndex + (Integer)this.getDataTable().get(i);
            mapOrderedAbilities.put(newIndex - numCompleted, this.sourceBucket.getAbilityList().get(oldIndex));
            mapOrderedEvents.put(newIndex - numCompleted, this.sourceBucket.getEventList().get(oldIndex));
        }
        if (!this.isChildAction()) {
            boolean shouldReorderAtOnce = (Integer)this.getDataTable().get(this.getDataTable().size() - 1) == 1;
            Game.getCurrentGame().getPlayerGameData(this.sourceBucket.getOwner()).setShouldReorderEffectsAtOnce(shouldReorderAtOnce);
        }
        GameField.highlightPlayerField(null);
        UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().reorderEffects(this.sourceBucket, this.getDataTable());
        for (i = 0; i < this.getDataTable().size() - 1; ++i) {
            this.sourceBucket.getAbilityList().set(numCompleted + i, (Ability)mapOrderedAbilities.get(i));
            this.sourceBucket.getEventList().set(numCompleted + i, (GameEvent)mapOrderedEvents.get(i));
        }
        this.setAsCompleted();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        for (int i = 1; i < pp.getDataArgsNum(); ++i) {
            this.getDataTable().add(Integer.parseInt(pp.getDataArgument(i)));
        }
    }
}

