/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventExceed;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionExceed
extends GameAction<CardIndex> {
    private Card3D[] listCards;

    public ActionExceed(CardIndex[] listCardIndexes) {
        this.listCards = new Card3D[listCardIndexes.length];
        for (int i = 0; i < listCardIndexes.length; ++i) {
            this.listCards[i] = listCardIndexes[i].getSourceCard3D();
        }
    }

    public ActionExceed() {
    }

    @Override
    protected void dispatch() {
        if (this.listCards == null || this.listCards[0] == null) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.getDataTable().add(null);
                this.setAsCompleted();
            }
            return;
        }
        AnimationTracker tracker = new AnimationTracker(this.listCards.length);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        for (Card3D card3D : this.listCards) {
            this.getDataTable().add(card3D.getCardIndex());
            if (this.getSourceCost() != null) {
                this.getSourceCost().addPaidCardIndexData(card3D.getCardIndex());
            }
            AnimationCardMove aniMove = new AnimationCardMove(card3D, UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Card3D.getCurrentOwner(card3D)).getTrashZone(Deck.DeckType.LRIG));
            aniMove.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniMove);
        }
        if (this.getDataTable().get() != null) {
            for (int i = 0; i < this.getDataTable().size(); ++i) {
                EventExceed eventExceed = new EventExceed((CardIndex)this.getDataTable().get(i), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost());
                eventExceed.setAtOnce(i, this.getDataTable().size());
                EventMove eventMove = new EventMove((CardIndex)this.getDataTable().get(i), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.TRASH_LRIG);
                eventMove.setAtOnce(i, this.getDataTable().size());
                this.setLogEvent(new LogEventMove(eventMove, AbilityConst.ActionHint.EXCEED));
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventExceed, eventMove);
            }
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        } else {
            this.getDataTable().add(null);
        }
        seqAni.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (pp.getDataArgument(1).equals(String.valueOf(0))) {
            return;
        }
        this.listCards = new Card3D[pp.getDataArgsNum() - 1];
        for (int i = 1; i < pp.getDataArgsNum(); ++i) {
            this.listCards[i - 1] = CardIndex.getCardFromPacketData(pp.getDataArgument(i)).get();
        }
    }
}

