/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.Collections;
import javafx.scene.Node;
import open.batoru.UtilRandom;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationCardShatterFragment;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionExclude
extends TransientCardGameAction {
    public ActionExclude(CardIndex cardIndex) {
        super(cardIndex);
    }

    @Override
    protected void dispatch() {
        if (!this.isDataReceived() && (this.getCardIndex() == null || this.getCardIndex().getIndexedInstance() == null && this.getCardIndex().getLocation() != GameConst.CardLocation.LOOKED && this.getCardIndex().getLocation() != GameConst.CardLocation.DECK_LRIG)) {
            this.requestData();
            return;
        }
        if (this.getCardIndex() == null || this.getCardIndex().getLocation() == GameConst.CardLocation.EXCLUDED || this.getSourceAbility() != null && this.getCardIndex().getIndexedInstance() != null && (this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, new Object[]{GameConst.CardLocation.EXCLUDED}) == RuleCheck.RuleCheckState.BLOCK)) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        EventMove eventMove = new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.EXCLUDED);
        eventMove.setAtOnce(this);
        this.setLogEvent(new LogEventMove(eventMove, TargetFilter.TargetHint.EXCLUDE), this.getSourceCardIndex() == null);
        if (this.applyActiveOverrideActions(this.getCardIndex().getCurrentOwnerSafe(), eventMove) || ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this)) {
            return;
        }
        this.addCardIndexData();
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventMove);
        if (this.isLastAtOnce()) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        }
        if (this.getCardIndex().getLocation() != GameConst.CardLocation.REVEALED && this.getCardIndex().getLocation() != GameConst.CardLocation.CHECK_ZONE && this.getCardIndex().getLocation() != GameConst.CardLocation.LOOKED && this.getCardIndex().getLocation() != GameConst.CardLocation.DECK_LRIG) {
            AnimationTracker trackerMove = new AnimationTracker(1);
            trackerMove.setOnTrackerAllFinished(() -> this.playDisassembleAnimation(this.getCardIndex().getSourceCard3D()));
            AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getCurrentOwnerSafe()).getRevealZone());
            aniMove.setAnimationTracker(trackerMove);
            aniMove.play();
        } else {
            if (this.getCardIndex().getIndexedInstance() != null) {
                this.getCardIndex().getIndexedInstance().resetStats();
            }
            this.playDisassembleAnimation(this.getCardIndex().getSourceCard3D());
        }
    }

    private void playDisassembleAnimation(Card3D card3D) {
        card3D.shatter();
        ArrayList listFragments = new ArrayList(card3D.getShatter().getChildren());
        Collections.shuffle(listFragments);
        AnimationTracker tracker = new AnimationTracker(card3D.getShatter().getChildren().size());
        tracker.setOnTrackerAllFinished(() -> {
            this.getCardIndex().getZoneByLocation().removeCardFromZoneList(card3D);
            card3D.setVisible(false);
            card3D.setManaged(false);
            if (this.getCardIndex().getIndexedInstance() != null) {
                this.getCardIndex().getIndexedInstance().getAbilityList().forEach(ability -> {
                    ability.disable();
                    ability.getFlags().removeValue(32768);
                });
                CardConst.CardType cardType = this.getCardIndex().getCardReference().getType();
                if (!this.getCardIndex().getIndexedInstance().isState(8) || cardType == CardConst.CardType.RESONA || cardType == CardConst.CardType.SPELL || cardType == CardConst.CardType.ARTS || cardType == CardConst.CardType.PIECE) {
                    UI.getTabGame().getFieldSceneOverlay().getGameLog().getExcludedCardsTracker().addExcludedCard(this.getCardIndex(), this.getLogEvent());
                }
            }
            this.getCardIndex().setLocation(GameConst.CardLocation.EXCLUDED);
            this.setAsCompleted();
        });
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, listFragments.size());
        for (int i = 0; i < listFragments.size(); ++i) {
            Node node = (Node)listFragments.get(i);
            AnimationCardShatterFragment aniDisassemble = new AnimationCardShatterFragment((Group3D)node, true, card3D.getRotateY() != 180.0);
            if (i > 0) {
                aniDisassemble.setDelay(i * 25 + UtilRandom.get(-25, 25));
            }
            aniDisassemble.setAnimationTracker(tracker);
            seqAni.getAnimationList(i).add(aniDisassemble);
        }
        seqAni.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> this.setCardIndex(card3D.getCardIndex()));
    }
}

