/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardGameAction;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.game.FieldStackZone;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.AnimationCardFlip;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.log.events.LogEventFlip;
import open.batoru.networking.PacketParser;
import open.batoru.ui.FX;

public class ActionFlip
extends CardGameAction {
    private CardIndex cardIndex;
    private final CardConst.CardFace cardFace;
    private boolean allowOccupied;

    public ActionFlip(CardIndex cardIndex, CardConst.CardFace cardFace) {
        this(cardIndex, cardFace, false);
    }

    public ActionFlip(CardIndex cardIndex, CardConst.CardFace cardFace, boolean allowOccupied) {
        this.cardIndex = cardIndex;
        this.cardFace = cardFace;
        this.allowOccupied = allowOccupied;
    }

    public ActionFlip(CardConst.CardFace cardFace) {
        this.cardFace = cardFace;
    }

    public void setCardIndex(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || !GameConst.CardLocation.isSIGNI(this.cardIndex.getLocation()) && !GameConst.CardLocation.isLRIG(this.cardIndex.getLocation()) || this.getSourceAbility() != null && this.cardIndex.getIndexedInstance() != null && this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.cardIndex, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.setAsCompleted();
            return;
        }
        FieldStackZone zone = (FieldStackZone)this.cardIndex.getZoneByLocation();
        if (!(this.cardIndex == zone.getTopCard().getCardIndex() || this.allowOccupied && zone.getTopCard().getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE)) {
            this.setAsCompleted();
            return;
        }
        Card3D card3D = this.cardIndex.getSourceCard3D();
        if (this.cardFace == CardConst.CardFace.BACK && !Card3D.isFaceUpOnField(card3D) || this.cardFace == CardConst.CardFace.FRONT && Card3D.isFaceUpOnField(card3D)) {
            this.setAsCompleted();
            return;
        }
        if (this.cardIndex.getIndexedInstance() == null && this.cardFace == CardConst.CardFace.FRONT) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.setAsCompleted();
            }
            return;
        }
        this.addCardIndexData(this.cardIndex);
        this.setLogEvent(new LogEventFlip(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.cardFace));
        AnimationCardFlip aniFlip = new AnimationCardFlip(card3D);
        if (this.cardIndex.getIndexedInstance() != null && this.cardFace == CardConst.CardFace.BACK) {
            if (this.cardIndex.getIndexedInstance().isState(16384)) {
                aniFlip.setRotationOffset(new Vector3D(0.0, 0.0, -90.0));
            }
            this.cardIndex.getIndexedInstance().resetStats();
            this.cardIndex.setUnderType(GameConst.CardUnderType.ZONE_GENERIC);
        }
        this.cardIndex.setCardFace(this.cardFace);
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(() -> {
            if (this.cardFace == CardConst.CardFace.BACK) {
                zone.getZoneUnderCardsIndicators().addUnderType(GameConst.CardUnderType.ZONE_GENERIC);
                this.cardIndex.setUnderType(GameConst.CardUnderType.ZONE_GENERIC);
            } else {
                zone.getZoneUnderCardsIndicators().removeUnderType(this.cardIndex.getUnderType());
                this.cardIndex.setUnderType(GameConst.CardUnderType.NONE);
                this.cardIndex.resetOverrideLocation();
                Game.getCurrentGame().getGameRules().getEffectProcessor().addConstantUpdatePostProcessingJob(() -> FX.run(() -> {
                    if (this.cardIndex.getZoneByLocation() == zone) {
                        ((ZoneSIGNI)zone).resetListeners();
                        zone.updateZone(null);
                    }
                }));
            }
            this.setAsCompleted();
        });
        aniFlip.setAnimationTracker(tracker);
        aniFlip.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.assignCardFromShortPacketData(pp.getDataArgument(1), this.cardIndex.getSourceCard3D());
    }
}

