/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ModifiableDouble;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.EventPowerChanged;
import open.batoru.game.animations.AnimationWait;
import open.batoru.game.overlay.log.events.LogEventPowerChanged;

public class ActionGainPower
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;
    private final double addValue;
    private final ChronoDuration chronoDuration;

    public ActionGainPower(CardIndex cardIndex, double addValue, ChronoDuration chronoDuration) {
        this.cardIndex = cardIndex;
        this.addValue = addValue;
        this.chronoDuration = chronoDuration;
    }

    @Override
    protected void dispatch() {
        if (this.addValue == 0.0 || !GameConst.CardLocation.isSIGNI(this.cardIndex.getLocation()) || this.cardIndex.getIndexedInstance() == null || this.getSourceAbility() != null && (this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.cardIndex, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_POWER_BE_CHANGED).check(this.cardIndex, this, this.addValue) == RuleCheck.RuleCheckState.BLOCK)) {
            this.setAsCompleted();
            return;
        }
        ModifiableDouble power = this.cardIndex.getIndexedInstance().getPower();
        double oldValue = power.getValue();
        power.setSourceAbility(this.getSourceAbility());
        ModifiableVariable.ModifiableValueReference<Double> addValueReference = power.addValue(this.addValue);
        this.getDataTable().add(this.cardIndex);
        if (this.getSourceCost() != null) {
            this.getSourceCost().addPaidData(new AbilityCost.EmptyPayable());
        }
        EventPowerChanged event = new EventPowerChanged(this.cardIndex, this.getSourceAbility(), this.getSourceCost(), power.getValue(), addValueReference.value());
        event.setAtOnce(this);
        this.setLogEvent(new LogEventPowerChanged(event, oldValue));
        if (oldValue > 0.0) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(event);
        }
        ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(this.cardIndex, this.chronoDuration);
        record.setOnChronoRecordExpired(() -> power.removeValue(addValueReference));
        Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        if (event.getNewValue() > 0.0 || !this.isLastAtOnce()) {
            this.setAsCompleted();
        } else {
            AnimationWait aniWait = new AnimationWait(200);
            aniWait.setOnAnimationFinished(this::setAsCompleted);
            aniWait.play();
        }
    }
}

