/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldZoneNotificationCollaboLiver;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardEmojiSpray;
import open.batoru.ui.UI;

public class ActionInviteCollaboLivers
extends GameAction<Boolean> {
    private final Game.GamePlayerRole rolePlayer;
    private final int count;

    public ActionInviteCollaboLivers(Game.GamePlayerRole rolePlayer, int count) {
        this.rolePlayer = rolePlayer;
        this.count = count;
    }

    @Override
    protected void dispatch() {
        if (this.count == 0) {
            this.setAsCompleted();
            return;
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer);
        Card3D card3DLRIG = field.getLRIGZone().getTopCard();
        int oldValue = field.getData().getCollaboLivers();
        field.getData().setCollaboLivers(oldValue + this.count);
        if (oldValue == 0) {
            FieldZoneNotificationCollaboLiver zoneNotification = new FieldZoneNotificationCollaboLiver();
            field.getLRIGZone().setNotificationCollaboLivers(zoneNotification);
            if (field.getLRIGZone().isFlipped()) {
                zoneNotification.setAsFlipped();
            }
            zoneNotification.setValue(field.getData().getCollaboLivers());
            zoneNotification.setTranslate(field.getLRIGZone().getNode().getTransX() + zoneNotification.getTransX(), field.getLRIGZone().getNode().getTransY() + zoneNotification.getTransY());
            field.getChildren().add((Object)zoneNotification);
        } else if (field.getData().getCollaboLivers() > 0) {
            field.getLRIGZone().getNotificationCollaboLiver().setValue(field.getData().getCollaboLivers());
        } else {
            field.getChildren().remove((Object)field.getLRIGZone().getNotificationCollaboLiver());
            field.getLRIGZone().setNotificationCollaboLivers(null);
        }
        this.getDataTable().add(true);
        if (this.getSourceCost() != null) {
            this.getSourceCost().addPaidData(new AbilityCost.EmptyPayable());
        }
        if (field.getData().getCollaboLivers() < oldValue) {
            AnimationCardEmojiSpray aniSpray = new AnimationCardEmojiSpray(card3DLRIG, 6, 9, 289, 409, 360, 720, 0, 0);
            aniSpray.play();
        }
        this.setAsCompleted();
    }
}

