/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Button;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.Ability;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowChoice;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;

public class ActionManualChoice
extends GameAction<Integer> {
    private String titleWindow;
    private final Ability sourceAbility;
    private final List<String> listOptions = new ArrayList<String>();
    private boolean isLocked;

    public ActionManualChoice(Ability sourceAbility) {
        this.sourceAbility = sourceAbility;
    }

    public ActionManualChoice(Ability sourceAbility, String titleWindow) {
        this(sourceAbility);
        this.titleWindow = titleWindow;
    }

    public ActionManualChoice(Ability sourceAbility, String ... options) {
        this(sourceAbility);
        this.listOptions.addAll(List.of(options));
    }

    public void setLocked(boolean set) {
        this.isLocked = set;
    }

    @Override
    protected void dispatch() {
        OverlayWindowChoice window = new OverlayWindowChoice(this.titleWindow, this.sourceAbility, this.listOptions);
        if (this.isLocked) {
            for (int i = 0; i < window.getButtonsList().size() - 1; ++i) {
                window.getButtonsList().get(i).setDisable(true);
            }
        }
        this.addWindowActions(window);
    }

    final void addWindowActions(OverlayWindowChoice window) {
        int i = 0;
        for (Button button : window.getButtonsList()) {
            int refI = ++i;
            button.setOnAction(e -> {
                Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
                for (Button listButton : window.getButtonsList()) {
                    listButton.setDisable(true);
                }
                try {
                    GameSendActionAttempt attempt = new GameSendActionAttempt("PLCH", this, String.valueOf(refI));
                    Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                        Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                        OverlayWindow.removeFromFieldOverlay(window);
                        this.getDataTable().add(refI);
                        this.setAsCompleted();
                    });
                    attempt.send();
                }
                catch (UnknownHostException ex) {
                    Log.printMessage(ex);
                }
            });
        }
        OverlayWindow.addToFieldOverlay(window);
    }

    final List<String> getListOptions() {
        return this.listOptions;
    }
}

