/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.Ability;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowEffectUseOverride;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;

public class ActionManualChoiceAbility
extends GameAction<Integer> {
    public static final int ABILITY_CHOICE_SKIPPED = -1;
    private final List<Ability> listAbilities;
    private final boolean allowSkip;

    public ActionManualChoiceAbility(List<Ability> listAbilities, boolean allowSkip) {
        this.listAbilities = listAbilities;
        this.allowSkip = allowSkip;
    }

    @Override
    protected void dispatch() {
        OverlayWindowEffectUseOverride window = new OverlayWindowEffectUseOverride(this.listAbilities, this.allowSkip);
        window.setOnAbilityChosen(arrayId -> {
            Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
            window.setLock(true);
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("PLCH", this, String.valueOf(arrayId));
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.getDataTable().add(arrayId);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }
}

