/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.DataTable;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowChoiceDistribute;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;

public class ActionManualChoiceDistribute
extends GameAction<Integer> {
    private final DataTable<CardIndex> data;
    private final int total;

    public ActionManualChoiceDistribute(DataTable<CardIndex> data, int total) {
        this.data = data;
        this.total = total;
    }

    @Override
    protected void dispatch() {
        OverlayWindowChoiceDistribute window = new OverlayWindowChoiceDistribute(this.data, this.total);
        window.getConfirmButton().setOnAction(e -> {
            window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
            window.setLock(true);
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("PLCH", this, window.exportChoicesAsPacketData());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    window.applyChoicesToDataTable(this.getDataTable());
                    Game.getCurrentGame().getPlayerControl().setPlayerLock(false);
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        if (Game.getCurrentGame().getFakeReceiver() == null && this.data.size() == 1) {
            window.getConfirmButton().fire();
        } else {
            OverlayWindow.addToFieldOverlay(window);
        }
    }
}

