/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import javafx.geometry.Insets;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.PlayerHand;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualChoiceHand
extends GameAction<CardIndex> {
    private int minPicks;
    private int maxPicks;

    public ActionManualChoiceHand(int minPicks, int maxPicks) {
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
    }

    @Override
    protected void dispatch() {
        PlayerHand hand = UI.getTabGame().getFieldScene().getGameField().getTopPlayerField().getHand();
        if (hand.getTotalCards() == 0) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        if (this.maxPicks > hand.getTotalCards()) {
            this.maxPicks = hand.getTotalCards();
        }
        if (this.minPicks > this.maxPicks) {
            this.minPicks = this.maxPicks;
        }
        ArrayList<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
        for (Card3D card3D2 : hand.getZoneCardList()) {
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(card3D2, TargetFilter.TargetHint.DISCARD);
            aniBorder.play();
            listAniBorder.add(aniBorder);
        }
        OverlayWindowCard window = new OverlayWindowCard(null, LanguageParser.getString("UI_GAME_WINDOW_HAND_DESC"), this.minPicks, this.maxPicks);
        window.setPadding(new Insets(200.0, 0.0, 0.0, 0.0));
        window.setPickOnBounds(false);
        if (this.minPicks == 1 && this.maxPicks == 1) {
            window.setAutoConfirm(true);
        }
        CardPicker picker = new CardPicker(this.minPicks, this.maxPicks);
        picker.setOnPickValidate(hand::isCardInHand);
        picker.setOnPickHandled((card3D, wasAdded) -> {
            window.updatePickedCount(picker.getPickedCount(), picker);
            if (hand.getHandHoverAnimation((Card3D)card3D) != null) {
                hand.getHandHoverAnimation((Card3D)card3D).setLock(wasAdded);
            }
        });
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
        window.getConfirmButton().setOnAction(e -> {
            window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELCH", this, String.valueOf(picker.getPickedCount()));
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofSimpleGameAction(this.getOrderId()), pp -> {
                    AnimationBorderIcon.stopAll(listAniBorder);
                    for (Card3D card3D : picker.getPickedList()) {
                        card3D.getCardMeshBack().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                        this.getDataTable().add(card3D.getCardIndex());
                        hand.markCardAsChosen(card3D);
                    }
                    if (this.getDataTable().isEmpty()) {
                        this.getDataTable().add(null);
                    }
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        OverlayWindow.addToFieldOverlay(window);
    }
}

