/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringJoiner;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionDiscard;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.AbilityConst;
import open.batoru.game.PlayerField;
import open.batoru.game.PlayerHand;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualDiscard
extends GameAction<CardIndex> {
    private final TargetFilter filter;
    private final ConditionHandler<CardIndex> condition;
    private int minPicks;
    private final int maxPicks;
    private final AbilityConst.ChoiceLogic choiceLogic;
    private boolean autoConfirm;

    public ActionManualDiscard(int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
        this.choiceLogic = choiceLogic;
        this.filter = filter;
        this.condition = condition;
    }

    public void setAutoConfirm(boolean set) {
        this.autoConfirm = set;
    }

    @Override
    protected void dispatch() {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
        PlayerHand hand = field.getHand();
        if (this.minPicks == 0 && this.maxPicks == 0 || hand.getTotalCards() == 0 || this.choiceLogic == AbilityConst.ChoiceLogic.BOOLEAN && hand.getTotalCards() < this.maxPicks || this.getSourceCost() != null && hand.getTotalCards() < this.minPicks) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        if (this.minPicks > hand.getTotalCards()) {
            this.minPicks = hand.getTotalCards();
        }
        TargetFilter.TargetHint hintTargetType = this.getSourceCost() == null ? TargetFilter.TargetHint.DISCARD : this.getSourceCost().getDefaultTargetHintType();
        ArrayList<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
        boolean wasBlocked = false;
        for (Card3D card3D2 : hand.getZoneCardList()) {
            if (!this.isPickValid(card3D2)) continue;
            if (!this.canBeDiscarded(card3D2)) {
                wasBlocked = true;
                continue;
            }
            AnimationBorderIcon aniBorder = new AnimationBorderIcon(card3D2, hintTargetType);
            aniBorder.play();
            listAniBorder.add(aniBorder);
        }
        if (listAniBorder.isEmpty() && this.minPicks != 0) {
            this.minPicks = 0;
        }
        OverlayWindowCard window = hintTargetType != TargetFilter.TargetHint.GUARD ? new OverlayWindowCard(TargetFilter.TargetHint.DISCARD.getActionDescription(), LanguageParser.getString("UI_GAME_WINDOW_DISCARD_DESC"), this.minPicks, this.maxPicks, this.choiceLogic) : new OverlayWindowCard(TargetFilter.TargetHint.GUARD.getActionDescription(), LanguageParser.getString("UI_GAME_WINDOW_GUARD_DESC"), this.minPicks, this.maxPicks, this.choiceLogic);
        if (this.minPicks == 1 && this.maxPicks == 1 || this.autoConfirm) {
            window.setAutoConfirm(true);
        }
        CardPicker picker = new CardPicker(this.minPicks, this.maxPicks, listAniBorder);
        picker.setValidateCondition(this.condition);
        picker.setOnPickValidate(card3D -> hand.isCardInHand((Card3D)card3D) && this.isPickValid((Card3D)card3D) && this.canBeDiscarded((Card3D)card3D));
        picker.setOnPickHandled((card3D, wasAdded) -> {
            window.updatePickedCount(picker.getPickedCount(), picker);
            if (hand.getHandHoverAnimation((Card3D)card3D) != null) {
                hand.getHandHoverAnimation((Card3D)card3D).setLock(wasAdded);
            }
        });
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
        window.getConfirmButton().setOnAction(e -> {
            window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
            StringJoiner packetData = new StringJoiner("|");
            if (picker.getPickedCount() > 0) {
                for (Card3D card3D : picker.getPickedList()) {
                    if (Game.getCurrentGame().getFakeReceiver() == null) {
                        hand.markCardAsChosen(card3D);
                        hand.swapWithKnownAlternativeIfAvailable(card3D);
                    }
                    packetData.add(String.valueOf(card3D.getCardIndex().getId()));
                }
            } else {
                packetData.setEmptyValue(String.valueOf(0));
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELC", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    AnimationBorderIcon.stopAll(listAniBorder);
                    if (picker.getPickedCount() > 0) {
                        for (Card3D card3D : picker.getPickedList()) {
                            card3D.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                            this.getDataTable().add(card3D.getCardIndex());
                        }
                        ActionDiscard actionDiscard = new ActionDiscard(this.getDataTable());
                        actionDiscard.dispatchAsChild(this);
                    } else {
                        this.getDataTable().add(null);
                        this.setAsCompleted();
                    }
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(window);
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        if (Game.getCurrentGame().getFakeReceiver() == null && (listAniBorder.isEmpty() && wasBlocked || this.getSourceCost() != null && this.getSourceCost().getCostMinCount() == hand.getTotalCards())) {
            for (AnimationBorderIcon icon : listAniBorder) {
                picker.pick(icon.getSourceCard3D());
            }
            window.getConfirmButton().fire();
        } else {
            OverlayWindow.addToFieldOverlay(window);
        }
    }

    private boolean isPickValid(Card3D card3D) {
        return this.filter == null || this.filter.isPickValid(card3D);
    }

    private boolean canBeDiscarded(Card3D card3D) {
        return card3D.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(card3D.getCardIndex(), this, new Object[]{GameConst.CardLocation.TRASH}) == RuleCheck.RuleCheckState.OK;
    }
}

