/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEnerPay;
import open.batoru.core.gameplay.pickers.EnerColorPicker;
import open.batoru.core.gameplay.rulechecks.DataTableRuleCheck;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;
import open.batoru.data.Cost;
import open.batoru.data.DataTable;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.game.FieldZoneEnerGroup;
import open.batoru.game.ZoneEner;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game._3d.EnerColor;
import open.batoru.game.animations.AnimationCardMoveInsertEnerSubstitute;
import open.batoru.game.animations.AnimationCardMoveRemoveEnerSubstitute;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowEnerCost;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualEnerPay
extends GameAction<ActionEnerPay.PaidEnerData> {
    private final List<FieldZoneEnerGroup> listEnerGroups = new ArrayList<FieldZoneEnerGroup>();
    private List<Card3DSubstitute> listEnerSubstitutes;
    private String originalCostString;
    private final boolean isMandatory;

    public ActionManualEnerPay(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    @Override
    protected void dispatch() {
        EnerCost cost;
        AbilityCost abilityCost = this.getSourceCost();
        if (!(abilityCost instanceof EnerCost) || !(cost = (EnerCost)abilityCost).canBePaid()) {
            this.setAsCompleted();
            return;
        }
        this.originalCostString = cost.getCostString().getValue();
        DataTable<String> dataAvailablePayCostStrings = new DataTable<String>();
        dataAvailablePayCostStrings.add(this.originalCostString);
        if (!this.originalCostString.isEmpty()) {
            DataTableRuleCheck ruleCheckDataAltPayCosts = (DataTableRuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.getCurrentGame().getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.DATA_COSTS_ENER_ALT_PAY);
            dataAvailablePayCostStrings.addAll((DataTable)ruleCheckDataAltPayCosts.check(Game.getCurrentGame().getPlayerRole(), this.getSourceCardIndex(), this.getSourceAbility(), cost));
            dataAvailablePayCostStrings.removeDuplicates();
            DataTableRuleCheck ruleCheckDataEnerSubstitute = (DataTableRuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.getCurrentGame().getPlayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.DATA_CARDS_ENER_SUBSTITUTE);
            DataTable cardsEnerSubstitute = (DataTable)ruleCheckDataEnerSubstitute.check(Game.getCurrentGame().getPlayerRole(), this, new Object[0]);
            if (!cardsEnerSubstitute.isEmpty()) {
                this.listEnerSubstitutes = new ArrayList<Card3DSubstitute>();
                AnimationTracker tracker = new AnimationTracker(cardsEnerSubstitute.size());
                tracker.setOnTrackerAllFinished(() -> this.dispatchPay(dataAvailablePayCostStrings));
                TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
                for (int i = 0; i < cardsEnerSubstitute.size(); ++i) {
                    Card3D card3D = ((CardIndex)cardsEnerSubstitute.get(i)).getSourceCard3D();
                    Card3DSubstitute card3DSubstitute = new Card3DSubstitute(card3D);
                    this.listEnerSubstitutes.add(card3DSubstitute);
                    AnimationCardMoveInsertEnerSubstitute aniInsert = new AnimationCardMoveInsertEnerSubstitute(card3DSubstitute, UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getEnerZone());
                    aniInsert.setAnimationTracker(tracker);
                    seqAni.getAnimationList().add(aniInsert);
                }
                seqAni.play();
                return;
            }
        }
        this.dispatchPay(dataAvailablePayCostStrings);
    }

    private void dispatchPay(DataTable<String> dataAvailablePayCostStrings) {
        if (!this.originalCostString.isEmpty()) {
            this.resetEnerGroups(this.originalCostString);
        }
        OverlayWindowEnerCost window = new OverlayWindowEnerCost(LanguageParser.getString("UI_GAME_WINDOW_PAY_TITLE"), this.getSourceAbility() != null ? LanguageParser.getString("UI_GAME_WINDOW_PAY_DESC") : null, this.listEnerGroups, dataAvailablePayCostStrings, this.getSourceCost().getSourceCardIndex(), this.isMandatory);
        EnerColorPicker picker = new EnerColorPicker(this.originalCostString, this.listEnerGroups);
        if (dataAvailablePayCostStrings.size() > 1) {
            window.setOnPayCostChanged(costString -> {
                picker.setCostString(costString);
                this.resetEnerGroups(costString);
                window.updateEnerGroups();
            });
        }
        picker.setValidateCondition(listPickedCards -> Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.getSourceCost().getPayerRole()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_PAY_ENER).check(this.getSourceCost().getPayerRole(), this, this.originalCostString, listPickedCards) == RuleCheck.RuleCheckState.OK);
        picker.setOnPickHandled((enerColor, wasAdded) -> window.updatePickedCount(picker.getPickedCount(), enerColor.getColor(), picker));
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
        window.getConfirmButton().setOnAction(e -> {
            window.getConfirmButton().setDisable(true);
            window.disableToggleControls(true);
            Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
            StringBuilder packetData = new StringBuilder();
            for (int i = 0; i < picker.getPickedList().size(); ++i) {
                EnerColor enerColor = (EnerColor)((Object)((Object)picker.getPickedList().get(i)));
                packetData.append(enerColor.getSourceEnerGroup().getSourceCard3D().getCardIndex().getId()).append("|").append(enerColor.getColor().getShortLabel()).append("|");
            }
            if (packetData.isEmpty()) {
                packetData = new StringBuilder(String.valueOf(0));
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("PAY", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    if (picker.getPickedCount() > 0) {
                        ArrayList<ActionEnerPay.PaidEnerData> listPaidEnerData = new ArrayList<ActionEnerPay.PaidEnerData>();
                        for (int i = 0; i < this.listEnerGroups.size(); ++i) {
                            FieldZoneEnerGroup enerGroup = this.listEnerGroups.get(i);
                            enerGroup.getSourceCard3D().getChildren().remove((Object)enerGroup);
                            if (enerGroup.getSelectedEnerColor() == null) {
                                this.listEnerGroups.remove(i--);
                                continue;
                            }
                            listPaidEnerData.add(new ActionEnerPay.PaidEnerData(new CardIndexSnapshot(enerGroup.getSourceCard3D().getCardIndex()), enerGroup.getSelectedEnerColor().getColor()));
                        }
                        ActionEnerPay actionPayEner = new ActionEnerPay(listPaidEnerData);
                        actionPayEner.dispatchAsChild(this);
                    } else {
                        for (FieldZoneEnerGroup enerGroup : this.listEnerGroups) {
                            enerGroup.getSourceCard3D().getChildren().remove((Object)enerGroup);
                        }
                        if (this.listEnerSubstitutes == null || this.listEnerSubstitutes.isEmpty()) {
                            this.setAsCompleted();
                        } else {
                            AnimationTracker tracker = new AnimationTracker(this.listEnerSubstitutes.size());
                            tracker.setOnTrackerAllFinished(this::setAsCompleted);
                            TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
                            for (Card3DSubstitute card3DSubstitute : this.listEnerSubstitutes) {
                                AnimationCardMoveRemoveEnerSubstitute aniMove = new AnimationCardMoveRemoveEnerSubstitute(card3DSubstitute, UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getEnerZone());
                                aniMove.setAnimationTracker(tracker);
                                seqAni.getAnimationList().add(aniMove);
                            }
                            seqAni.play();
                        }
                    }
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(window);
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        if (!this.listEnerGroups.isEmpty() || dataAvailablePayCostStrings.size() > 1) {
            OverlayWindow.addToFieldOverlay(window);
        } else {
            window.getConfirmButton().fire();
        }
    }

    private void resetEnerGroups(String costString) {
        if (!this.listEnerGroups.isEmpty()) {
            for (FieldZoneEnerGroup enerGroup : this.listEnerGroups) {
                if (enerGroup.getSelectedEnerColor() != null) {
                    enerGroup.toggleSelect(enerGroup.getSelectedEnerColor());
                }
                enerGroup.getSourceCard3D().getChildren().remove((Object)enerGroup);
            }
            this.listEnerGroups.clear();
        }
        String costStringUnique = Cost.getUniqueCostString(costString);
        ZoneEner zoneEner = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getEnerZone();
        for (Card3D card3D : zoneEner.getZoneCardList()) {
            CardIndex cardIndex = card3D.getCardIndex();
            FieldZoneEnerGroup enerGroup = new FieldZoneEnerGroup(card3D);
            EnerCost.ColorPayFilter colorPayFilter = ((EnerCost)this.getSourceCost()).getColorPayFilter();
            for (int i = costStringUnique.length() - 1; i >= 0; --i) {
                CardConst.CardColor color = CardConst.CardColor.getColorByShortLabel(costStringUnique.charAt(i));
                CardDataColor filteredData = colorPayFilter == null ? null : colorPayFilter.getData(color);
                boolean match = filteredData == null ? this.canPayColor(cardIndex, color) : filteredData.getValue().stream().anyMatch(c -> this.canPayColor(cardIndex, (CardConst.CardColor)((Object)c)));
                if (!match) continue;
                enerGroup.addEnerColor(color);
            }
            if (enerGroup.getEnerColorsList().isEmpty()) continue;
            this.listEnerGroups.addFirst(enerGroup);
            card3D.getChildren().addFirst((Object)enerGroup);
        }
    }

    private boolean canPayColor(CardIndex cardIndex, CardConst.CardColor color) {
        return cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_PAY_COLOR).check(cardIndex, this, new Object[]{color}) == RuleCheck.RuleCheckState.OK;
    }
}

