/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringJoiner;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionPutOnFieldResona;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualPutOnFieldResona
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;

    public ActionManualPutOnFieldResona(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null) {
            this.setAsCompleted();
            return;
        }
        if (this.cardIndex.getLocation() != GameConst.CardLocation.CHECK_ZONE) {
            AnimationTracker tracker = new AnimationTracker(1);
            tracker.setOnTrackerAllFinished(this::dispatchPlayCondition);
            AnimationCardMove aniMove = new AnimationCardMove(this.cardIndex.getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndex.getIndexedInstance().getCurrentOwner()).getCheckZone());
            aniMove.setAnimationTracker(tracker);
            aniMove.play();
        } else {
            this.dispatchPlayCondition();
        }
    }

    private void dispatchPlayCondition() {
        AnimationBorderIcon aniBorder = new AnimationBorderIcon(this.cardIndex.getSourceCard3D().getOwnerZone(), TargetFilter.TargetHint.RESONA);
        aniBorder.play();
        OverlayWindowCard window = new OverlayWindowCard(TargetFilter.TargetHint.RESONA.getActionDescription(), LanguageParser.getString("UI_GAME_WINDOW_RESONA_DESC"), this.cardIndex.getIndexedInstance().getUseConditionNumPicks(), this.cardIndex.getIndexedInstance().getUseConditionNumPicks());
        OverlayWindowCard.addToFieldOverlay(window);
        ArrayList<AnimationBorderIcon> listAniBorder = new ArrayList<AnimationBorderIcon>();
        listAniBorder.add(aniBorder);
        for (GameConst.CardLocation location : this.cardIndex.getIndexedInstance().getUseConditionTargetFilter().getHintLocationsData()) {
            Zone zone = FieldData.getZoneByLocation(this.cardIndex.getIndexedInstance().getCurrentOwner(), location);
            if (zone == null || zone.getZoneCardList().isEmpty()) continue;
            if (GameConst.CardLocation.isSIGNI(location) || GameConst.CardLocation.isLRIG(location) || location == GameConst.CardLocation.CHECK_ZONE) {
                FieldZone zoneField = (FieldZone)zone;
                if (!FieldZone.isOccupied(zoneField) || !this.cardIndex.getIndexedInstance().getUseConditionTargetFilter().isPickValid(zoneField.getTopCard())) continue;
                aniBorder = new AnimationBorderIcon(zone, TargetFilter.TargetHint.RESONA);
                aniBorder.play();
                listAniBorder.add(aniBorder);
                continue;
            }
            for (Card3D card3D2 : zone.getZoneCardList()) {
                if (!this.cardIndex.getIndexedInstance().getUseConditionTargetFilter().isPickValid(card3D2)) continue;
                aniBorder = new AnimationBorderIcon(card3D2, TargetFilter.TargetHint.RESONA);
                aniBorder.play();
                listAniBorder.add(aniBorder);
            }
        }
        CardPicker picker = new CardPicker(this.cardIndex.getIndexedInstance().getUseConditionNumPicks(), this.cardIndex.getIndexedInstance().getUseConditionNumPicks(), listAniBorder);
        picker.setOnPickValidate(this.cardIndex.getIndexedInstance().getUseConditionTargetFilter().getCardValidator());
        picker.setOnPickHandled((card3D, wasAdded) -> window.updatePickedCount(picker.getPickedCount()));
        Game.getCurrentGame().getPlayerControl().setCurrentPicker(picker);
        window.getConfirmButton().setOnAction(e -> {
            window.getConfirmButton().setDisable(true);
            Game.getCurrentGame().getPlayerControl().getCurrentPicker().setLock(true);
            StringJoiner packetData = new StringJoiner("|");
            for (Card3D card3D : picker.getPickedList()) {
                packetData.add(String.valueOf(card3D.getCardIndex().getId()));
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELC", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(!this.isChildAction() ? this.getOrderId() : Game.getCurrentGame().getActionQueue().getLastOrder()), pp -> {
                    AnimationBorderIcon.stopAll(listAniBorder);
                    for (Card3D card3D : picker.getPickedList()) {
                        card3D.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SELECTED.getAlias());
                    }
                    ActionPutOnFieldResona actionPutOnFieldResona = new ActionPutOnFieldResona(this.cardIndex, picker.getPickedList().toArray(new Card3D[0]));
                    actionPutOnFieldResona.dispatchAsChild(this);
                    Game.getCurrentGame().getPlayerControl().setCurrentPicker(null);
                    OverlayWindow.removeFromFieldOverlay(window);
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        if (Game.getCurrentGame().getFakeReceiver() != null) {
            Game.getCurrentGame().getFakeReceiver().processEnd();
            window.getConfirmButton().fire();
        }
    }
}

