/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.StringJoiner;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.events.EventTarget;
import open.batoru.game.FieldData;
import open.batoru.game._3d.Card3D;
import open.batoru.game.overlay.OverlayAlertMessage;
import open.batoru.game.overlay.log.events.LogEventTarget;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCardList;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionManualSearchDeck
extends GameAction<CardIndex> {
    private final int minPicks;
    private final int maxPicks;
    private final TargetFilter filter;
    private final ConditionHandler<CardIndex> condition;
    private final Game.GamePlayerRole rolePlayer;
    private final GameConst.CardLocation location;
    private CheckBox checkBoxIsPlayable;

    public ActionManualSearchDeck(int minPicks, int maxPicks, TargetFilter filter, ConditionHandler<CardIndex> condition, Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
        this.filter = filter;
        this.condition = condition;
        this.rolePlayer = rolePlayer;
        this.location = location;
    }

    @Override
    protected void dispatch() {
        if (this.minPicks == 0 && this.maxPicks == 0) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        int countValid = this.filter.getValidTargetsCount();
        if (countValid == 0 || countValid < this.minPicks) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_TARGETS"), Color.RED, 600);
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        Game.GamePlayerRole rolePlayerFilter = this.filter.getHintOwnerFlags() == 3 ? this.rolePlayer : (this.filter.getHintOwnerFlags() == 1 && this.rolePlayer == Game.getCurrentGame().getPlayerRole() ? Game.getCurrentGame().getPlayerRole() : Game.GamePlayerRole.getOpponentRole(Game.getCurrentGame().getPlayerRole()));
        OverlayWindowCardList window = new OverlayWindowCardList(LanguageParser.getString("UI_GAME_WINDOW_SEARCH_TITLE") + (this.rolePlayer == Game.getCurrentGame().getPlayerRole() ? "" : LanguageParser.getString("UI_GAME_WINDOW_SEARCH_TITLE_OP")) + (this.location == GameConst.CardLocation.TRASH || this.location == GameConst.CardLocation.TRASH_LRIG ? TargetFilter.TargetHint.TRASH.getActionDescription() : LanguageParser.getString("UI_GAME_WINDOW_SEARCH_TITLE_DECK")), this.filter.getHintTargetType().getActionDescription(), FieldData.getZoneByLocation(rolePlayerFilter, this.location).getZoneCardList(), this.filter.getCardValidator(), this.condition, this.minPicks, this.maxPicks);
        if (this.location != GameConst.CardLocation.DECK_LRIG && this.location != GameConst.CardLocation.TRASH_LRIG) {
            window.enableCardSorting();
        }
        if (this.minPicks > 0 && (this.filter.getHintFilterFlags() & 1) != 0) {
            StackPane containerCheckBox = new StackPane();
            containerCheckBox.setAlignment(Pos.CENTER_LEFT);
            containerCheckBox.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
            this.checkBoxIsPlayable = new CheckBox(LanguageParser.getString("UI_GAME_WINDOW_CHECKBOX_PLAYABLE"));
            this.checkBoxIsPlayable.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
            this.checkBoxIsPlayable.setTextFill((Paint)Color.KHAKI);
            this.checkBoxIsPlayable.setSelected(true);
            this.checkBoxIsPlayable.setOnAction(e -> {
                this.filter.setHintFilterFlags(this.filter.getHintFilterFlags() ^ 1);
                window.updateList();
            });
            containerCheckBox.getChildren().add((Object)this.checkBoxIsPlayable);
            HBox.setMargin((Node)containerCheckBox, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            window.getContentInfoNode().getChildren().addFirst((Object)containerCheckBox);
        }
        if (this.minPicks == 1 && this.maxPicks == 1) {
            window.setAutoConfirm(true);
        }
        window.getConfirmButton().setOnAction(e -> {
            if (this.checkBoxIsPlayable != null) {
                this.checkBoxIsPlayable.setDisable(true);
            }
            window.setLock(true);
            window.getConfirmButton().setDisable(true);
            StringJoiner packetData = new StringJoiner("|");
            if (window.getPickedCount() > 0) {
                for (int i = 0; i < window.getPickedCount(); ++i) {
                    packetData.add(String.valueOf(window.getPickedList().get(i).getCardIndex().getId()));
                }
            } else {
                packetData.setEmptyValue(String.valueOf(0));
                this.getDataTable().add(null);
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SEARCH", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofGameAction(this.getOrderId()), pp -> {
                    for (Card3D card3D : window.getPickedList()) {
                        this.getDataTable().add(card3D.getCardIndex());
                    }
                    if (this.filter.isTargeted() && this.getDataTable().get() != null) {
                        for (int i = 0; i < this.getDataTable().size(); ++i) {
                            UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().setEffectChosenTarget(this.getSourceAbility(), this.filter.getSourceTargetRole(), (CardIndex)this.getDataTable().get(i));
                            EventTarget event = new EventTarget((CardIndex)this.getDataTable().get(i), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), this.filter.getSourceTargetRole());
                            event.setAtOnce(i, this.getDataTable().size());
                            if (this.getSourceCost() == null) {
                                this.setLogEvent(new LogEventTarget(event));
                            }
                            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(event);
                        }
                        Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
                    }
                    OverlayWindow.removeFromFieldOverlay(window);
                    this.setAsCompleted();
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        if ((this.location == GameConst.CardLocation.TRASH || this.location == GameConst.CardLocation.TRASH_LRIG) && window.getTotalValidTargets() == 0) {
            OverlayAlertMessage.show(LanguageParser.getString("UI_GAME_ALERT_TARGETS"), Color.RED, 600);
            window.getConfirmButton().fire();
        } else {
            OverlayWindow.addToFieldOverlay(window);
        }
    }
}

