/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.DataTable;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventTrash;
import open.batoru.game.GameField;
import open.batoru.game.ZoneDeck;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.ui.UI;

public class ActionMillDeck
extends GameAction<CardIndex> {
    private final Game.GamePlayerRole rolePlayer;
    private DataTable<CardIndex> dataDeckInfo;
    private final Deck.DeckPosition position;

    public ActionMillDeck(Game.GamePlayerRole rolePlayer, DataTable<CardIndex> dataDeckInfo, Deck.DeckPosition position) {
        this.rolePlayer = rolePlayer;
        this.dataDeckInfo = dataDeckInfo;
        this.position = position;
    }

    public ActionMillDeck(Game.GamePlayerRole rolePlayer, Deck.DeckPosition position) {
        this(rolePlayer, null, position);
    }

    public void setDataDeckInfo(DataTable<CardIndex> dataDeckInfo) {
        this.dataDeckInfo = dataDeckInfo;
    }

    @Override
    protected void dispatch() {
        int i;
        if (this.dataDeckInfo == null || this.dataDeckInfo.isEmpty() || this.dataDeckInfo.get() == null) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        AnimationTracker tracker = new AnimationTracker(this.dataDeckInfo.size());
        tracker.setOnTrackerAllFinished(() -> {
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
            if (this.getSourceCost() != null && this.getDataTable().get() != null) {
                for (int i = 0; i < this.getDataTable().size(); ++i) {
                    this.getSourceCost().addPaidCardIndexData((CardIndex)this.getDataTable().get(i));
                }
            }
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            this.setAsCompleted();
        });
        GameField field = UI.getTabGame().getFieldScene().getGameField();
        ZoneDeck zoneDeck = field.getPlayerFieldByRole(this.rolePlayer).getDeckZone(Deck.DeckType.MAIN);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        for (i = 0; i < this.dataDeckInfo.size(); ++i) {
            Card3D card3D;
            Card3D card3D2 = card3D = this.position == Deck.DeckPosition.TOP ? zoneDeck.getTopCard(i) : zoneDeck.getBottomCard(i);
            if (card3D == null || card3D.getCardIndex().getIndexedInstance() == null) {
                if (this.getDataTable().isEmpty()) {
                    this.getDataTable().add(null);
                }
                tracker.setMaxCount(0);
                return;
            }
            this.getDataTable().add(card3D.getCardIndex());
            AnimationCardMove aniMove = new AnimationCardMove(card3D, field.getPlayerFieldByRole(this.rolePlayer).getTrashZone(Deck.DeckType.MAIN));
            aniMove.setOnAnimationStarted(() -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(card3D.getCardIndex()));
            aniMove.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniMove);
        }
        if (this.getDataTable().get() != null) {
            for (i = 0; i < this.getDataTable().size(); ++i) {
                EventTrash eventTrash = new EventTrash((CardIndex)this.getDataTable().get(i), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost());
                eventTrash.setAtOnce(i, this.getDataTable().size());
                this.setLogEvent(new LogEventMove(eventTrash, GameConst.CardLocation.TRASH, AbilityConst.ActionHint.TRASH));
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventTrash);
            }
        }
        seqAni.play();
    }
}

