/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.game.GameField;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionOpenLRIG
extends GameAction<Void> {
    private int numOPLRIGDeckCards;
    private boolean isOwnUsingAssistLRIG;
    private boolean isOPUsingAssistLRIG;
    private Card3D cacheOwnCard3DCenterLRIG;
    private Card3D[] cacheOwnCard3DAssistLRIG;

    @Override
    protected void dispatch() {
        if (!this.isDataReceived()) {
            this.requestData(3);
            return;
        }
        GameField field = UI.getTabGame().getFieldScene().getGameField();
        if (!this.isOPUsingAssistLRIG) {
            UI.getTabGame().getFieldScene().getGameField().getTopPlayerField().collapseLRIGAssistZones();
        }
        if (!this.isOwnUsingAssistLRIG) {
            UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().collapseLRIGAssistZones();
        }
        for (int i = 0; i < this.numOPLRIGDeckCards; ++i) {
            field.initLRIGDeckCard(field.getTopPlayerField());
        }
        AnimationCardMove aniTop = new AnimationCardMove(field.getTopPlayerField().getDeckZone(Deck.DeckType.LRIG).getTopCard(), (Zone)field.getTopPlayerField().getDeckZone(Deck.DeckType.LRIG), field.getTopPlayerField().getLRIGZone());
        aniTop.play();
        if (this.isOPUsingAssistLRIG) {
            for (int i = 0; i < 2; ++i) {
                aniTop = new AnimationCardMove(field.getTopPlayerField().getDeckZone(Deck.DeckType.LRIG).getTopCard(i + 1), (Zone)field.getTopPlayerField().getDeckZone(Deck.DeckType.LRIG), i == 0 ? field.getTopPlayerField().getLRIGAssistZoneLeft() : field.getTopPlayerField().getLRIGAssistZoneRight());
                aniTop.play();
            }
        }
        AnimationCardMove aniBottom = new AnimationCardMove(this.cacheOwnCard3DCenterLRIG, (Zone)field.getBottomPlayerField().getDeckZone(Deck.DeckType.LRIG), field.getBottomPlayerField().getLRIGZone());
        aniBottom.play();
        if (this.cacheOwnCard3DAssistLRIG != null) {
            for (int i = 0; i < 2; ++i) {
                aniBottom = new AnimationCardMove(this.cacheOwnCard3DAssistLRIG[i], (Zone)field.getBottomPlayerField().getDeckZone(Deck.DeckType.LRIG), i == 0 ? field.getBottomPlayerField().getLRIGAssistZoneLeft() : field.getBottomPlayerField().getLRIGAssistZoneRight());
                aniBottom.play();
            }
        }
        this.setAsCompleted();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (pp.getDataArgument(2).contains("~")) {
            this.numOPLRIGDeckCards = Integer.parseInt(pp.getDataArgument(1));
            this.cacheOwnCard3DCenterLRIG = this.prepareOwnLRIGCard(pp.getDataArgument(2));
            for (int i = 3; i < pp.getDataArgsNum() - 3; ++i) {
                this.prepareOwnLRIGCard(pp.getDataArgument(i));
            }
        } else {
            Game.getCurrentGame().setAsNeutralPerspectiveGame();
            int numOwnLRIGDeckCards = Integer.parseInt(pp.getDataArgument(1));
            this.cacheOwnCard3DCenterLRIG = this.prepareOwnLRIGCard(null);
            for (int i = 1; i < numOwnLRIGDeckCards; ++i) {
                this.prepareOwnLRIGCard(null);
            }
            this.numOPLRIGDeckCards = Integer.parseInt(pp.getDataArgument(2));
        }
        this.isOwnUsingAssistLRIG = pp.getDataArgument(pp.getDataArgsNum() - 3).equals("1");
        if (this.isOwnUsingAssistLRIG) {
            this.cacheOwnCard3DAssistLRIG = new Card3D[2];
            this.cacheOwnCard3DAssistLRIG[0] = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getDeckZone(Deck.DeckType.LRIG).getBottomCard(1);
            this.cacheOwnCard3DAssistLRIG[1] = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getDeckZone(Deck.DeckType.LRIG).getBottomCard(2);
        }
        this.isOPUsingAssistLRIG = pp.getDataArgument(pp.getDataArgsNum() - 2).equals("1");
        if (this.isOPUsingAssistLRIG && Game.getCurrentGame().getGameServerPortOffset() != 0) {
            Game.getCurrentGame().getRoom().getPlayerData(Game.GamePlayerRole.getOpponentRole(Game.getCurrentGame().getPlayerRole())).getLRIGAssistLeftImageProperty().set(null);
            Game.getCurrentGame().getRoom().getPlayerData(Game.GamePlayerRole.getOpponentRole(Game.getCurrentGame().getPlayerRole())).getLRIGAssistRightImageProperty().set(null);
        }
        Game.GamePlayerRole rolePlayerFirst = Game.GamePlayerRole.getRoleById(Integer.parseInt(pp.getDataArgument(pp.getDataArgsNum() - 1)));
        Game.getCurrentGame().getGameRules().setStartingPlayer(rolePlayerFirst);
    }

    private Card3D prepareOwnLRIGCard(String data) {
        Card3D card3D = UI.getTabGame().getFieldScene().getGameField().initLRIGDeckCard(UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField());
        if (data != null) {
            CardIndex.assignCardFromShortPacketData(data, card3D);
        }
        return card3D;
    }
}

